!***********************************************************************
!
!
                          SUBROUTINE read_redsh
!
!
!***********************************************************************
!
!
!     Subroutine to read  the File out32.tab:
!
! List of the programmed output (in red-shift) corrected in position files
!
!=======================================================================

	 USE fly_h 

	IMPLICIT NONE
	INCLUDE 'mpif.h'
 
	
	REAL(KIND=4), DIMENSION(100) :: z32_sort,z32_ou_temp
	INTEGER(KIND=4)	:: z32_last_temp, i, j
	REAL(KIND=4)    ::z32_min,z32_max
!=======================================================================

	i = 0
	j = 0

	z32_sort=0.         
        z32_ou_temp=z32_ou
 	z32_last_temp=z32_last

        IF(me.eq.0) THEN
	OPEN(UNIT=upar35,FILE=fpar35,STATUS='OLD')
	
	do i=1,100
	READ(upar35,170,END=200) z32_ou(i)
	    IF(z32_ou(i).eq.0.0)z32_ou(i)=0.00001 
	enddo
	
	

200	CONTINUE
	nr_z32=i-1

	CLOSE(UNIT=upar35)

	ENDIF
	NLONG=1
	CALL MPI_Bcast(nr_z32, NLONG, MPI_INTEGER4, PE0, MPI_COMM_WORLD, ierror)
	NLONG=100
	CALL MPI_Bcast(z32_ou, NLONG, MPI_REAL4, PE0, MPI_COMM_WORLD, ierror)

!-----------------------------------------------------------------------------
!  Sort and Compute final values
!-----------------------------------------------------------------------------

	
	IF(nr_z32.lt.1) halt_sim=2  !Stop simulation: no output founded
	
	z32_min=z32_ou(1)
	
	do i=1,nr_z32
	   IF(z32_ou(i).lt.z32_min) THEN
	       z32_min=z32_ou(i)
	   ENDIF
	enddo

	z32_min=z32_min-1.0
	z32_last=0
	
	DO WHILE (.TRUE.)
	
	z32_max=z32_ou(1)
	
	do i=1,nr_z32
	   IF(z32_max.lt.z32_ou(i)) THEN
	      z32_max=z32_ou(i)
	   ENDIF   
	enddo

	IF(z32_max.eq.z32_min) EXIT
		
	do i=1,nr_z32
	   IF(z32_max.eq.z32_ou(i)) THEN
	      z32_ou(i)=z32_min
	   ENDIF   
	enddo

	z32_last=z32_last+1		

	z32_sort(z32_last)=z32_max
	
	ENDDO  ! do while
	
!------------------------------------------------------------------------------- 
!  Set parameters     
!------------------------------------------------------------------------------- 
!
	z32_ou=z32_sort
	z32_end=z32_ou(z32_last)
	
	IF(z32_end.ge.znow) THEN
	   halt_sim=1 !stop simulation
	   IF(me.eq.0) THEN
	      write(uterm,*)'SET STOP SIMULATION: Already reached final redshift'
	      call flush(uterm)
	   ENDIF 
	ENDIF


!------------------------------------------------------------------------------- 
! Update next_out at the start or if the out32.tab file is updated    
!------------------------------------------------------------------------------- 

	DO i=1,z32_last
	   IF(z32_ou(i).ne.z32_ou_temp(i)) THEN
	      EXIT
	   ENDIF
	ENDDO

	IF(i.le.z32_last .or. z32_last.ne.z32_last_temp) THEN

	DO i=1,z32_last
	
		IF(me.eq.0) write(uterm,*)'redsh:i,z32_ou(i),znow : ',i,z32_ou(i),znow
		
		IF(z32_ou(i).lt.znow) THEN
		  next_out=i
		IF(me.eq.0) write(uterm,*)'redsh:i, next_out : ',i,next_out
		  EXIT
		ENDIF
	ENDDO
	
	ENDIF

!------------------------------------------------------------------------------- 
!  Write values     
!------------------------------------------------------------------------------- 
	
	IF(me.eq.0) THEN
	
	write(uterm,*)'----------------------------'      
	write(uterm,*)'PROGRAMMED OUTPUT  FILES '
	write(uterm,*)'(redshift values)           '
	write(uterm,*)'----------------------------'
	write(uterm,170)(z32_ou(j),j=1,z32_last)	
	write(uterm,*)'----------------------------'

170	FORMAT(10(F7.3,1x))	

      ENDIF   ! if(me.eq.0)	

        RETURN
        END
