!-----------------------------------------------------------------------------
!
!
                         SUBROUTINE leapf_corr(rc)
!
!
!-----------------------------------------------------------------------------
!
!     Subroutine to apply a correction factor to the positions to
!     maintain second order accuracy when outputting particle data
!     to body data file or when computing energy diagnostics.  The
!     argument rc indicates whether the correction factor is to be
!     applied (correct) or removed (reset).
!
!
!-----------------------------------------------------------------------------

	 USE fly_h 
	implicit none
!   Declaration of local variables.
!   -------------------------------
        
	CHARACTER(LEN=7) :: rc
        REAL(KIND=8) :: dt2,rcsign,a_dot
        INTEGER :: p,k

!-----------------------------------------------------------------------
!   Check for correction or reset
!-----------------------------------------------------------------------
        
	IF(rc.EQ.'correct') THEN
           rcsign=-1.
        ELSE
           rcsign=1.
        ENDIF

!-----------------------------------------------------------------------
!   Loop over all spatial coordinates for all bodies.
!-----------------------------------------------------------------------
        
	dt2=dtime**2
	
	ap=f_ap/tnow
        a_dot = om_sum+Omega_l*(tnow**three_o_alpha)
        bp = 1./(alpha2*(hubble*hubble)*a_dot*(tnow**2.))

		
        DO  p=1,nb_res_loc(me+1)
            DO  k=1,ndim
	     pos(k,p)=pos(k,p)+rcsign*(vel(k,p)*dtime2 +                       &
            (-2.0*ap*vel(k,p)+bp*acc(k,p))*dt2/8.0)
           
	   ENDDO
        ENDDO
        
	RETURN
        END
