!=======================================================================
!
!
                          SUBROUTINE inpar_dyn
!
!=======================================================================
!
!
!
!     Subroutine to read in parameters.
!
!     Input parameters:
!
!        headline  : identification string for the run.
!        nsteps    : number of timesteps.
!	 max_time  : maximum cpu time allowed for this run
!        dtime     : integrator  timestep.
!        dt_var    : T use dt variable, F use dtime as fix dt
!        tol       : error tolerance; 0.0 => exact (PP) calculation.
!        eps       : potential softening parameter.
!        usequad   : option to include (.TRUE.) quadrupole terms.
!
!                    nbodies
!                    ndimi
!		     mass_read
!
!                    znow
!		     tstep
!		     rsize
!		     rmin(1,2,ndim)
!		     
!
!=======================================================================
!
	 USE fly_h
	implicit none
	INCLUDE 'mpif.h'
        
	INTEGER(KIND=4) :: null_int4
	LOGICAL 	:: null_log
	REAL(KIND=8) 	:: null_r8

!=======================================================================
!   Read parameters, close the file.
!   --------------------------------
!   Open parameter file.
!   --------------------

	IF(me.eq.0) THEN
       	
     	OPEN(UNIT=upars,FILE=parsfile,STATUS='OLD')
	
        READ(upars,30) headline
        READ(upars,15) null_int4
        READ(upars,48) max_time
        READ(upars,10) dtime
        READ(upars,40) dt_var
        READ(upars,20) tol
        READ(upars,10) eps
        READ(upars,40) null_log
        READ(upars,10) null_r8
        READ(upars,10) null_r8
        READ(upars,10) null_r8
        READ(upars,12) null_r8
        READ(upars,45) null_int4
        READ(upars,10) null_r8
        READ(upars,35) ibodfile
        READ(upars,60) inasc
        READ(upars,35) f32
        READ(upars,60) ouasc
        READ(upars,15) chk_file	
	
	
        CLOSE(UNIT=upars)


	IF(ouasc.eq.'b') ouasc='B' 
	IF(ouasc.eq.'a') ouasc='A' 
	IF(ouasc.ne.'A' .and. ouasc .ne. 'B')  THEN
	  ouasc='B' 
		write(uterm,*)'WARNING: OBOD_TYPE wrong type. Forced to B (BINARY)'
		call flush(uterm)
         ENDIF
	IF(inasc.eq.'b') inasc='B' 
	IF(inasc.eq.'a') inasc='A' 
	IF(inasc.eq.'s') inasc='S' 
	IF(inasc.eq.'t') inasc='T' 
	IF(inasc.eq.'r') inasc='R' 
	IF(inasc.ne.'A' .and. inasc .ne. 'B' .and. inasc .ne. 'S'.and. inasc .ne. 'T'.and. inasc .ne. 'R')  THEN
	  inasc='B' 
	  write(uterm,*)'WARNING: IBOD_TYPE wrong type. Forced to B (BINARY)'
	  call flush(uterm)
        ENDIF

	IF(ouasc.eq.'b') ouasc='B' 
	IF(ouasc.eq.'a') ouasc='A' 
	IF(ouasc.ne.'A' .and. ouasc .ne. 'B')  THEN
	  ouasc='B' 
	  write(uterm,*)'WARNING: OBOD_TYPE wrong type. Forced to B (BINARY)'
        ENDIF
      

        
	OPEN(UNIT=upar1,FILE=par1file,STATUS='OLD')
	
        READ(upar1,10) null_r8
        READ(upar1,15) null_int4
        READ(upar1,15) tst_max
        READ(upar1,15) ncrit
        READ(upar1,15) nbodcrit        
        READ(upar1,20) null_r8        
        READ(upar1,20) null_r8        
        READ(upar1,15) l_end
 
	
	CLOSE(unit=upar1)

	

200	CONTINUE
	CLOSE(UNIT=upar35)
	
	write(uterm,*)' '             
	write(uterm,*)' '             
	write(uterm,*)'----------------------------'             
	write(uterm,*)'T-step = ',tstep+1,'  INPUT DATA'
	write(uterm,*)'----------------------------'             
        write(uterm,130) 'HEADER   =',headline
        write(uterm,148) 'MAX_TIME =',max_time
        write(uterm,110) 'DELTA T. =',dtime
        write(uterm,140) 'DT VAR.  =',dt_var
        write(uterm,120) 'OPEN PAR.=',tol
        write(uterm,110) 'SOFT PAR.=',eps
        write(uterm,110) 'MASS BODY=',mass_read
        write(uterm,135) 'IBOD_FILE=',ibodfile(1:LEN_TRIM(ibodfile))
        write(uterm,160) 'IBOD_TYPE=',inasc
        write(uterm,135) 'OBOD_FILE=',f32(1:LEN_TRIM(f32))
        write(uterm,160) 'OBOD_TYPE=',ouasc
        write(uterm,115) 'CHK_FILE =',chk_file
        WRITE(uterm,110) 'CURR.REDS=',znow
        WRITE(uterm,115) 'CURR.STEP=',tstep
        WRITE(uterm,115) 'MAX  STEP=',tst_max
        WRITE(uterm,115) 'LIV. GROU=',ncrit
        WRITE(uterm,115) 'BODY GRO.=',nbodcrit	
	write(uterm,*)'----------------------------'             


      ENDIF   ! if(me.eq.0)	

10	FORMAT(10x,F20.15)
12	FORMAT(10x,F10.6)
13	FORMAT(10x,E20.15)
15	FORMAT(10x,I4)
16	FORMAT(10x,I5)
20	FORMAT(10x,F5.2)
25	FORMAT(10x,3(1x,F3.1))
30	FORMAT(10x,A)
35	FORMAT(10x,A)
40	FORMAT(10x,L1)
45	FORMAT(10x,I12)	
48	FORMAT(10x,I20)	
60	FORMAT(10x,A1)	
110	FORMAT(A10,F20.15)
113	FORMAT(A10,E20.15)
115	FORMAT(A10,I4)
130	FORMAT(A10,A)
135	FORMAT(A10,A)
120	FORMAT(A10,F5.2)
122	FORMAT(A10,F9.4)
140	FORMAT(A10,L1)
148	FORMAT(A10,I20)
160	FORMAT(A10,A1)	

	
!------------ SEND PARAMETERS using Broadcast

	NLONG=1	
	CALL MPI_Bcast(max_time, NLONG, MPI_INTEGER4, PE0, MPI_COMM_WORLD, ierror)
	CALL MPI_Bcast(dtime, NLONG, MPI_REAL8, PE0, MPI_COMM_WORLD, ierror)
	CALL MPI_Bcast(dt_var, NLONG, MPI_LOGICAL, PE0, MPI_COMM_WORLD, ierror)
	CALL MPI_Bcast(tol, NLONG, MPI_REAL8, PE0, MPI_COMM_WORLD, ierror)
	CALL MPI_Bcast(eps, NLONG, MPI_REAL8, PE0, MPI_COMM_WORLD, ierror)
	CALL MPI_Bcast(inasc, NLONG, MPI_CHARACTER, PE0, MPI_COMM_WORLD, ierror)
	CALL MPI_Bcast(ouasc, NLONG, MPI_CHARACTER , PE0, MPI_COMM_WORLD, ierror)
	CALL MPI_Bcast(chk_file, NLONG, MPI_INTEGER, PE0, MPI_COMM_WORLD, ierror)

        CALL MPI_Bcast(tst_max, NLONG, MPI_INTEGER, PE0, MPI_COMM_WORLD, ierror)
        CALL MPI_Bcast(ncrit, NLONG, MPI_INTEGER, PE0, MPI_COMM_WORLD, ierror)
        CALL MPI_Bcast(nbodcrit, NLONG, MPI_INTEGER, PE0, MPI_COMM_WORLD, ierror)
        CALL MPI_Bcast(l_end, NLONG, MPI_INTEGER, PE0, MPI_COMM_WORLD, ierror)
	
        RETURN
        END
