!***********************************************************************
!
!
                          SUBROUTINE init_pos
!
!
!***********************************************************************
!
!
!     Subroutine to apply correction factor to make the leap-frog
!     algorithm self-starting (Hernquist and Katz, Ap. J. Suppl.,
!     in press [1988]).
!
!
!=======================================================================

	 USE fly_h 
         implicit none

!   Declaration of local variables.
!   -------------------------------
        
	REAL(KIND=8) 	:: dt2,a_dot
        INTEGER 	:: p,k
!
!=======================================================================
!   Loop over all spatial coordinates for all bodies.
!   -------------------------------------------------

        dt2=dtime**2

	ap=f_ap/tnow
        a_dot = om_sum+Omega_l*(tnow**three_o_alpha)
        bp = 1./(alpha2*(hubble*hubble)*a_dot*(tnow**2.))

        DO p=1,nb_res_loc(me+1)

           DO k=1,ndim           

	pos(k,p) = pos(k,p) + vel(k,p)*dtime2 +                                &
     &  (-2.0*ap*vel(k,p)+bp*acc(k,p))*dt2/8.0


           ENDDO

        ENDDO

        RETURN
        END
