!***********************************************************************
!
!
                          SUBROUTINE tree_build
!
!
!***********************************************************************
!
!
!     Main routine to control initialization of the tree structure
!     for computing the gravitational interaction.
!
!
!=======================================================================

	 USE fly_h 
	implicit none


	 INCLUDE 'mpif.h'
	
	REAL(KIND=8)	:: c0a,c1a,cta,c0b,c1b,ctb
	INTEGER:: istatus(MPI_STATUS_SIZE),ind_pe,tag0=0
!=======================================================================
         
	 CALL MPI_BARRIER(MPI_COMM_WORLD,ierror)

	 	 

!-----------------------------------------------------------------------
! FLY:   Load bodies into the tree.
!-----------------------------------------------------------------------
 	
	c0a=MPI_WTIME()

		
        CALL tree_gen  
	
	c1a=MPI_WTIME()
	cta=c1a-c0a
	ctot_tree(1)=cta	
         
	 CALL MPI_BARRIER(MPI_COMM_WORLD,ierror)
	
	IF(me.eq.0)  THEN
	  write(uterm,*)"==============  TREE_GENERATION ============="
	  write(uterm,*)"PE ",me," sec =",ctot_tree(1)
	  write(uterm,*)"================================================"
	ENDIF

!-----------------------------------------------------------------------
!   Check for grouping cells
!-----------------------------------------------------------------------
        

         c0a=MPI_WTIME()

         CALL find_group  
        c1a=MPI_WTIME()
        cta=c1a-c0a
         ctot_tree(2)=cta

	 CALL MPI_BARRIER(MPI_COMM_WORLD,ierror)

	IF(me.eq.0)  THEN
	  write(uterm,*)"==============  FIND GROUP ============="
	  write(uterm,*)"PE ",me," sec =",ctot_tree(2)
	  write(uterm,*)"================================================"
	ENDIF
	
		

!-----------------------------------------------------------------------
!   Compute properties of tree cells.
!-----------------------------------------------------------------------

	 
         c0b=MPI_WTIME()  

         CALL cell_prop     
        
	          
	 c1b=MPI_WTIME()
         ctb=c1b-c0b
          ctot_tree(3)=ctb

	 CALL MPI_BARRIER(MPI_COMM_WORLD,ierror)
	
	IF(me.eq.0)  THEN
	  write(uterm,*)"==============  CELL_PROP ============="
	  write(uterm,*)"PE ",me," sec =",ctot_tree(3)
	  write(uterm,*)"================================================"
	ENDIF

		
        RETURN
        END
