!***********************************************************************
!
!
                          SUBROUTINE sys_init
!
!
!***********************************************************************
!
!
!     Subroutine to initialize the state of the system.
!
!
!=======================================================================

	 USE fly_h 
	 implicit none
	 INCLUDE 'mpif.h'
	 
        
		INTEGER		:: i
	INTEGER*8		:: bnf,nb_mod
      
	REAL(KIND=8)	:: c0a,c1a,c0b,c1b

!=======================================================================
!   Begin timing.
!   -------------
	   
	   c0b=MPI_WTIME() !initialize time counter for the routine

!-----------------------------------------------------------------------
!   Open data files, read input parameters and initial system state,
!   and initialize system parameters.
!-----------------------------------------------------------------------

        CALL read_params  ! reading stat_pars and dyn_pars files !**QUI e' il problema.. ma dove?

!-----------------------------------------------------------------------
!   Open out_32.tab file: List of programmed output (in redshift value)
!   and initialize  system parameters.
!-----------------------------------------------------------------------

        CALL read_redsh  ! reading out32.tab

!-----------------------------------------------------------------------
!   Set the number of bodies locally residing
!-----------------------------------------------------------------------
	nb_mod=nbodies
	bnf=nb_mod-(nb_mod/npes)*npes !MOD
	
	IF(bnf.EQ.0) THEN
		nb_res_loc=nb_mod/npes
	ELSE

	nb_mod=nb_mod+(npes-bnf)
	nb_res_loc=nb_mod/npes
	nb_res_loc(npes)=nb_res_loc(npes)-(npes-bnf)
	ENDIF
	

	   IF(me.eq.0) THEN
	     write(uterm,*)'--------- Number of local bodies in each PE ---------'
	DO i=1,N_PES
	     write(uterm,100)'PE=',i-1,' Number of Bodies =', nb_res_loc(i)
	ENDDO
	     write(uterm,*)'-----------------------------------------------------'
	   ENDIF
	   
100	   FORMAT(a,I4,a,I9)


!-----------------------------------------------------------------------
!   Upload bodies 
!-----------------------------------------------------------------------
	
	c0a=MPI_WTIME()  	!bodies reading timer start
	IF(inasc.eq.'A') THEN

	 IF(me.eq.0) THEN
	 write(uterm,*)'ASCII DATA INPUT'
	 call flush(uterm)
	 ENDIF
	   
	
         CALL read_b_asc  !read bodies from ascii file 
	ENDIF
	
	
	IF(inasc.eq.'B') THEN

	 IF(me.eq.0) THEN
	 write(uterm,*)'BINARY DATA INPUT'
	 call flush(uterm)
	 ENDIF
	
         CALL read_b_bin  !read bodies from binary file 
	ENDIF

	IF(inasc.eq.'S' .or. inasc.eq.'T'.or.inasc.eq.'R') THEN

	 IF(me.eq.0) THEN
	 write(uterm,*)'SIMULATED DATA INPUT'
	 call flush(uterm)
	 ENDIF
	
         CALL read_s_bin  !simulated input particles 
	ENDIF
	
	c1a=MPI_WTIME()-c0a  !bodies reading timer stop

	IF(me.EQ.0) THEN
	  write(uterm,*)'TIME TO READ BODIES =',c1a
	  call flush(uterm)
	ENDIF 
 	
	CALL MPI_BARRIER(MPI_COMM_WORLD,ierror)  

!----------------------------------------------------------------------- 
!     Initial parameters configuration
!-----------------------------------------------------------------------
      
	CALL init_pars  

!----------------------------------------------------------------------- 
!     Initial ewald tables  configuration
!-----------------------------------------------------------------------


	c0a=MPI_WTIME()

        CALL init_ew    
	
	c1a=MPI_WTIME()-c0a
	IF(me.EQ.0) THEN
	  write(uterm,*)'TIME TO READ EWALD=',c1a
	  call flush(uterm)
	ENDIF 



!----------------------------------------------------------------------- 
!   Leapfrog correct positions.
!-----------------------------------------------------------------------
	IF (tstep.EQ.0) CALL init_pos  

!----------------------------------------------------------------------- 
!  Set all body positions in the box.
!-----------------------------------------------------------------------

	IF (tstep.EQ.0)  call reset_pos
		
	
	c1b=MPI_WTIME()-c0b
	IF(me.EQ.0) THEN
	  write(uterm,*)'TIME TO INITIALIZE SYSTEM=',c1b
	  call flush(uterm)
	ENDIF 

	
       RETURN
        END
