!-----------------------------------------------------------------------------
!
!
                         SUBROUTINE step(n)
!
!
!-----------------------------------------------------------------------------
!
!
!     Subroutine to advance the state of the system by one large
!     timestep.
!
!
!-----------------------------------------------------------------------------

	 USE fly_h 
	implicit none
	 INCLUDE 'mpif.h'

!   Declaration of local variables.
!   -------------------------------
        
	INTEGER(KIND=8) ::  n
	REAL(KIND=8)	:: c0,c1,ctot
	 	
	
	
!-----------------------------------------------------------------------------
!       TREE BUILDING + FORCE_COMPUTE
!-----------------------------------------------------------------------------
        
	CALL MPI_BARRIER(MPI_COMM_WORLD,ierror) 	
	
	c0=MPI_WTIME()

        CALL step_force('acc ')    
		
        CALL MPI_BARRIER(MPI_COMM_WORLD,ierror) 	

	c1=MPI_WTIME()	
	ctot=c1-c0
	IF(me.eq.0) THEN
           write(uterm,*) 'STEP_FORCE: executed - time=',ctot
	   call flush(uterm)
	ENDIF

!-----------------------------------------------------------------------------
!       UPDATE DT
!-----------------------------------------------------------------------------
 	
	CALL dt_comp


!-----------------------------------------------------------------------------
!       send  data to FLASH-code
!-----------------------------------------------------------------------------

#ifdef FLASH	
	CALL density_send
#endif
!-----------------------------------------------------------------------------
!       UPDATE VELOCITY 
!-----------------------------------------------------------------------------

        CALL upd_vel
        
	CALL MPI_BARRIER(MPI_COMM_WORLD,ierror) 	
	

!-----------------------------------------------------------------------------
!       UPDATE POSITIONS 
!-----------------------------------------------------------------------------
	

           CALL upd_pos   
        
	CALL MPI_BARRIER(MPI_COMM_WORLD,ierror) 	

        
	CALL MPI_BARRIER(MPI_COMM_WORLD,ierror) 	
	
	
	
	tstep=tstep+1 
	
!-----------------------------------------------------------------------------
! Output system state: 
!
! wr_native: write the files (binary native format) for the next run
!
! out_32: write the output (binary) intermediate and final files for 
! data analysis (post processing) and quick look data files at the time-ste
! indicated in out32.tab file  
!-----------------------------------------------------------------------------
 				
	c0=MPI_WTIME()


         CALL out_32
			

         CALL wr_native(n)  
	
	c1=MPI_WTIME()
	ctot=c1-c0
	if (me .EQ. 0) then
          write(uterm,*) 'Output: executed - time=',ctot
	   call flush(uterm)
	endif	
        
	CALL MPI_BARRIER(MPI_COMM_WORLD,ierror)
	
       RETURN
        END
