!***********************************************************************
!
!
                          SUBROUTINE read_params
!
!
!***********************************************************************
!
!
!     Subroutine to read in parameters.
!
!     Input parameters
!
!	File stat_pars:
!
!	HEADER   = identification string for the run.
!	NUM. STEP= maximum number of steps for this run
!	MAX_TIME = maximum cpu time allowed for this run
!	DELTA T. = delta T for the integration
!       DT VAR.  = VAriable delta T.  T use dt variable, F use dtime as fix dt
!	OPEN PAR.= threshold  parameter for Opneing Criterion
!	SOFT PAR.= softening parameter
!	QUADRUP. = Quadrupole Expansion term added (T or F) (vers Beta 0.1: forced to TRUE)
!       OMEGA.CDM= cosmological model parameter
!	OMEGA.HDM= cosmological model parameter
!	OMEGA.LAM= cosmological model parameter
!	HUB_CONST= cosmological model parameter, hubble constant value
!	N. BODIES= number of bodies (must be lower or equal to nbodsmax)
!	MASS BODY= mass of bodies
!	IBOD_FILE= suffix (including path) for data input/output file of bodies
!	IBOD_TYPE= A (ASCII File) or B (Binary File)
!	OBOD_FILE= suffix (including path) for data output (corrected) file of bodies
!	OBOD_TYPE= A (ASCII File) or B (Binary File)
!	CHK_FILE = suffix (including path) for data output quick-look file of bodies
!
!
!	File dyn_pars:
!
!	CURR.REDS= red-shift value
!	CURR.STEP= current time-step
!	MAX  STEP= final time-step
!	LIV. GROU= level of the tree where grouping is applied
!	BODY GROU= max number of bodies in a grouping cell
!	BAL. PAR = balance parameter 
!       GR.  PAR = grouping balance parameter
!       SORT_LEV.= used for data sort procedure
!	BOX SIZE = size of the box
!	MIN.VERT.= minimum x,y,z coordinate of the box vertexs 
!
!
!=======================================================================
!
	 USE fly_h 

	INCLUDE 'mpif.h'
		
	INTEGER :: i

!=======================================================================

	
       	IF(me.eq.0) THEN
     	OPEN(UNIT=upars,FILE=parsfile,STATUS='OLD')
        
	READ(upars,30) headline
        READ(upars,16) nsteps
        READ(upars,45) max_time
        READ(upars,10) dtime
        READ(upars,40) dt_var
        READ(upars,20) tol
        READ(upars,10) eps
        READ(upars,40) usequad
        READ(upars,10) Omega_cdm
        READ(upars,10) Omega_hdm
        READ(upars,10) Omega_l
        READ(upars,25) hubble
        READ(upars,45) nbodies
        READ(upars,10) mass_read
        READ(upars,35) ibodfile
        READ(upars,60) inasc
        READ(upars,35) f32
        READ(upars,60) ouasc
        READ(upars,15) chk_file	
	
        CLOSE(UNIT=upars)
	

	IF(inasc.eq.'b') inasc='B' 
	IF(inasc.eq.'a') inasc='A' 
	IF(inasc.eq.'s') inasc='S' 
	IF(inasc.eq.'t') inasc='T' 
	IF(inasc.eq.'r') inasc='R' 
	IF(inasc.ne.'A' .and. inasc .ne. 'B' .and. inasc .ne. 'S'.and. inasc .ne. 'T'.and. inasc .ne. 'R')  THEN
	  inasc='B' 
	  write(uterm,*)'WARNING: IBOD_TYPE wrong type. Forced to B (BINARY)'
	  call flush(uterm)
        ENDIF

	IF(ouasc.eq.'b') ouasc='B' 
	IF(ouasc.eq.'a') ouasc='A' 
	IF(ouasc.ne.'A' .and. ouasc .ne. 'B')  THEN
	  ouasc='B' 
	  write(uterm,*)'WARNING: OBOD_TYPE wrong type. Forced to B (BINARY)'
        ENDIF
      



        
	OPEN(UNIT=upar1,FILE=par1file,STATUS='OLD')
	
        READ(upar1,10) znow
        READ(upar1,15) tstep
        READ(upar1,15) tst_max
        READ(upar1,15) ncrit
        READ(upar1,15) nbodcrit        
        READ(upar1,20) pstat
        READ(upar1,20) gr_stat
        READ(upar1,15) l_end
        READ(upar1,22) rsize
        READ(upar1,25) rmin(1)
        READ(upar1,25) rmin(2)
        READ(upar1,25) rmin(3)

	CLOSE(unit=upar1)

	IF(pstat.gt.1.0) pstat=1.0
	IF(pstat.lt.0.0) pstat=0.0
	
	
	write(uterm,*)'INPUT DATA'
	write(uterm,*)'----------------------------'             
        write(uterm,130) 'HEADER   =',headline
        write(uterm,115) 'NUM. STEP=',nsteps
        write(uterm,145) 'MAX_TIME =',max_time
        write(uterm,110) 'DELTA T. =',dtime
        write(uterm,140) 'DT VAR.  =',dt_var
        write(uterm,120) 'OPEN PAR.=',tol
        write(uterm,110) 'SOFT PAR.=',eps
        write(uterm,140) 'QUADRUP. =',usequad
        write(uterm,110) 'OMEGA_CDM=',Omega_cdm
        write(uterm,110) 'OMEGA_HDM=',Omega_hdm
        write(uterm,110) 'OMEGA_LBD=',Omega_l
        write(uterm,110) 'OMEGA_TOT=',Omega_cdm+Omega_hdm+Omega_l
        write(uterm,125) 'HUB_CONST=',hubble
        write(uterm,145) 'N. BODIES=',nbodies
        write(uterm,110) 'MASS BODY=',mass_read
        write(uterm,135) 'IBOD_FILE=',ibodfile(1:LEN_TRIM(ibodfile))
        write(uterm,160) 'IBOD_TYPE=',inasc
        write(uterm,135) 'OBOD_FILE=',f32(1:LEN_TRIM(f32))
        write(uterm,160) 'OBOD_TYPE=',ouasc
        write(uterm,115) 'CHK_FILE =',chk_file
        WRITE(uterm,110) 'CURR.REDS=',znow
        WRITE(uterm,115) 'CURR.STEP=',tstep
        WRITE(uterm,115) 'MAX  STEP=',tst_max
        WRITE(uterm,115) 'LIV. GROU=',ncrit
        WRITE(uterm,115) 'BODY GROU=',nbodcrit	
        write(uterm,120) 'BAL. PAR.=',pstat
        write(uterm,120) 'GR.  PAR.=',gr_stat
        WRITE(uterm,115) 'SORT_LEV.=',l_end
        WRITE(uterm,122) 'BOX SIZE =',rsize
        WRITE(uterm,125) 'X MIN VER=',rmin(1)
        WRITE(uterm,125) 'Y MIN VER=',rmin(2)
        WRITE(uterm,125) 'Z MIN VER=',rmin(3)


!-----------------------------------------------------------------------
!   Read the <= 262144 particles to select from ql.dat file
!-----------------------------------------------------------------------
!
!	
!        OPEN(UNIT=18,FILE=ql_tab,STATUS='OLD')
!        do i=1,262144
!        	read(18,FMT='(I12)',END=200) ql_pos(i)
!        enddo
!200	n_ql=i-1                
!	CLOSE(UNIT=18)
!	
!		
!-----------------------------------------------------------------------
!   sorting of ql_pos
!-----------------------------------------------------------------------
!
!	DO i = n_ql, 1, -1
!	
!		DO j = 2, i
!		
!			IF(ql_pos(j-1).GT.ql_pos(j)) THEN
!
!				tempSort = ql_pos(j)
!				ql_pos(j) = ql_pos(j-1)
!				ql_pos(j-1) = tempSort
!			ENDIF
!		ENDDO
!	ENDDO
!
!        do i=1,n_ql
!        	write(18,FMT='(I12)') ql_pos(i)
!        enddo
!	CLOSE(UNIT=18)
!-----------------------------------------------------------------------
      
      ENDIF   ! if(me.eq.0)	

10	FORMAT(10x,F20.15)
12	FORMAT(10x,E20.15)
15	FORMAT(10x,I4)
16	FORMAT(10x,I5)
20	FORMAT(10x,F5.2)
22	FORMAT(10x,F9.4)
25	FORMAT(10x,F10.6)
30	FORMAT(10x,A)
35	FORMAT(10x,A)
40	FORMAT(10x,L1)
45	FORMAT(10x,I20)	
60	FORMAT(10x,A1)	
110	FORMAT(A10,F20.15)
112	FORMAT(A10,E20.15)
115	FORMAT(A10,I4)
130	FORMAT(A10,A)
135	FORMAT(A10,A)
120	FORMAT(A10,F5.2)
122	FORMAT(A10,F9.4)
125	FORMAT(A10,F10.6)
140	FORMAT(A10,L1)
145	FORMAT(A10,I20)	
160	FORMAT(A10,A1)	

!------------ SEND read PARAMETER using SHMEM to ALL PEs

	NLONG=1

	CALL MPI_Bcast(nsteps, NLONG, MPI_INTEGER, PE0, MPI_COMM_WORLD, ierror)
	CALL MPI_Bcast(max_time, NLONG, MPI_INTEGER4, PE0, MPI_COMM_WORLD, ierror)
	CALL MPI_Bcast(dtime, NLONG, MPI_REAL8, PE0, MPI_COMM_WORLD, ierror)
	CALL MPI_Bcast(dt_var, NLONG, MPI_LOGICAL, PE0, MPI_COMM_WORLD, ierror)
	CALL MPI_Bcast(tol, NLONG, MPI_REAL8, PE0, MPI_COMM_WORLD, ierror)
	CALL MPI_Bcast(eps, NLONG, MPI_REAL8, PE0, MPI_COMM_WORLD, ierror)
 	CALL MPI_Bcast(usequad, NLONG, MPI_LOGICAL, PE0, MPI_COMM_WORLD, ierror)
	CALL MPI_Bcast(Omega_cdm, NLONG, MPI_REAL8, PE0, MPI_COMM_WORLD, ierror)
	CALL MPI_Bcast(Omega_hdm, NLONG, MPI_REAL8, PE0, MPI_COMM_WORLD, ierror)
	CALL MPI_Bcast(Omega_l, NLONG, MPI_REAL8, PE0, MPI_COMM_WORLD, ierror)
	CALL MPI_Bcast(hubble, NLONG, MPI_REAL4, PE0, MPI_COMM_WORLD, ierror)
	CALL MPI_Bcast(nbodies, NLONG, MPI_INTEGER8, PE0, MPI_COMM_WORLD, ierror)
	CALL MPI_Bcast(mass_read, NLONG, MPI_REAL8, PE0, MPI_COMM_WORLD, ierror)
	CALL MPI_Bcast(inasc, NLONG, MPI_CHARACTER, PE0, MPI_COMM_WORLD, ierror)
	CALL MPI_Bcast(ouasc, NLONG, MPI_CHARACTER , PE0, MPI_COMM_WORLD, ierror)
	CALL MPI_Bcast(chk_file, NLONG, MPI_INTEGER, PE0, MPI_COMM_WORLD, ierror)

	CALL MPI_Bcast(znow, NLONG, MPI_REAL8, PE0, MPI_COMM_WORLD, ierror)
	CALL MPI_Bcast(tstep, NLONG, MPI_INTEGER, PE0, MPI_COMM_WORLD, ierror)
	CALL MPI_Bcast(tst_max, NLONG, MPI_INTEGER, PE0, MPI_COMM_WORLD, ierror)
	CALL MPI_Bcast(ncrit, NLONG, MPI_INTEGER4, PE0, MPI_COMM_WORLD, ierror)
	CALL MPI_Bcast(nbodcrit, NLONG, MPI_INTEGER, PE0, MPI_COMM_WORLD, ierror) 
	CALL MPI_Bcast(pstat, NLONG,  MPI_REAL8, PE0, MPI_COMM_WORLD, ierror)
	CALL MPI_Bcast(gr_stat, NLONG,  MPI_REAL8, PE0, MPI_COMM_WORLD, ierror)
	CALL MPI_Bcast(l_end, NLONG, MPI_INTEGER, PE0, MPI_COMM_WORLD, ierror)
	CALL MPI_Bcast(rsize, NLONG, MPI_DOUBLE_PRECISION, PE0, MPI_COMM_WORLD, ierror)
	
        NLONG=ndim
	CALL MPI_Bcast(rmin, NLONG, MPI_REAL8, PE0, MPI_COMM_WORLD, ierror)

        rmin(3)=0.000000


	IF(nbodies.GT.nbodsmax) CALL error('read_params error 1: nbodies greater than nbodsmax')
	   
	IF((tst_max-tstep).lt.nsteps) nsteps=tst_max-tstep

        RETURN
	

        END
