!-----------------------------------------------------------------------------
!
!
                          SUBROUTINE out_32
!
!
!-----------------------------------------------------------------------------
!
!
!     Subroutine to output the body data to binary ieee32 output file.
!
!
!-----------------------------------------------------------------------------

	 USE fly_h 
	implicit none
 	 INCLUDE 'mpif.h'

!   Declaration of local variables.
!   -------------------------------
        
        CHARACTER(LEN=8) :: mestr
        INTEGER:: p,tag,istatus(MPI_STATUS_SIZE)


!-----------------------------------------------------------------------
! WARNING pos_cell is used as temporary array to store remote data
!-----------------------------------------------------------------------
!
!-----------------------------------------------------------------------
!   Check for the programmed simulation output from out32.tab
!-----------------------------------------------------------------------
 	pos_cell=0.0
 	
	


       
       IF(wr_out32) THEN 
	   

!-----------------------------------------------------------------------
!   OK produce the output OBOD_FILE_tstep
!-----------------------------------------------------------------------

           IF(znow.ge.100.0)write(mestr,'(F8.4)')znow

           IF(znow.ge.10.0 .AND. znow.lt.100.0)                         &
     	   write(mestr,'(F7.4)')znow

           IF(znow.ge.0.0 .AND. znow.lt.10.0)                           &
           write(mestr,'(F6.4)')znow

          IF(znow.lt.0.0)write(mestr,'(F7.4)')znow
	   
	   mestr=TRIM(mestr)
           
	   f32=TRIM(f32)//mestr 
           f32_ql=TRIM(f32_ql)//mestr

!-----------------------------------------------------------------------
!   Leapfrog correction
!-----------------------------------------------------------------------
           
	   CALL leapf_corr('correct')
	   
  	if (me .EQ. 0) then
          write(uterm,*) 'Output Leafrog Correction znow=', znow
          write(uterm,*) 'dtime=',dtime
          write(uterm,*) 'dtime2=',dtime2
          write(uterm,*) 'f_ap=',f_ap
          write(uterm,*) 'tnow=',tnow
          write(uterm,*) 'three_o_alpha=',three_o_alpha
          write(uterm,*) 'alpha2=',alpha2
          write(uterm,*) 'hubble=',hubble
          write(uterm,*) 'END Output Leafrog Correction'
	   call flush(uterm)
	endif	
         
	   CALL MPI_BARRIER(MPI_COMM_WORLD,ierror) 	
	   
	   IF(me.eq.0)	THEN

!-----------------------------------------------------------------------
!   writing ascii output 
!-----------------------------------------------------------------------
	   
	   IF(ouasc.eq.'A') THEN
                
		OPEN(UNIT=ubin32,FILE=f32,STATUS='UNKNOWN')
	        
		DO p=1,nb_res_loc(me+1)		!the first write  is the mine!
                   
		   WRITE(ubin32,1000) pos(1,p),pos(2,p),pos(3,p)  
	        
		ENDDO
 		
		tag=1
		
	  	
		DO PE_indx=1,NPES-1   ! read and transmit
 	   		
			NLONG=nb_res_loc(pe_indx+1)*3
 		
		CALL MPI_RECV(pos_cell(1,1), NLONG, MPI_REAL8, PE_indx, tag, MPI_COMM_WORLD, istatus, ierror)			
	             
		     DO p=1,nb_res_loc(pe_indx+1)		
                       
		       WRITE(ubin32,1000) pos_cell(1,p),pos_cell(2,p),pos_cell(3,p)  
	            
		    ENDDO
          	
		ENDDO
		
	        
		DO p=1,nb_res_loc(me+1)		!the first write  is the mine!
                   
		   WRITE(ubin32,1000) vel(1,p),vel(2,p),vel(3,p)  
	        
		ENDDO
	
 		tag=2
		
	  	DO PE_indx=1,NPES-1   ! read and transmit
 	   		
			nlong=nb_res_loc(pe_indx+1)*3
 		
		CALL MPI_RECV(pos_cell(1,1), NLONG, MPI_REAL8, PE_indx, tag, MPI_COMM_WORLD, istatus, ierror)			
	        
		DO p=1,nb_res_loc(pe_indx+1)		
                   
		   WRITE(ubin32,1000) pos_cell(1,p),pos_cell(2,p),pos_cell(3,p)  
	        
		ENDDO
          	
		ENDDO
		
                
		CLOSE(UNIT=ubin32)

1000	FORMAT(3(1X,F20.10))
1001	FORMAT(1X,F20.10)
1002	FORMAT(1X,I4)
	   
	   ENDIF ! if ouasc.eq.'A'

!-----------------------------------------------------------------------
!   writing binary output 
!-----------------------------------------------------------------------
	   
	   IF(ouasc.eq.'B') THEN
	        
		call c_open_f32(f32)
		
	        
		nlong=nb_res_loc(me+1)*3
		
	        call c_write_f32(pos(1,1),nlong)
		
		tag=1
	
	  	DO PE_indx=1,NPES-1   ! read and transmit
			
			nlong=nb_res_loc(pe_indx+1)*3
 		
		CALL MPI_RECV(pos_cell(1,1), NLONG, MPI_REAL8, PE_indx, tag, MPI_COMM_WORLD, istatus, ierror)			
			
	                call c_write_f32(pos_cell(1,1),nlong)
          	
		ENDDO
	        
		nlong=nb_res_loc(me+1)*3
	        
		call c_write_f32(vel(1,1),nlong)
		
		tag=2
	
	  	DO PE_indx=1,NPES-1   ! read and transmit
			
			nlong=nb_res_loc(pe_indx+1)*3
 		 
		 CALL MPI_RECV(pos_cell(1,1), NLONG, MPI_REAL8, PE_indx, tag,        &
                              MPI_COMM_WORLD, istatus, ierror)			
	                
			call c_write_f32(pos_cell(1,1),nlong)

          	ENDDO
	      
	      call c_close_f32()
	   
	   ENDIF ! if ouasc.eq.'B'

		

!-----------------------------------------------------------------------
!   end of quick look section
!-----------------------------------------------------------------------             
 	   ELSE ! if me.eq.0    
	   
 	   
	   NLONG=nb_res_loc(me+1)*3
	   
	   tag=1
           
	   CALL MPI_SEND(pos(1,1), NLONG, MPI_REAL8, PE0, tag, MPI_COMM_WORLD, ierror)			
	   
	   
	   tag=2
	   
           CALL MPI_SEND(vel(1,1), NLONG, MPI_REAL8, PE0, tag, MPI_COMM_WORLD, ierror)			
	   

 	   
	   ENDIF ! if me.eq.0    
           
	   CALL MPI_BARRIER(MPI_COMM_WORLD,ierror) 	

!-----------------------------------------------------------------------
!  RESET the Leapfrog correction
!-----------------------------------------------------------------------
                CALL leapf_corr('reset  ')
		
		
!-----------------------------------------------------------------------
!  set next_out condition
!-----------------------------------------------------------------------
	   	
		next_out=next_out+1
           
	   ENDIF  !if(wr_out32)

110	FORMAT(3(1X,F20.10))  
140	FORMAT(A) 
150	FORMAT(I6) 
        
	RETURN
        END
