!***********************************************************************
!
!
                          SUBROUTINE init_ew
!
!
!***********************************************************************
!
!    Reads data from file and interpolates in given 
!    points using a Cloud-In-Cell scheme as given in
!    eqs. 1d) and 2b) of Efstathiou et al., ApJS 57, 241 (1985)
!
!
!=======================================================================

	 USE fly_h 
	implicit none
	INCLUDE 'mpif.h'
	INTEGER:: i,j,k
       
       IF(me.eq.0) THEN 

!   Open ewald data files.
!   ---------------------------------
    	
	OPEN(UNIT=uewgrid,FILE=fewgrid,STATUS='OLD')
        OPEN(UNIT=uewtab,FILE=fewtab,FORM="UNFORMATTED",STATUS='OLD')


!  Read fc components
!  ------------------
	DO 10 i=0, nknots
	   DO 20 j=0, nknots
		DO 30 k=0, nknots
         READ(uewtab) fc(i,j,k,1),fc(i,j,k,2),fc(i,j,k,3)
30	      CONTINUE
20	   CONTINUE	
10	CONTINUE
	
	CLOSE(UNIT=uewtab)

!  Read rk components
!  ------------------
	
	DO 40 i=0, nknots
           READ(uewgrid,*) rk(i,1)
          rk(i,2)=rk(i,1)
	  rk(i,3)=rk(i,1)
40	CONTINUE
	
	CLOSE(UNIT=uewgrid)
	write(uterm,*)"PE=",me," ew_red completed"

      ENDIF  !if(me.eq.0)

	NLONG=(nknots+1)*3
	CALL MPI_Bcast(rk(0,1), NLONG, MPI_REAL8, PE0, MPI_COMM_WORLD, ierror)
	NLONG=(nknots+1)*(nknots+1)*(nknots+1)*3
	CALL MPI_Bcast(fc(0,0,0,1), NLONG, MPI_REAL8, PE0, MPI_COMM_WORLD, ierror)

	RETURN
        END
