!=======================================================================
!
!
      MODULE fly_h 
!
!
!=======================================================================
!
!
!     Parameter declarations, allocation of array storage, common
!     block definitions.
!
!=======================================================================

#ifdef XXMP	 
	 USE omp_lib
#endif

#ifdef PE2
       INTEGER, PARAMETER ::NP=2
#endif

#ifdef PE4
       INTEGER, PARAMETER ::NP=4
#endif

#ifdef PE8
       INTEGER, PARAMETER ::NP=8
#endif

#ifdef PE16
       INTEGER, PARAMETER ::NP=16
#endif

#ifdef PE32
       INTEGER, PARAMETER ::NP=32
#endif

#ifdef PE52
       INTEGER, PARAMETER ::NP=52
#endif

#ifdef PE56
       INTEGER, PARAMETER ::NP=56
#endif
!       INTEGER, PARAMETER ::NP=4



!-------------------------------------------------------------------------------
! SPECIFY THE NUMBER OF PEs
!-------------------------------------------------------------------------------

!	INTEGER, PARAMETER :: N_PES= 2
	INTEGER, PARAMETER :: N_PES= 4
!	INTEGER, PARAMETER :: N_PES= 8
!	INTEGER, PARAMETER :: N_PES= 10
!	INTEGER, PARAMETER :: N_PES= 16 
!	INTEGER, PARAMETER :: N_PES= 32 
!	INTEGER, PARAMETER :: N_PES= 48 
!	INTEGER, PARAMETER :: N_PES= 52 
!	INTEGER, PARAMETER :: N_PES= 56
!	INTEGER, PARAMETER :: N_PES= 100
!	INTEGER, PARAMETER :: N_PES= 180
!	INTEGER, PARAMETER :: N_PES= NP 


!-------------------------------------------------------------------------------
! SPECIFY THE AVAILABLE MEMORY (in Mbyte) FOR EACH PE
!-------------------------------------------------------------------------------
  	INTEGER, PARAMETER :: MEM_PE= 2048
  	INTEGER, PARAMETER :: MEM_SO= 250   !so occ.
  	INTEGER, PARAMETER :: MEM_FX= 5    !fix mem occ.

!-------------------------------------------------------------------------------
! SPECIFY the nbodsmax DIMENSION (MUST BE EQUAL   
!   to the number of bodies used (nbodies variable)  
!-------------------------------------------------------------------------------

	 INTEGER*8, PARAMETER :: nbodsmax=  32768
!	 INTEGER*8, PARAMETER :: nbodsmax=1000000000

!-------------------------------------------------------------------------------
! SPECIFY THE DIMENSION: maxnterm (max length of IL)  and maxilf (max length of
! temporary storage to form IL)  (suggested value maxilf=maxnterm*64) 
!-------------------------------------------------------------------------------
 
 	INTEGER, PARAMETER :: maxnterm=  3000
 	INTEGER, PARAMETER :: maxilf= maxnterm * 64  !USER def.


!-------------------------------------------------------------------------------
! SPECIFY THE COMMUNICATION MPI PARAMETERS
!-------------------------------------------------------------------------------
!	INTEGER :: ind_pe

	INTEGER :: ind_loc,ind_pe_1,ind_loc_1,ind_pe_2,ind_loc_2
	
 	INTEGER, SAVE :: me,NPES,PE0=0, lpes
	INTEGER :: NLONG,PE_indx
!	INTEGER :: ind_pe,ind_loc,ind_pe_1,ind_loc_1,ind_pe_2,ind_loc_2
!
!
!-------------------------------------------------------------------------------
! SPECIFY THE ndim DIMENSION (FLY vers. 2.0 : MUST BE EQUAL to 3)
!------------------------------------------------------------------------------
	
	INTEGER(KIND=4), PARAMETER :: ndim=3,nsubcell=2**ndim
	
!-------------------------------------------------------------------------------
! SPECIFY THE MAXIMUM LEVEL OF  THE TREE DIMENSION
!-------------------------------------------------------------------------------

        INTEGER, PARAMETER :: nmax_level=100   !maximum number of tree levels

!-------------------------------------------------------------------------------
! SPECIFY THE ncells DIMENSION (SET EQUAL to nbodsmax parameter)
!-------------------------------------------------------------------------------

	 INTEGER*8, PARAMETER :: 	ncells=nbodsmax !ncells = max number of internal cells of the tree

!------------------------------------------------------------------------------
! DOMAIN SUBDIVISION
!------------------------------------------------------------------------------

        INTEGER*8, PARAMETER :: nb_loc=nbodsmax/N_PES+1  ! max number of memory residing local bodies
        INTEGER*8, PARAMETER :: nc_loc=ncells/N_PES+1    ! number of memory residing tree cells

!-------------------------------------------------------------------------------
! OTHER PARAMETER DEFINITIONS
!-------------------------------------------------------------------------------


	INTEGER(KIND=4), PARAMETER :: ninterp=32766    ! interpolation parameter
        INTEGER, PARAMETER :: nknots=49	    ! used for Ewald (period. bound. cond.)


!-------------------------------------------------------------------------------
! GLOBAL DEFINITIONS : REAL
!-------------------------------------------------------------------------------

        CHARACTER(LEN=40) , SAVE :: headline

        REAL(KIND=8), SAVE, DIMENSION (nb_loc):: mass
        REAL(KIND=8), SAVE, DIMENSION (ndim,nb_loc):: pos,vel
        REAL(KIND=8), SAVE, DIMENSION (nc_loc):: mass_cell
        REAL(KIND=8), SAVE, DIMENSION (ndim,nc_loc):: pos_cell

#ifdef SORT
        REAL(KIND=8), SAVE, DIMENSION (ndim,nb_loc):: pos_sort,vel_sort
        REAL(KIND=8), SAVE, DIMENSION (ndim,1):: acc
        REAL(KIND=8), SAVE, DIMENSION(1:2*ndim-1,1):: quad
#else
        REAL(KIND=8), SAVE, DIMENSION (ndim,nb_loc):: pos_rmt
        REAL(KIND=8), SAVE, DIMENSION (ndim,nb_loc):: acc_rmt
        REAL(KIND=8), SAVE, DIMENSION (ndim,nb_loc):: acc
        REAL(KIND=8), SAVE, DIMENSION(1:2*ndim-1,nc_loc):: quad
#endif

	REAL(KIND=8),SAVE :: tol,tol2inv,eps,rsize,tnow,tpos,dtime,dtime2
	REAL(KIND=8),SAVE :: tiny,one


	REAL(KIND=8),SAVE, DIMENSION(ndim) :: rmin
	


        REAL(KIND=8),SAVE :: znow
        REAL(KIND=8),SAVE :: alpha
        REAL(KIND=8),SAVE :: Omega_cdm,Omega_hdm,Omega_l,om_sum,f_ap
        REAL(KIND=8),SAVE :: one_o_alpha,three_o_alpha,alpha2
        REAL(KIND=8),SAVE, DIMENSION(0:1+ninterp):: phsmooth,acsmooth
        REAL(KIND=8) 	  :: ap,bp

        REAL(KIND=8),SAVE	:: mass_read
        REAL(KIND=8),SAVE, DIMENSION(0:nknots,0:nknots,0:nknots,ndim)::fc
        REAL(KIND=8),SAVE, DIMENSION(0:nknots,ndim):: rk

        REAL(KIND=8),SAVE, DIMENSION(nmax_level) :: size_level

        REAL(KIND=8),SAVE :: L2,Lbox,linv

	REAL(KIND=4), SAVE, DIMENSION (100):: z32_ou
	REAL(KIND=4), SAVE 		   :: z32_end
	INTEGER(KIND=4),SAVE	:: nr_z32


!-------------------------------------------------------------------------------
! GLOBAL DEFINITIONS : INTEGER
!-------------------------------------------------------------------------------

	INTEGER(KIND=4),SAVE :: root,incells
	INTEGER*8,SAVE :: nbodies
	
	INTEGER(KIND=4),SAVE, DIMENSION(nsubcell,nc_loc)::subp
	
	
	
	INTEGER(KIND=4), SAVE	:: nsteps,tstep,l_end,lmax,tst_max
	INTEGER(KIND=4), SAVE	:: next_out,z32_last
	INTEGER(KIND=4), SAVE, DIMENSION (nb_loc):: mark_bod_gr
	INTEGER(KIND=4), SAVE, DIMENSION (nc_loc):: mark_gr_cell,grouping
	
	INTEGER(KIND=4), SAVE, DIMENSION (nmax_level,2):: cell_ss
	INTEGER(KIND=4), SAVE:: ncrit,nbodcrit,cg_loc

	
 	INTEGER(KIND=4), SAVE   :: halt_sim
	INTEGER, SAVE :: chk_file


        LOGICAL, SAVE	:: usequad,dt_var,POW2,rmt_acc
	

!	INTEGER(KIND=4), DIMENSION (nb_loc) :: free_body_pub = 0

!-------------------------------------------------------------------------------
!   Definitions specific to input/output.
!-------------------------------------------------------------------------------
        INTEGER, PARAMETER:: uterm=6,upars=10,ubodsin=12,ubodsout=13
        INTEGER, PARAMETER:: ubodsasc=14, uewgrid=15, uewtab=16
        INTEGER, PARAMETER:: upar1=20
        INTEGER, PARAMETER:: upar3=23, ubin32=32,upar35=35,ufnames=26
        INTEGER(KIND=4), SAVE, DIMENSION(262144) :: ql_pos = 0
	INTEGER(KIND=4), SAVE :: n_ql = 0

	CHARACTER(LEN=1),SAVE :: inasc,ouasc


        CHARACTER(LEN=256),SAVE :: parsfile,ibodfile
        CHARACTER(LEN=256),SAVE :: par1file,fpar35,f32,f32_ql,ql_tab
	CHARACTER(LEN=256),SAVE :: fewgrid, fewtab, fly_fnames

        LOGICAL, SAVE	:: wr_out32


!-------------------------------------------------------------------------------
!   Miscelaneous
!-------------------------------------------------------------------------------

        INTEGER,SAVE  :: idisp

	REAL(KIND=8),SAVE  :: ctota,ctotb,ctotc,ctot_acc_comp,ctot_acc_ex
	REAL(KIND=8),SAVE,  DIMENSION(3) ::ctot_tree
	REAL(KIND=8),SAVE,  DIMENSION(N_PES,N_PES) ::rmt_time
	REAL(KIND=8),SAVE  :: ctot_GS_nt,ctot_TW
	REAL(KIND=8),SAVE  :: ctot_GS_nt_rmt,ctot_TW_rmt
	INTEGER(KIND=4),SAVE  :: max_time




 	INTEGER(KIND=4), SAVE, DIMENSION(N_PES):: nb_res_loc

        REAL(KIND=8),SAVE :: pstat,gr_stat

        INTEGER(KIND=4),SAVE :: numbod_100, numbod_200,numbod_300, numbod
	REAL(KIND=4), SAVE   :: hubble
!-------------------------------------------------------------------------------
!   Force computation: arrays definitions
!-------------------------------------------------------------------------------

	INTEGER(KIND=4),SAVE 	:: group_access


!-------------------------------------------------------------------------------
!   Definitions specific STATISTICAL counting
!-------------------------------------------------------------------------------



!-------------------------------------------------------------------------------
!   Definitions specific Fly/Flash interface
!-------------------------------------------------------------------------------


        integer flashComm
	integer(kind=4), dimension(ndim) :: nZones

!-------------------------------------------------------------------------------
!   Definitions specific MPI2 
!-------------------------------------------------------------------------------

	 integer :: ierr,ierror


	 integer,parameter :: int4=4
	 integer,parameter :: int8=8
	 integer,parameter :: real4=4
	 integer,parameter :: real8=8
	 
	integer, SAVE :: win_iblk
	 

      END MODULE fly_h


