
!-------------------------------------------------------------------------------
! SPECIFY THE COMMUNICATION MPI PARAMETERS
!-------------------------------------------------------------------------------
!	INTEGER :: ind_pe

	INTEGER :: ind_loc,ind_pe_1,ind_loc_1,ind_pe_2,ind_loc_2
	
 	INTEGER, SAVE :: me,NPES,PE0=0, lpes
	INTEGER :: NLONG,PE_indx
!	INTEGER :: ind_pe,ind_loc,ind_pe_1,ind_loc_1,ind_pe_2,ind_loc_2
	INTEGER :: i_sh
!
!
!-------------------------------------------------------------------------------
! SPECIFY THE ndim DIMENSION (FLY vers. 2.0 : MUST BE EQUAL to 3)
!------------------------------------------------------------------------------
	
	INTEGER(KIND=4), PARAMETER :: ndim=3,nsubcell=2**ndim
	
!-------------------------------------------------------------------------------
! SPECIFY THE MAXIMUM LEVEL OF  THE TREE DIMENSION
!-------------------------------------------------------------------------------

        INTEGER, PARAMETER :: nmax_level=100   !maximum number of tree levels

!-------------------------------------------------------------------------------
! SPECIFY THE ncells DIMENSION (SET EQUAL to nbodsmax parameter)
!-------------------------------------------------------------------------------

	 INTEGER(KIND=4), PARAMETER :: 	ncells=nbodsmax !ncells = max number of internal cells of the tree

!------------------------------------------------------------------------------
! DOMAIN SUBDIVISION
!------------------------------------------------------------------------------

        INTEGER, PARAMETER :: nb_loc=nbodsmax/N_PES+1  ! max number of memory residing local bodies
        INTEGER, PARAMETER :: nc_loc=ncells/N_PES+1    ! number of memory residing tree cells

!-------------------------------------------------------------------------------
! OTHER PARAMETER DEFINITIONS
!-------------------------------------------------------------------------------


	INTEGER(KIND=4), PARAMETER :: ninterp=32766    ! interpolation parameter
        INTEGER, PARAMETER :: nknots=49	    ! used for Ewald (period. bound. cond.)


!-------------------------------------------------------------------------------
! GLOBAL DEFINITIONS : REAL
!-------------------------------------------------------------------------------

        CHARACTER(LEN=40) , SAVE :: headline

        REAL(KIND=8), SAVE, DIMENSION (nb_loc):: mass
        REAL(KIND=8), SAVE, DIMENSION (ndim,nb_loc):: pos,vel
        REAL(KIND=8), SAVE, DIMENSION (nc_loc):: mass_cell
        REAL(KIND=8), SAVE, DIMENSION (ndim,nc_loc):: pos_cell

#ifdef SORT
        REAL(KIND=8), SAVE, DIMENSION (ndim,nb_loc):: pos_sort,vel_sort
        REAL(KIND=8), SAVE, DIMENSION (ndim,1):: acc
        REAL(KIND=8), SAVE, DIMENSION(1:2*ndim-1,1):: quad
#else
        REAL(KIND=8), SAVE, DIMENSION (ndim,nb_loc):: acc
        REAL(KIND=8), SAVE, DIMENSION(1:2*ndim-1,nc_loc):: quad
#endif

	REAL(KIND=8),SAVE :: tol,tol2inv,eps,rsize,tnow,tpos,dtime,dtime2
	REAL(KIND=8),SAVE :: tiny,one


	REAL(KIND=8),SAVE, DIMENSION(ndim) :: rmin,dp
	


        REAL(KIND=8),SAVE :: znow
        REAL(KIND=8),SAVE :: alpha
        REAL(KIND=8),SAVE :: Omega_cdm,Omega_hdm,Omega_l,om_sum,f_ap
        REAL(KIND=8),SAVE :: one_o_alpha,three_o_alpha,alpha2
        REAL(KIND=8),SAVE, DIMENSION(0:1+ninterp):: phsmooth,acsmooth
        REAL(KIND=8) 	  :: ap,bp

        REAL(KIND=8),SAVE	:: mass_read
        REAL(KIND=8),SAVE, DIMENSION(0:nknots,0:nknots,0:nknots,ndim)::fc
        REAL(KIND=8),SAVE, DIMENSION(0:nknots,ndim):: rk

        REAL(KIND=8),SAVE, DIMENSION(nmax_level) :: size_level

        REAL(KIND=8),SAVE :: L2,Lbox,linv,acc_gx,acc_gy,acc_gz

	REAL(KIND=4), SAVE, DIMENSION (100):: z32_ou
	REAL(KIND=4), SAVE 		   :: z32_end


!-------------------------------------------------------------------------------
! GLOBAL DEFINITIONS : INTEGER
!-------------------------------------------------------------------------------

	INTEGER(KIND=4),SAVE :: root,nbodies,incells
	
	INTEGER(KIND=4),SAVE, DIMENSION(nsubcell,nc_loc)::subp
	
	
	
	INTEGER(KIND=4), SAVE	:: nsteps,tstep,l_end,lmax,tst_max
	INTEGER(KIND=4), SAVE	:: next_out,z32_last
	INTEGER(KIND=4), SAVE, DIMENSION (nb_loc):: mark_bod_gr
	INTEGER(KIND=4), SAVE, DIMENSION (nc_loc):: mark_gr_cell,grouping
	
	INTEGER(KIND=4), SAVE, DIMENSION (nmax_level,2):: cell_ss
	INTEGER(KIND=4), SAVE:: ncrit,nbodcrit,cg_loc

	
 	INTEGER(KIND=4), SAVE   :: halt_sim


        LOGICAL, SAVE	:: usequad,dt_var,POW2
	

	INTEGER(KIND=4), DIMENSION (nb_loc) :: free_body_pub = 0

!-------------------------------------------------------------------------------
!   Definitions specific to input/output.
!-------------------------------------------------------------------------------
        INTEGER, PARAMETER:: uterm=6,upars=10,ubodsin=12,ubodsout=13
        INTEGER, PARAMETER:: ubodsasc=14, uewgrid=15, uewtab=16
        INTEGER, PARAMETER:: upar1=20
        INTEGER, PARAMETER:: upar3=23, ubin32=32,upar35=35,ufnames=26
        INTEGER(KIND=4), SAVE, DIMENSION(262144) :: ql_pos = 0
	INTEGER(KIND=4), SAVE :: n_ql = 0

	CHARACTER(LEN=1),SAVE :: inasc,ouasc


        CHARACTER(LEN=256),SAVE :: parsfile,ibodfile
        CHARACTER(LEN=256),SAVE :: par1file,fpar35,f32,f32_ql,ql_tab
	CHARACTER(LEN=256),SAVE :: fewgrid, fewtab, fly_fnames

        LOGICAL, SAVE	:: wr_out32


!-------------------------------------------------------------------------------
!   Miscelaneous
!-------------------------------------------------------------------------------

        INTEGER,SAVE  :: idisp

	REAL(KIND=8),SAVE  :: ctota,ctotb
	REAL(KIND=8),SAVE  :: ctot_GS_nt,ctot_TW
	INTEGER(KIND=8),SAVE  :: max_time



        INTEGER(KIND=4), SAVE :: max_pr,max_pr_bal

        INTEGER(KIND=4), SAVE, DIMENSION(nb_loc) :: pe_ex_pr
 	INTEGER(KIND=4), SAVE, DIMENSION(N_PES):: nb_res_loc

        REAL(KIND=8),SAVE :: pstat,gr_stat

        INTEGER(KIND=4),SAVE :: numbod_100, numbod_200, numbod
	REAL(KIND=4), SAVE   :: hubble
!-------------------------------------------------------------------------------
!   Force computation: arrays definitions
!-------------------------------------------------------------------------------
	REAL(KIND=8),SAVE,  DIMENSION (maxnterm):: drdotdr,dx,dy,dz
	REAL(KIND=8),SAVE,  DIMENSION (maxnterm):: drdotdr_gr,dx_gr,dy_gr,dz_gr

	REAL(KIND=8),SAVE,  DIMENSION (maxnterm)::pmass,pmass_gr
	REAL(KIND=8),SAVE,  DIMENSION (ndim)::pos_comm
	REAL(KIND=8),SAVE,  DIMENSION (2*ndim-1,maxnterm) ::pquad,pquad_gr

	INTEGER(KIND=4),SAVE,  DIMENSION (maxnterm):: iterms,iterms_gr
	INTEGER(KIND=4),SAVE 	:: group_access

!-------------------------------------------------------------------------------
!   RAM-CACHE arrays definitions: allocated in null.F routines
!   we have an occupacy of 116 bytes for each ram-cache line
!   code requires  about 230 Mbyte for 1 million of local bodies (1 PE)
!   (i.e about 242 byte for each body)
!   line_ch will start with the available free memory :
!   (MEM_PE*1024*1024 - 242*nbodsmax/N_PES)/116
!-------------------------------------------------------------------------------


        INTEGER,SAVE :: linee_ch,linech_tree=0,linech_dyn=0
	INTEGER,SAVE :: linech_group=nc_loc

        INTEGER :: ind_ch,checkstat

        INTEGER(KIND=4),SAVE, DIMENSION (:), ALLOCATABLE:: indexp_ch,indexm_ch
        INTEGER(KIND=4),SAVE, DIMENSION (:), ALLOCATABLE:: indexs_ch
        INTEGER(KIND=4),SAVE, DIMENSION (:,:), ALLOCATABLE:: subp_ch
        REAL(KIND=8),SAVE, DIMENSION (:), ALLOCATABLE:: mass_ch
        REAL(KIND=8),SAVE, DIMENSION (:,:), ALLOCATABLE:: pos_ch
        REAL(KIND=8),SAVE, DIMENSION (:,:), ALLOCATABLE:: quad_ch

	CHARACTER(LEN=40),SAVE :: ch_str

!-------------------------------------------------------------------------------
!   Definitions specific STATISTICAL counting
!-------------------------------------------------------------------------------

#ifdef STA
	
	INTEGER, PARAMETER:: NUM_TP=100
	
	INTEGER(KIND=8),SAVE, DIMENSION(NUM_TP) :: c_miss,c_found,c_fill,c_get
	INTEGER(KIND=8),SAVE :: max_max, min_min, avg_il, avg_group_il
	INTEGER(KIND=8),SAVE :: avg_group_ncl, avg_ncl
	INTEGER(KIND=8),SAVE :: ilist_group_cnt, ilist_cnt
	INTEGER(KIND=8),SAVE ::   c_miss_t, c_found_t, c_fill_t, c_get_t
	INTEGER(KIND=8),SAVE ::   c_miss_0, c_found_0, c_fill_0, c_get_0
	INTEGER(KIND=8),SAVE ::   c1_loc,c1_alt
	INTEGER(KIND=8),SAVE ::   avg_group_cl, avg_group_bd,avg_cl, avg_bd
        INTEGER(KIND=4),SAVE , DIMENSION(10) :: CRITICAL_SECT
	

#endif

!-------------------------------------------------------------------------------
!   Definitions specific Fly/Flash interface
!-------------------------------------------------------------------------------


        integer flashComm
	integer(kind=4), dimension(ndim) :: nZones

!-------------------------------------------------------------------------------
!   Definitions specific MPI2 
!-------------------------------------------------------------------------------

	 integer :: ierr,ierror

	 integer, SAVE :: win_pos
	 integer, SAVE :: win_vel
	 integer, SAVE :: win_cg_loc
	 
	 integer,SAVE :: win_mass_cell
	 integer,SAVE :: win_pos_cell
	 integer,SAVE :: win_acc
	 integer,SAVE :: win_quad
	 integer,SAVE :: win_subp
	 integer,SAVE :: win_mark_bod_gr
	 integer,SAVE :: win_mark_gr_cell
	 integer,SAVE :: win_grouping
	 integer,SAVE :: win_pe_ex_pr
	 integer,SAVE :: win_nb_res_loc
	 integer,SAVE :: win_free_body_pub

	 integer,parameter :: int4=4
	 integer,parameter :: int8=8
	 integer,parameter :: real4=4
	 integer,parameter :: real8=8
	 
	integer, SAVE :: win_iblk
	 
!-------------------------------------------------------------------------------
!   Definitions specific atomic update
!-------------------------------------------------------------------------------

	integer(KIND=4), save, dimension(0:(N_PES*N_PES)-1) :: iblk, iblk2
	integer(KIND=4), save, dimension(0:N_PES-1) :: iblk_local

      END MODULE fly_h


