# SCOSpy

SCOSpy is a python library for the Satellite Control and Operation System 2000 (SCOS-2000) header written as hexadecimal string.

Current version is 0.4.3

## Library Installation
```bash
$ pip install SCOSpy
```
## Usage

``` python
from SCOS.SCOS import SCOS
a = SCOS(packet)
```
where *packet* is the hexadecimal string rapresentation of the Telemetry packet.

## Limitation
At the moment the software works only for Telemetry and Telecommand packets (Packet Types 1 and 2) for the BepiColombo ESA Mission.
It is possible add a new Mission ID and Spcecraft ID. For example to add the JUICE Mission :
``` python
form SCOS.SCOS import SCOS, MissionID, SpacecraftID

MissionID[844]={'id':844, 'description': 'JUICE'}
SpacecraftID[844]={'id':844, 'description': 'JUICE'}

obj=SCOS[data]
```
In the next versions other missions will be implemented.

## Data Structure

The SCOS object contain:

* [**Common Packet Header Structure (CPH)**](#common-packet-header-structure-chp)

one of the following sub-object:

* [**Telemetry Packet Header (TMPH)**](#telemetry-packet-header-tmph)
* [**Telecommand Packet Header (TCPH)**](#telecommand-packet-header-tcph)
* [**Event Packet Header (EPH)**](#event-packet-header-eph) (not implemented)

and the attribute 

* **data** with the data in the packet as hex string

Many of the entries of the objects are dictionary. Usually the structure is the following: *{'id': x, 'description': 'blablabla'}* ad is reported in the tables.

### Common Packet Header Structure (CHP)


In the CHP are present the following fields.

Field |Description
---|---
**CTree** | Used in earlier version of SCOS-2000 by c-tree to support packets storing in files and be kept for backward compatibility.
**AccessF** | Storing mode, see [Access Flag Table](#access-flag-table)
**SimFlag** | Simulated packet, see [Simulated Packet Table](#simulated-packet-table)
**FilingTime** |Filing Time. For TM this is the timestamp. For TCs, this is the release time.
**CreationTime** | Creation Time. This is a secondary retrieval key and for TM is the time at which the SCOS-2000 packet was created, which is also approximately the time that the packet was received by the MCS and stored. For TCs, this is its (estimated) execution time.
**CreateID** | Used by the old SCOS-2000 archive for generating a retrieval key and set by the application which generated the packet.
**SCID** | In the case of telemetry, Spacecraft ID. See [Spacecraft ID Table](#spacecraft-id-table)
**GSID** | In the case of telemetry, the ID and name of the ground station which receives the frame containing this packet. See [Ground Stations Table](#ground-stations-table)
**PSize** | Packet Size. Size of the entire SCOS-2000 packet, including all headers and the packet data.
**PType** | Determines the type of SCOS-2000 packet. See [Packet Types Table](#packet-types-table)
**Version** | The version of this packet structure.
**FilingFlag** | Set to **1** if this packet is to be filed in the MCS archive, otherwise **0**.
**DistFlag** | Set to : **1** if this packet is to be distributed to the MCS applications, otherwise **0**.
**TSPolicy** | Determines the timestamp policy for spacecraft TM, i.e. what will be set in the Filing Time fields above. See [Timestamp Policy Table](#timestamp-policy-table)
**TQ** | Time quality of the timestamp, used only if the **TsPolicy** is set to **2**. See [Time Quality Table](#time-quality-table).
**StreamID** | The datastream identifier in the MCS, which for TM maps to VCs. See [Stream IDs Table](#stream-ids-table)
**SeqCounter** | Internal MCS counter used for detecting gaps – not related to the spacecraft source sequence count value in the PUS header.
**SPID** | the numerical packet ID which identifies the packet structure, and maps to packet definitions in the TM/TC MIB database. Note: For TC packets, SPIDs 100 and 200 are used.
**MissionID** | For telemetry, the MCS mission identifier. See [Mission IDs Table](#mission-ids-table)


#### Access Flag Table

ID | Description
---|---
**0** |  inserted packet
**1** | update

#### Simulated Packet Table

ID | Description
---|---
**0** | non-simulated packet generated by the spacecraft
**1** | simulated packet generated by a Simulator or test tool.

#### Spacecraft ID Table

ID | Spacecraft | Band
---|---|---
**816** | BepiColombo | TM received over X-Band.
**817** | BepiColombo | TM received over Ka-Band.

#### Ground Stations Table

ID | Description
---|---
**21** | Kourou 
**22** | Perth 
**23** | New Norcia
**24** | Cebreros 
**25** | Malargue 
**30** | Maspalomas 
**97** | Usuda 
**98** | Uchinoura 

#### Packet Types Table

ID | Description
---|---
**1** | Telemetry 
**2** | Telecommand 
**3** | Event 

#### Timestamp Policy Table

ID | Description
---|---
**0** | packet is time-stamped with the creation time – i.e. SCOS-2000 packet creation
**1** | The packet is time-stamped with the time of transmission of the frame it was received in, i.e. Earth Reception Time minus the propagation delay (applicable to spacecraft TM only)
**2** | the correlated SCET (for spacecraft TM only)

#### Time Quality Table

ID | Description
---|---
**0** | Good
**1** | Inaccurate
**2** | Bad

#### Stream IDs Table

ID | Description
---:|---
**1** | Used for TC stream
**1000** | VC0 Real-Time Non-Science (online)
**1001** | VC1 Playback Non-Science (online)
**1002** | VC2 Science (online)
**1003** | VC3 File-Transfer (online)
**2000** | VC0 Real-Time Non-Science (offline)
**2001** | VC1 Playback Non-Science (offline)
**2002** | VC1 Playback Non-Science (offline)
**2003** | VC2 Science (offline)
**65535** | is used for internal non spacecraft TM packets, which should be ignored by external users.

For EVs stream **1000** and **1001** are used.

#### Mission IDs Table

ID | Mission
---|---
**816** | BepiColombo 

### Telemetry Packet Header (TMPH)

If the _**CHP.PType**_ is equal to 1, the packet is a telemetry. In this case is present the TMPH onject.

The object has the following structure:

Attribute|Description
---|---
**TPSD**|Structure identifier for variable length packets.
**RouteID** |The LSB of the RouteID field is used by SCOS-2000 to identify the Data Unit Type of Telemetry packet and its qualifier
**PUSAPID** |The value of the 11-bit Application Process ID, copied from the spacecraft source packet’s primary header
**PUSSSC** |The value of the 14-bit Source Sequence Count, copied from the spacecraft source packet’s primary header
**PUSService** |The value of the 8-bit Service Type, copied from the spacecraft source packet’s secondary data field header. The old key *PUSST* is deprecated.
**PUSSubService** |The value of the 8-bit Service Sub-type, copied from the spacecraft source packet’s secondary data field header. The old key *PUSSST* is deprecated.


### Telecommand Packet Header (TCPH)
If the _**CHP.PType**_ is equal to 2, the packet is a telecommand. In this case is present the TCPH onject.

The object has the following structure:

Attribute | Descriprion
---|---
**UplinkTime** | Uplink Time – initially set to the release time (FT), but updated with the timestamp copied from the radiation ground station response message providing the actual time of uplink from the antenna.
**ExecTime** | Execution Time – For time-tagged commands this is the UTC user provided execution time. For immediate commands this is the release time + propagation delay and later updated to be Uplink time + propagation delay.
**LUTime** | Last Update Time, this is the MCS system time at which the TC packet was last updated with a change of status.
**RequestID** | Internal MCS identifier.
**ReqElemIdx** | Internal MCS sub-identifier.
**VarAddSz** | Combined size of the fixed and variable parts of the command details data.
**PUSAPID** | The value of the 11-bit Application Process ID, copied from the spacecraft source packet’s primary header.
**PID** | Process ID.
**PCAT** | Packet Category.
**PUSSSC** | The value of the 14-bit Sequence Count, copied from the spacecraft source packet’s primary header.
**PUSService** | Service Type - The value of the 8-bit Service Type, copied from the spacecraft source packet’s secondary data field header. The old key ***PUSST*** is deprecated.
**PUSSubService**  | Sub-Service Type - The value of the 8-bit Service Sub-type, copied from the spacecraft source packet’s secondary data field header. The old key ***PUSSST*** is deprecated.
**PUSAck** | The value of the 4-bit Ack, copied from the spacecraft source packet’s secondary data field header. See [Aknowledge Table](#aknowledge-table).
**UplinkFlag** | Uplink Flag. See [Uplink Codes Table](#uplink-codes-table).
**SourceHost** | Numerical ID of the MCS machine running the command source.
**SourceType** | Enumeration providing the type of the command source.
**ReqDetFixedSize** | Size of the fixed part of the command details data.
</table>

#### Aknowledge Table

ID | Description
---|---
**0**  | No Acknowledge required for acceptance and execution.
**1** | Acknowledge required for acceptance. 
**8**  | Acknowledge required for execution
**9** | Acknowledge required for acceptance and execution


#### Uplink Codes Table

ID | Description
---|---
**1** | if the command is to be released (passed PTV)
**0** | if the command is not to be released (failed PTV)


### Event Packet Header (EPH)
If the _**CHP.PType**_ is equal to 3, the packet is a event. In this case is present the EPH onject.

**NB:** the EPH is not yet implemented.

## Change Log

### Version 0.4.3
+ fixed a data type in te database

### Version 0.4.0
+ the fields of the subobject are now dict type.
+ improved prefomace
+ implemented the method to add a new mission dinamically.

### Version 0.3.0
+ tested on Python 3
+ minor bug fixef

### Version 0.2.2
+ bug fix, old call to database removed
+ update of the user manual

### Version 0.2.1

+ minor bugs fixed

### Version 0.2.0

+ Introduced the TCHP
+ First version of the README file.
