	
<!-- PROJECT LOGO -->
<br />
<p align="CENTER">
  <a href="https://www.ict.inaf.it/gitlab/proton_response_matrix/xmm-newton-proton-response-files">
    <img src="./logos/AHEAD2020_logo.png" alt="AHEAD2020_logo" height="130">
     <img src="./logos/HORIZON2020_logo.png" alt="HORIZON_logo" height="130">
     <img src="./logos/INAF_logo.png" alt="INAF_logo" height="130">
  </a>
  <h3 align="center">XMM-Newton proton response files</h3>

</p>



<!-- TABLE OF CONTENTS -->
## Table of Contents

* [About the Project](#about-the-project)
  * [Built with](#built-with)
* [Usage](#usage)
  * [Validity ranges](#validity-ranges)
* [License](#license)
* [Contact](#contact)
* [Acknowledgements](#acknowledgements)



<!-- ABOUT THE PROJECT -->
## About The Project

AHEAD2020 · Horizon 2020 Research and Innovation Programme · GA 871158
WP 9.8 "Understanding the interaction between soft protons and X-ray mirrors"

* Authors: V.Fioretti(1), T. Mineo(2), R. Amato(2), S. Lotti(3), C. Macculi(3), S. Molendi(4), F. Gastaldello(4), G. Lanzuisi(1), M. Cappi(1), M. Dadina(1), S. Ettori(1)
(1)INAF OAS Bologna, (2)INAF IASF Palermo, (3)INAF IAPS Roma, (4)INAF IASF Milano 

* Description: The proton response matrix for the XMM-Newton telescope is composed by a Redistribution Matrix File (RMF)
mapping the proton energy space (from 2 to 300 keV) into detector pulse height and an Auxiliary Response File (ARF) 
collecting the grasp of the optics, the filter transmission efficiency and the detector quantum efficiency. A PATTERN selection of 0 (only events that generate 1 pixel or Singles counts) is used.

* The files are formatted according to the NASA OGIP (Office of Guest Investigators Program) calibration database (caldb) format, and they are tested with the NASA HEASARC XSPEC analysis software tool.

### Documentation

The 



### Built with
The current release of the proton response files is based on:
* Geant4 v10.4 [Agostinelli et al. NIMPA, 506, 250, 2003; Allison et al. ITNS, 53, 270, 2006; Allison et al. NIMPA, 835, 186, 2016]
* BoGEMMS v2.1 [Fioretti et al., Proc. SPIE, 106993J 2018]
* Ray-tracing Monte Carlo code [Mineo et al., Exp. Astr., 44, 287, 2017] 


<!-- USAGE -->
## Usage

* The RMF and ARF files can be loaded with any X-ray analysis software compliant with the NASA caldb format.
* Since the accuracy of the Geant4 modeling of the proton stopping power degrades below 1 keV (20% at 1 keV reported in the Geant4 Physics Reference Manual), the energy redistribution is modelled from 1 keV to the upper threshold of the instrument X-ray RMF.
* The response files are available for three optical filters: 
  * thin: 0.16 um of polyimide and 0.04 um of aluminium
  * medium: 0.16 um of polyimide and 0.08 um of aluminium
  * thick: 0.33 um of polypropylene, and 0.11 um of aluminium, and 0.045 um of tin
  
### Validity ranges

Due to biases at the boundary of the RMF modeling, induced by features in the interpolation because of limited statistics in the simulation, the spectral analysis must be performed within the following intervals:
* MOS: 1.5 - 11.5 keV
* PN: 1.5 - 19.5 keV


<!-- LICENSE -->
## License

* Copyright (C) 2022 INAF - see LICENSE.rst

<!-- CONTACT -->
## Contact

Valentina Fioretti (INAF OAS Bologna) - valentina.fioretti<at>inaf.it
Project Link: [https://ahead.iaps.inaf.it/](https://ahead.iaps.inaf.it/)



<!-- ACKNOWLEDGEMENTS -->
## Acknowledgements
The research leading to these results has received funding from the European Union’s Horizon 2020 Programme under the AHEAD2020 project (grant agreement n. 871158).


