/*
 * Decompiled with CFR 0.152.
 */
package org.icmp4j.util;

import java.io.File;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.icmp4j.logger.Logger;

public class WindowsProcessUtil {
    private static final Logger logger = Logger.getLogger(WindowsProcessUtil.class);
    private static final AtomicReference<File> windowsRootDirectory = new AtomicReference();

    public static File findWindowsSystemFile(String fileName) {
        File systemRoot = WindowsProcessUtil.getWindowsRootDirectory();
        File system32Directory = new File(systemRoot, "system32");
        File file = new File(system32Directory, fileName);
        return file.exists() ? file : null;
    }

    public static File getWindowsSystemFile(String fileName) {
        File file = WindowsProcessUtil.findWindowsSystemFile(fileName);
        if (file != null) {
            return file;
        }
        throw new RuntimeException("file not found: " + fileName);
    }

    private static File findWindowsRootDirectory() {
        File directory;
        File windowsRootDirectory = WindowsProcessUtil.windowsRootDirectory.get();
        if (windowsRootDirectory != null) {
            return windowsRootDirectory;
        }
        Map<String, String> systemVariablesMap = new ProcessBuilder(new String[0]).environment();
        String path = systemVariablesMap.get("SystemRoot");
        logger.debug("findWindowsRootDirectory (): looking up env var SystemRoot: " + path);
        if (path != null && (directory = new File(path)).exists()) {
            WindowsProcessUtil.windowsRootDirectory.set(directory);
            return WindowsProcessUtil.findWindowsRootDirectory();
        }
        path = systemVariablesMap.get("windir");
        logger.debug("findWindowsRootDirectory (): looking up env var windir: " + path);
        if (path != null && (directory = new File(path)).exists()) {
            WindowsProcessUtil.windowsRootDirectory.set(directory);
            return WindowsProcessUtil.findWindowsRootDirectory();
        }
        return null;
    }

    private static File getWindowsRootDirectory() {
        File directory = WindowsProcessUtil.findWindowsRootDirectory();
        if (directory == null || !directory.isDirectory()) {
            throw new RuntimeException("Windows root directory not found");
        }
        return directory;
    }
}

