/*
 * Decompiled with CFR 0.152.
 */
package org.icmp4j.util;

import java.io.File;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicInteger;
import org.icmp4j.exception.AssertException;
import org.icmp4j.logger.Logger;
import org.icmp4j.util.FileUtil;
import org.icmp4j.util.TimeUtil;

public class SystemUtil {
    private static final Logger logger = Logger.getLogger(SystemUtil.class);
    private static final AtomicInteger nextLibraryId = new AtomicInteger();

    public static File extractLibraryByResource(String libraryName) {
        InputStream inputStream = SystemUtil.findLibraryAsStream(libraryName);
        if (inputStream == null) {
            throw new AssertException("resource not found: " + libraryName);
        }
        File appHomeDirectory = SystemUtil.getAppHomeDirectoryDirectory();
        File loadLibraryDirectory = new File(appHomeDirectory, "loadLibrary-" + libraryName);
        if (!loadLibraryDirectory.exists()) {
            logger.debug("creating temp directory: " + loadLibraryDirectory.getAbsolutePath());
            if (!loadLibraryDirectory.mkdirs()) {
                throw new AssertException("failed to create loadLibraryDirectory: " + loadLibraryDirectory.getAbsolutePath());
            }
        }
        int libraryId = nextLibraryId.incrementAndGet();
        String uniqueLibraryName = TimeUtil.formatDateAsFileSystemName() + "_" + String.valueOf(libraryId);
        File uniqueLibraryFile = new File(loadLibraryDirectory, uniqueLibraryName);
        uniqueLibraryFile.deleteOnExit();
        String uniqueLibraryPath = uniqueLibraryFile.getAbsolutePath();
        logger.debug("creating temp library: " + uniqueLibraryPath);
        FileUtil.writeFile(uniqueLibraryFile, inputStream);
        return uniqueLibraryFile;
    }

    private static InputStream findLibraryAsStream(String libraryName) {
        String resourcePath = "/" + libraryName;
        InputStream inputStream = SystemUtil.class.getResourceAsStream(resourcePath);
        String message = inputStream == null ? "findResourceAsStream (): resource " + resourcePath + " not found" : "findResourceAsStream (): resource " + resourcePath + " found";
        logger.debug(message);
        return inputStream;
    }

    private static File getAppHomeDirectoryDirectory() {
        File userHomeDirectory = new File(System.getProperty("user.home"));
        return new File(userHomeDirectory, "icmp4j");
    }
}

