/*
 * Decompiled with CFR 0.152.
 */
package org.icmp4j.util;

import java.util.LinkedList;
import java.util.List;

public class StringUtil {
    private static String newLine = System.getProperty("line.separator");

    public static void setNewLine(String newLine) {
        StringUtil.newLine = newLine;
    }

    public static String getNewLine() {
        return newLine;
    }

    public static boolean isSameAsEmpty(String value) {
        return value == null || value.trim().length() == 0;
    }

    public static String joinByNewLine(List<String> stringList) {
        if (stringList == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (String string : stringList) {
            if (sb.length() > 0) {
                sb.append(StringUtil.getNewLine());
            }
            sb.append(string);
        }
        return sb.toString();
    }

    public static int length(String string) {
        if (string == null) {
            return 0;
        }
        return string.length();
    }

    public static String parseString(String string, String beginDelimiter, String endDelimiter) {
        int beginDelimiterIndex = string.indexOf(beginDelimiter);
        if (beginDelimiterIndex < 0) {
            return null;
        }
        int fromIndex = beginDelimiterIndex + beginDelimiter.length();
        int endDelimiterIndex = string.indexOf(endDelimiter, fromIndex);
        if (endDelimiterIndex < 0) {
            return null;
        }
        return string.substring(fromIndex, endDelimiterIndex);
    }

    public static String parseSequentialDigits(String string, String beginDelimiter) {
        char character;
        int beginDelimiterIndex = string.indexOf(beginDelimiter);
        if (beginDelimiterIndex < 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int nextIndex = beginDelimiterIndex + beginDelimiter.length(); nextIndex < string.length() && Character.isDigit(character = string.charAt(nextIndex)); ++nextIndex) {
            sb.append(character);
        }
        return sb.length() > 0 ? sb.toString() : null;
    }

    public static List<String> splitLoose(String string, String regex) {
        String[] subStringArray;
        LinkedList<String> stringList = new LinkedList<String>();
        for (String subString : subStringArray = string.split(regex)) {
            String cleanedSubString = subString.trim();
            if (cleanedSubString.length() == 0) continue;
            stringList.add(cleanedSubString);
        }
        return stringList;
    }
}

