/*
 * Decompiled with CFR 0.152.
 */
package org.icmp4j.util;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.icmp4j.exception.AssertException;
import org.icmp4j.logger.Logger;
import org.icmp4j.util.PlatformUtil;

public class ResourceUtil {
    private static final Logger logger = Logger.getLogger(ResourceUtil.class);

    public static File findResourceAsFile(String resourceName) throws AssertException {
        URL urlObject = ResourceUtil.findResourceAsURL(resourceName);
        if (urlObject == null) {
            return null;
        }
        try {
            String url = urlObject.toString();
            logger.debug("url: " + url);
            URI fileUri = new URI(url);
            logger.debug("fileUri: " + fileUri);
            String decodedFilePath = fileUri.getPath();
            logger.debug("decodedFilePath: " + decodedFilePath);
            if (decodedFilePath == null) {
                logger.warn("findResourceAsFile (). resourceName: " + resourceName + ", decodedFilePath is null: returning null");
                return null;
            }
            File file = new File(decodedFilePath);
            if (!file.exists()) {
                throw new AssertException("resourceName " + resourceName + " found in url " + url + " but file does not exist: " + file.getAbsolutePath());
            }
            return file;
        }
        catch (URISyntaxException e) {
            logger.error("resourceName: " + resourceName);
            logger.error(e);
            return null;
        }
    }

    private static URL findResourceAsURL(String resourceName) {
        URL url = ResourceUtil.class.getResource(resourceName);
        if (url != null) {
            return url;
        }
        String fullPath = (resourceName.startsWith("/") ? "" : "/") + resourceName;
        return ResourceUtil.class.getResource(fullPath);
    }

    public static String buildLibraryName(String libraryName) {
        int os = PlatformUtil.getOsFamilyCode();
        switch (os) {
            case 1: {
                StringBuilder sb = new StringBuilder().append(libraryName).append(".dll");
                return sb.toString();
            }
            case 3: {
                StringBuilder sb = new StringBuilder().append("lib").append(libraryName).append(".dylib");
                return sb.toString();
            }
            case 2: {
                String arch = System.getProperty("os.arch");
                arch = arch.contains("64") ? "64bit" : "32bit";
                StringBuilder sb = new StringBuilder().append("lib").append(libraryName).append("_").append(arch).append(".so");
                return sb.toString();
            }
        }
        throw new UnsupportedOperationException("architecture not handle");
    }
}

