/*
 * Decompiled with CFR 0.152.
 */
package org.icmp4j.util;

import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import org.icmp4j.util.IpAddressUtil;

public class NetUtil {
    public static String findFirstLocalHostIpv4Address() {
        try {
            Enumeration<NetworkInterface> networkInterfacesEnumeration = NetworkInterface.getNetworkInterfaces();
            while (networkInterfacesEnumeration.hasMoreElements()) {
                NetworkInterface networkInterface = networkInterfacesEnumeration.nextElement();
                Enumeration<InetAddress> inetAddressEnumeration = networkInterface.getInetAddresses();
                while (inetAddressEnumeration.hasMoreElements()) {
                    InetAddress inetAddress = inetAddressEnumeration.nextElement();
                    String address = inetAddress.getHostAddress();
                    if (!inetAddress.isSiteLocalAddress() || inetAddress.isLoopbackAddress() || !IpAddressUtil.validateIpv4Address(address)) continue;
                    return inetAddress.getHostAddress();
                }
            }
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

