/*
 * Decompiled with CFR 0.152.
 */
package org.icmp4j.util;

import com.sun.jna.Native;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.icmp4j.logger.Logger;
import org.icmp4j.util.ExceptionUtil;
import org.icmp4j.util.ResourceUtil;
import org.icmp4j.util.SystemUtil;

public class JnaUtil {
    private static final Logger logger = Logger.getLogger(JnaUtil.class);
    private static final Map<String, Object> libraryMap = new HashMap<String, Object>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object loadLibrary(String libraryName, Class libraryClass) {
        Object library;
        Object object = libraryMap;
        synchronized (object) {
            library = libraryMap.get(libraryName);
            if (library != null) {
                return library;
            }
        }
        object = JnaUtil.class;
        synchronized (JnaUtil.class) {
            String path;
            String resourceName;
            File resourceFile;
            String strategy = "native via java.library.path";
            library = JnaUtil.loadLibraryNoException("native via java.library.path", libraryName, libraryClass);
            if (library == null && (resourceFile = ResourceUtil.findResourceAsFile(resourceName = ResourceUtil.buildLibraryName(libraryName))) != null) {
                String strategy2 = "native via resource lookup";
                path = resourceFile.getAbsolutePath();
                library = JnaUtil.loadLibraryNoException("native via resource lookup", path, libraryClass);
            }
            if (library == null) {
                resourceName = ResourceUtil.buildLibraryName(libraryName);
                String strategy3 = "as-resource";
                File file = SystemUtil.extractLibraryByResource(resourceName);
                path = file.getAbsolutePath();
                library = JnaUtil.loadLibraryNoException("as-resource", path, libraryClass);
            }
            if (library == null) {
                throw new RuntimeException("Failed to load library ");
            }
            Map<String, Object> map = libraryMap;
            synchronized (map) {
                libraryMap.put(libraryName, library);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return JnaUtil.loadLibrary(libraryName, libraryClass);
        }
    }

    public static Object loadLibraryBestEffort(String libraryName, Class libraryClass) {
        try {
            return JnaUtil.loadLibrary(libraryName, libraryClass);
        }
        catch (RuntimeException e) {
            logger.warn(e.getMessage());
            return null;
        }
    }

    private static Object loadLibraryNoException(String strategy, String libraryName, Class libraryClass) {
        try {
            logger.debug("loadLibrary2 ()");
            logger.debug("  strategy: " + strategy);
            logger.debug("  libraryName: " + libraryName);
            logger.debug("  libraryClass: " + libraryClass.getName());
            return Native.loadLibrary((String)libraryName, (Class)libraryClass);
        }
        catch (Throwable t) {
            logger.warn("loadLibraryNoException (). Native.loadLibrary () failed. exception " + t.getClass().getName() + ", errorMessage: " + ExceptionUtil.getMessage(t));
            return null;
        }
    }
}

