/*
 * Decompiled with CFR 0.152.
 */
package org.icmp4j.util;

import java.util.List;
import org.icmp4j.util.StringUtil;

public class IpAddressUtil {
    public static boolean validateIpv4Address(String address) {
        int expectedOctetCount = 4;
        return IpAddressUtil.validateIpAddressOrSegment(address, 4);
    }

    private static boolean validateIpAddressOrSegment(String address, int expectedOctetCount) {
        List<String> octetList = IpAddressUtil.getOctetList(address);
        if (octetList.size() != expectedOctetCount) {
            return false;
        }
        for (String octetAsString : octetList) {
            try {
                int octet = Integer.parseInt(octetAsString);
                if (octet >= 0 && octet <= 255) continue;
                return false;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return true;
    }

    public static List<String> getOctetList(String address) {
        return StringUtil.splitLoose(address, "\\.");
    }
}

