/*
 * Decompiled with CFR 0.152.
 */
package org.icmp4j.tool;

import org.icmp4j.Icmp4jUtil;
import org.icmp4j.IcmpPingRequest;
import org.icmp4j.IcmpPingResponse;
import org.icmp4j.IcmpPingUtil;
import org.icmp4j.logger.PrintStreamLogger;
import org.icmp4j.platform.NativeBridge;
import org.icmp4j.util.ArgUtil;

public class Ping {
    public static void main(String[] args) {
        try {
            if (ArgUtil.findArgument(args, "-h") || ArgUtil.findArgument(args, "-help") || ArgUtil.findArgument(args, "-?") || ArgUtil.findArgument(args, "/?")) {
                System.out.println("Usage: java -cp * -Djava.library.path=. org.icmp4j.tool.Ping [-debug] [-nativeBridge <NativeBridge class>] [-charsetName <charset>] [-count <number of pings>] [-timeout <msecs>] [-source <IPv4 of source interface>] <target host name or IPv4 address>");
                System.out.println("");
                System.out.println("Examples:");
                System.out.println("  java -cp * -Djava.library.path=. org.icmp4j.tool.Ping -h");
                System.out.println("  java -cp * -Djava.library.path=. org.icmp4j.tool.Ping www.google.com");
                System.out.println("  java -cp * -Djava.library.path=. org.icmp4j.tool.Ping -count 1 -timeout 5000 www.google.com");
                System.out.println("  java -cp * -Djava.library.path=. org.icmp4j.tool.Ping -count 1 -timeout 5000 -source 192.168.1.7 www.google.com");
                System.out.println("  java -cp * -Djava.library.path=. org.icmp4j.tool.Ping -nativeBridge org.icmp4j.platform.windows.WindowsProcessNativeBridge -count 1 -timeout 5000 -source 192.168.1.7 www.google.com");
                System.out.println("  java -cp * -Djava.library.path=. org.icmp4j.tool.Ping -debug -nativeBridge org.icmp4j.platform.windows.WindowsProcessNativeBridge -charsetName CP866 -count 1 -timeout 5000 -source 192.168.1.7 www.google.com");
                System.out.println("");
                System.out.println("Known NativeBridge implementations:");
                System.out.println("  1. Windows - org.icmp4j.platform.windows.WindowsNativeBridge: uses JNA and IcmpSendEcho");
                System.out.println("  2. Windows - org.icmp4j.platform.windows.WindowsProcessNativeBridge: spawns ping.exe");
                System.out.println("  3. Linux - org.icmp4j.platform.unix.LinuxProcessNativeBridge: spawns the ping executable");
                System.out.println("  4. Mac - org.icmp4j.platform.unix.MacProcessNativeBridge: spawns the ping executable");
                System.out.println("  5. Unix - org.icmp4j.platform.unix.jna.UnixJnaNativeBridge: uses JNA and send ()");
                System.out.println("  6. Unix - org.icmp4j.platform.unix.jni.UnixJniNativeBridge: uses JNI and send ()");
                return;
            }
            boolean debugFlag = ArgUtil.findArgValue(args, "-debug") != null;
            int count = ArgUtil.findArgValueAsInt(args, "-count", 4);
            int timeout = ArgUtil.findArgValueAsInt(args, "-timeout", 0);
            String charsetName = ArgUtil.findArgValue(args, "-charsetName");
            String source = ArgUtil.findArgValue(args, "-source");
            String host = args.length > 0 ? args[args.length - 1] : "google.com";
            NativeBridge nativeBridge = null;
            String nativeBridgeClassName = ArgUtil.findArgValue(args, "-nativeBridge");
            if (nativeBridgeClassName != null) {
                Class<?> nativeBridgeClass = Class.forName(nativeBridgeClassName);
                nativeBridge = (NativeBridge)nativeBridgeClass.newInstance();
                nativeBridge.initialize();
            }
            String logLevel = debugFlag ? "DEBUG" : "INFO";
            PrintStreamLogger.setLogLevel(logLevel);
            Icmp4jUtil.setNativeBridge(nativeBridge);
            Icmp4jUtil.initialize();
            if (debugFlag) {
                NativeBridge runtimeNativeBridge = Icmp4jUtil.getNativeBridge();
                System.out.println("runtimeNativeBridge: " + runtimeNativeBridge.getClass().getName());
            }
            IcmpPingRequest request = IcmpPingUtil.createIcmpPingRequest();
            request.setCharsetName(charsetName);
            request.setHost(host);
            request.setSource(source);
            request.setTimeout(timeout);
            for (int number = 1; number <= count; ++number) {
                IcmpPingResponse response = IcmpPingUtil.executePingRequest(request);
                if (debugFlag) {
                    String output;
                    String command = response.getCommand();
                    if (command != null) {
                        System.out.println("command: " + command);
                    }
                    if ((output = response.getOutput()) != null) {
                        System.out.println("<output>");
                        System.out.println(output);
                        System.out.println("</output>");
                    }
                }
                String formattedResponse = IcmpPingUtil.formatResponse(response);
                System.out.println(formattedResponse);
                Thread.sleep(1000L);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

