/*
 * Decompiled with CFR 0.152.
 */
package org.icmp4j.platform.windows;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import org.icmp4j.IcmpPingRequest;
import org.icmp4j.IcmpPingResponse;
import org.icmp4j.IcmpPingUtil;
import org.icmp4j.platform.NativeBridge;
import org.icmp4j.util.ProcessUtil;
import org.icmp4j.util.StringUtil;
import org.icmp4j.util.WindowsProcessUtil;

public class WindowsProcessNativeBridge
extends NativeBridge {
    @Override
    public IcmpPingResponse executePingRequest(IcmpPingRequest request) {
        try {
            boolean timeoutFlag;
            String source = request.getSource();
            String host = request.getHost();
            long timeout = request.getTimeout();
            int packetSize = request.getPacketSize();
            String charsetName = request.getCharsetName();
            File pingExeFile = WindowsProcessUtil.getWindowsSystemFile("ping.exe");
            String command = "\"" + pingExeFile.getAbsolutePath() + "\" -n 1 " + (packetSize > 0 ? "-l " + packetSize + " " : "") + (timeout > 0L ? "-w " + timeout + " " : "") + (source != null ? "-S " + source + " " : "") + host;
            long icmpSendEchoStartTime = System.currentTimeMillis();
            List<String> stringList = ProcessUtil.executeProcessAndGetOutputAsStringList(command, charsetName);
            long icmpSendEchoDuration = System.currentTimeMillis() - icmpSendEchoStartTime;
            boolean bl = timeoutFlag = icmpSendEchoDuration >= timeout;
            if (timeoutFlag) {
                return IcmpPingUtil.createTimeoutIcmpPingResponse(icmpSendEchoDuration);
            }
            IcmpPingResponse response = this.executePingRequest(stringList);
            response.setCommand(command);
            response.setOutput(StringUtil.joinByNewLine(stringList));
            return response;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public IcmpPingResponse executePingRequest(List<String> stringList) {
        for (String string : stringList) {
            if (!string.startsWith("Reply from ")) continue;
            String sizeAsString = StringUtil.parseSequentialDigits(string, "bytes=");
            int size = Integer.parseInt(sizeAsString);
            String responseAddress = StringUtil.parseString(string, "from ", ":");
            String ttlAsString = StringUtil.parseSequentialDigits(string, "TTL=");
            int ttl = Integer.parseInt(ttlAsString);
            String rttAsStringEquals = StringUtil.parseSequentialDigits(string, "time=");
            String rttAsStringLessThan = StringUtil.parseSequentialDigits(string, "time<");
            String rttAsString = rttAsStringEquals != null ? rttAsStringEquals : rttAsStringLessThan;
            Float rttAsFloat = Float.valueOf(Float.parseFloat(rttAsString));
            int rtt = rttAsFloat.intValue();
            IcmpPingResponse response = new IcmpPingResponse();
            response.setHost(responseAddress);
            response.setErrorMessage(null);
            response.setRtt(rtt);
            response.setSize(size);
            response.setSuccessFlag(true);
            response.setTtl(ttl);
            return response;
        }
        Iterator<String> iterator = stringList.iterator();
        if (iterator.hasNext()) {
            String string;
            string = iterator.next();
            IcmpPingResponse response = new IcmpPingResponse();
            response.setErrorMessage(string);
            response.setSuccessFlag(false);
            return response;
        }
        IcmpPingResponse response = new IcmpPingResponse();
        response.setErrorMessage("No results could be parsed");
        response.setSuccessFlag(false);
        return response;
    }
}

