/*
 * Decompiled with CFR 0.152.
 */
package org.icmp4j.platform.windows;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import java.net.InetAddress;
import org.icmp4j.IcmpPingRequest;
import org.icmp4j.IcmpPingResponse;
import org.icmp4j.IcmpPingUtil;
import org.icmp4j.platform.NativeBridge;
import org.icmp4j.platform.windows.jna.IcmpLibrary;
import org.icmp4j.platform.windows.jna.LibraryUtil;
import org.icmp4j.platform.windows.jna.Winsock2Library;

public class WindowsNativeBridge
extends NativeBridge {
    @Override
    public void initialize() {
        LibraryUtil.initialize();
        Winsock2Library winsock2Library = LibraryUtil.getWinsock2Library();
        Winsock2Library.WSAData wsadata = new Winsock2Library.WSAData();
        if (winsock2Library.WSAStartup((short)2, wsadata) != 0) {
            throw new RuntimeException("WSAStartup failed");
        }
    }

    @Override
    public void destroy() {
        Winsock2Library winsock2Library = LibraryUtil.getWinsock2Library();
        if (winsock2Library != null) {
            winsock2Library.WSACleanup();
        }
    }

    @Override
    public synchronized IcmpPingResponse executePingRequest(IcmpPingRequest request) {
        IcmpPingResponse icmpPingResponse;
        block12: {
            long icmpSendEchoDuration;
            Memory replyData;
            Pointer hIcmp;
            IcmpLibrary icmpLibrary;
            block10: {
                IcmpPingResponse icmpPingResponse2;
                block11: {
                    int lastError;
                    int returnCode;
                    block8: {
                        IcmpPingResponse icmpPingResponse3;
                        block9: {
                            icmpLibrary = LibraryUtil.getIcmpLibrary();
                            String source = request.getSource();
                            String host = request.getHost();
                            int ttl = request.getTtl();
                            int size = request.getPacketSize();
                            int timeout = new Long(request.getTimeout()).intValue();
                            if (source != null) {
                                throw new RuntimeException("request attribute source is NOT supported by this NativeBridge implementation");
                            }
                            hIcmp = null;
                            InetAddress address = InetAddress.getByName(host);
                            byte[] ipAddressAsByteArray = address.getAddress();
                            IcmpLibrary.IpAddrByVal ipaddr = new IcmpLibrary.IpAddrByVal();
                            ipaddr.bytes = ipAddressAsByteArray;
                            int replyDataSize = size + new IcmpLibrary.IcmpEchoReply().size();
                            Memory sendData = new Memory((long)size);
                            replyData = new Memory((long)replyDataSize);
                            IcmpLibrary.IpOptionInformationByRef ipOption = new IcmpLibrary.IpOptionInformationByRef();
                            ipOption.ttl = (byte)ttl;
                            ipOption.tos = 0;
                            ipOption.flags = 0;
                            ipOption.optionsSize = 0;
                            ipOption.optionsData = null;
                            int timeout2 = timeout > 0 ? timeout : 60000;
                            hIcmp = icmpLibrary.IcmpCreateFile();
                            long icmpSendEchoStartNanoTime = System.nanoTime();
                            returnCode = icmpLibrary.IcmpSendEcho(hIcmp, ipaddr, (Pointer)sendData, (short)size, ipOption, (Pointer)replyData, replyDataSize, timeout2);
                            long icmpSendEchoNanoDuration = System.nanoTime() - icmpSendEchoStartNanoTime;
                            icmpSendEchoDuration = icmpSendEchoNanoDuration / 1000L / 1000L;
                            lastError = Kernel32.INSTANCE.GetLastError();
                            if (lastError != 11010) break block8;
                            icmpPingResponse3 = IcmpPingUtil.createTimeoutIcmpPingResponse(icmpSendEchoDuration);
                            if (hIcmp == null) break block9;
                            icmpLibrary.IcmpCloseHandle(hIcmp);
                        }
                        return icmpPingResponse3;
                    }
                    if (returnCode != 0) break block10;
                    String errorMessage = "IcmpSendEcho failed. Last error: " + lastError;
                    IcmpPingResponse response = new IcmpPingResponse();
                    response.setErrorMessage(errorMessage);
                    response.setSuccessFlag(false);
                    icmpPingResponse2 = response;
                    if (hIcmp == null) break block11;
                    icmpLibrary.IcmpCloseHandle(hIcmp);
                }
                return icmpPingResponse2;
            }
            try {
                IcmpLibrary.IcmpEchoReply icmpEchoReply = new IcmpLibrary.IcmpEchoReply((Pointer)replyData);
                boolean successFlag = icmpEchoReply.status == 0;
                String responseAddress = String.format("%d.%d.%d.%d", icmpEchoReply.address.bytes[0] & 0xFF, icmpEchoReply.address.bytes[1] & 0xFF, icmpEchoReply.address.bytes[2] & 0xFF, icmpEchoReply.address.bytes[3] & 0xFF);
                String message = WindowsNativeBridge.getStatusText(icmpEchoReply.status);
                IcmpPingResponse response = new IcmpPingResponse();
                response.setDuration(icmpSendEchoDuration);
                response.setHost(responseAddress);
                response.setErrorMessage(message);
                response.setRtt(icmpEchoReply.roundTripTime);
                response.setSize(icmpEchoReply.dataSize);
                response.setSuccessFlag(successFlag);
                response.setTtl(icmpEchoReply.options.ttl & 0xFF);
                icmpPingResponse = response;
                if (hIcmp == null) break block12;
                icmpLibrary.IcmpCloseHandle(hIcmp);
            }
            catch (Exception e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    if (hIcmp != null) {
                        icmpLibrary.IcmpCloseHandle(hIcmp);
                    }
                    throw throwable;
                }
            }
        }
        return icmpPingResponse;
    }

    private static String getStatusText(int status) {
        switch (status) {
            case 0: {
                return "SUCCESS";
            }
            case 11000: {
                return "IP_SUCCESS";
            }
            case 11001: {
                return "IP_BUF_TOO_SMALL";
            }
            case 11002: {
                return "IP_DEST_NET_UNREACHABLE";
            }
            case 11003: {
                return "IP_DEST_HOST_UNREACHABLE";
            }
            case 11004: {
                return "IP_DEST_PROT_UNREACHABLE";
            }
            case 11005: {
                return "IP_DEST_PORT_UNREACHABLE";
            }
            case 11006: {
                return "IP_NO_RESOURCES";
            }
            case 11007: {
                return "IP_BAD_OPTION";
            }
            case 11008: {
                return "IP_HW_ERROR";
            }
            case 11009: {
                return "IP_PACKET_TOO_BIG";
            }
            case 11010: {
                return "IP_REQ_TIMED_OUT";
            }
            case 11011: {
                return "IP_BAD_REQ";
            }
            case 11012: {
                return "IP_BAD_ROUTE";
            }
            case 11013: {
                return "IP_TTL_EXPIRED_TRANSIT";
            }
            case 11014: {
                return "IP_TTL_EXPIRED_REASSEM";
            }
            case 11015: {
                return "IP_PARAM_PROBLEM";
            }
            case 11016: {
                return "IP_SOURCE_QUENCH";
            }
            case 11017: {
                return "IP_OPTION_TOO_BIG";
            }
            case 11018: {
                return "IP_BAD_DESTINATION";
            }
            case 11050: {
                return "IP_GENERAL_FAILURE";
            }
        }
        return "UNKNOWN_STATUS";
    }
}

