/*
 * Decompiled with CFR 0.152.
 */
package org.icmp4j.platform.unix;

import java.util.Iterator;
import java.util.List;
import org.icmp4j.IcmpPingRequest;
import org.icmp4j.IcmpPingResponse;
import org.icmp4j.IcmpPingUtil;
import org.icmp4j.exception.ParseException;
import org.icmp4j.platform.NativeBridge;
import org.icmp4j.util.ProcessUtil;
import org.icmp4j.util.StringUtil;

public class LinuxProcessNativeBridge
extends NativeBridge {
    @Override
    public IcmpPingResponse executePingRequest(IcmpPingRequest request) {
        String source = request.getSource();
        if (source != null) {
            throw new RuntimeException("request attribute source is NOT supported by this NativeBridge implementation");
        }
        String command = null;
        List<String> lineList = null;
        boolean parseExceptionFlag = false;
        try {
            boolean timeoutFlag;
            String host = request.getHost();
            int timeout = new Long(request.getTimeout()).intValue();
            long timeout2 = timeout < 1000 ? 1000L : (long)timeout;
            long timeoutAsSeconds = timeout2 / 1000L;
            int packetSize = request.getPacketSize();
            String charsetName = request.getCharsetName();
            command = "ping -c 1 -s " + packetSize + " -w " + timeoutAsSeconds + " " + host;
            long icmpSendEchoStartTime = System.currentTimeMillis();
            lineList = this.executeProcessAndGetOutputAsStringList(command, charsetName);
            long icmpSendEchoDuration = System.currentTimeMillis() - icmpSendEchoStartTime;
            boolean bl = timeoutFlag = icmpSendEchoDuration >= timeout2;
            if (timeoutFlag) {
                return IcmpPingUtil.createTimeoutIcmpPingResponse(icmpSendEchoDuration);
            }
            parseExceptionFlag = true;
            IcmpPingResponse response = this.executePingRequest(lineList);
            parseExceptionFlag = false;
            response.setCommand(command);
            response.setOutput(StringUtil.joinByNewLine(lineList));
            return response;
        }
        catch (Exception e) {
            String output = StringUtil.joinByNewLine(lineList);
            if (parseExceptionFlag) {
                throw new ParseException("command: " + command + ", output: " + output, e);
            }
            throw new RuntimeException("command: " + command + ", output: " + output, e);
        }
    }

    public IcmpPingResponse executePingRequest(List<String> lineList) {
        for (String line : lineList) {
            int icmpReqIndex = line.indexOf("icmp_req=");
            int icmpSeqIndex = line.indexOf("icmp_seq=");
            if (icmpReqIndex < 0 && icmpSeqIndex < 0) continue;
            if (line.endsWith("Destination Host Unreachable")) {
                IcmpPingResponse response = new IcmpPingResponse();
                response.setErrorMessage("Destination Host Unreachable");
                response.setSuccessFlag(false);
                return response;
            }
            int size = 0;
            int bytesIndex = line.indexOf(" bytes");
            if (bytesIndex > 0) {
                String sizeAsString = line.substring(0, bytesIndex);
                size = Integer.parseInt(sizeAsString);
            }
            String responseAddress = StringUtil.parseString(line, "from ", " ");
            String ttlAsString = StringUtil.parseString(line, "ttl=", " ");
            int ttl = Integer.parseInt(ttlAsString);
            String rttAsString = StringUtil.parseString(line, "time=", "ms");
            String rttAsString2 = rttAsString.trim();
            Float rttAsFloat = Float.valueOf(Float.parseFloat(rttAsString2));
            int rtt = rttAsFloat.intValue();
            IcmpPingResponse response = new IcmpPingResponse();
            response.setHost(responseAddress);
            response.setErrorMessage(null);
            response.setRtt(rtt);
            response.setSize(size);
            response.setSuccessFlag(true);
            response.setTtl(ttl);
            return response;
        }
        Iterator<String> iterator = lineList.iterator();
        if (iterator.hasNext()) {
            String string = iterator.next();
            IcmpPingResponse response = new IcmpPingResponse();
            response.setErrorMessage(string);
            response.setSuccessFlag(false);
            return response;
        }
        IcmpPingResponse response = new IcmpPingResponse();
        response.setErrorMessage("No results could be parsed");
        response.setSuccessFlag(false);
        return response;
    }

    protected List<String> executeProcessAndGetOutputAsStringList(String command, String charsetName) {
        return ProcessUtil.executeProcessAndGetOutputAsStringList(command, charsetName);
    }
}

