/*
 * Decompiled with CFR 0.152.
 */
package org.icmp4j.logger;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.icmp4j.logger.Logger;

public class LoggerAdapter
extends Logger {
    public static final String DEBUG = "DEBUG";
    public static final String INFO = "INFO";
    public static final String ERROR = "ERROR";
    public static final String FATAL = "FATAL";
    public static final String WARN = "WARN";
    public static final String TRACE = "TRACE";
    private static int logLevel = 2;
    private static final List<Logger> loggerList = new LinkedList<Logger>();
    private final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private Object category;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addLogger(Logger logger) {
        List<Logger> list = loggerList;
        synchronized (list) {
            loggerList.add(logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeLogger(Logger logger) {
        List<Logger> list = loggerList;
        synchronized (list) {
            loggerList.remove(logger);
        }
    }

    public static void setLoglevel(String logLevelString) {
        logLevel = logLevelString.equalsIgnoreCase(TRACE) ? 1 : (logLevelString.equalsIgnoreCase(DEBUG) ? 2 : (logLevelString.equalsIgnoreCase(INFO) ? 3 : (logLevelString.equalsIgnoreCase(ERROR) ? 4 : (logLevelString.equalsIgnoreCase(WARN) ? 5 : (logLevelString.equalsIgnoreCase(FATAL) ? 6 : logLevel)))));
    }

    @Override
    public void setCategory(Object category) {
        this.category = category;
    }

    @Override
    public Object getCategory() {
        return this.category;
    }

    public LoggerAdapter() {
    }

    public LoggerAdapter(Object category) {
        this.category = category;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void log2(int logLevel, Object object, Throwable t) {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append('<');
            sb.append(this.simpleDateFormat.format(new Date()));
            sb.append('>');
            sb.append(" <");
            sb.append(LoggerAdapter.getLogLevelText(logLevel));
            sb.append('>');
            String categoryName = this.category instanceof Class ? ((Class)this.category).getSimpleName() : this.category.toString();
            sb.append(" <");
            sb.append(categoryName);
            sb.append('>');
            sb.append(" <");
            if (object != null && t == null) {
                sb.append(object);
            } else if (object == null && t != null) {
                sb.append(LoggerAdapter.getStackTrace(t));
            } else if (object != null && t != null) {
                sb.append(object);
                sb.append("\n\r");
                sb.append(LoggerAdapter.getStackTrace(t));
            }
            sb.append('>');
            List<Logger> list = loggerList;
            synchronized (list) {
                for (Logger logger : loggerList) {
                    logger.log2(logLevel, object, t);
                }
            }
            String line = sb.toString();
            this.printLine(logLevel, line);
        }
        catch (Exception e) {
            String string = object == null ? "null" : object.toString();
            this.printLine(logLevel, string);
        }
    }

    protected void printLine(int logLevel, String line) {
    }

    @Override
    public boolean isDebugEnabled() {
        return 2 >= logLevel;
    }

    @Override
    public boolean isInfoEnabled() {
        return 3 >= logLevel;
    }

    @Override
    public boolean isTraceEnabled() {
        return 1 >= logLevel;
    }

    protected static String getStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        return sw.toString();
    }
}

