/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.pkcs.jcajce;

import java.io.InputStream;
import java.security.Key;
import java.security.Provider;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.KeySpec;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.spongycastle.asn1.ASN1Encodable;
import org.spongycastle.asn1.ASN1ObjectIdentifier;
import org.spongycastle.asn1.ASN1OctetString;
import org.spongycastle.asn1.cryptopro.GOST28147Parameters;
import org.spongycastle.asn1.pkcs.PBES2Parameters;
import org.spongycastle.asn1.pkcs.PBKDF2Params;
import org.spongycastle.asn1.pkcs.PKCS12PBEParams;
import org.spongycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.spongycastle.asn1.x509.AlgorithmIdentifier;
import org.spongycastle.jcajce.provider.symmetric.util.BCPBEKey;
import org.spongycastle.jcajce.spec.GOST28147ParameterSpec;
import org.spongycastle.jcajce.spec.PBKDF2KeySpec;
import org.spongycastle.jcajce.util.DefaultJcaJceHelper;
import org.spongycastle.jcajce.util.JcaJceHelper;
import org.spongycastle.jcajce.util.NamedJcaJceHelper;
import org.spongycastle.jcajce.util.ProviderJcaJceHelper;
import org.spongycastle.operator.DefaultSecretKeySizeProvider;
import org.spongycastle.operator.InputDecryptor;
import org.spongycastle.operator.InputDecryptorProvider;
import org.spongycastle.operator.OperatorCreationException;
import org.spongycastle.operator.SecretKeySizeProvider;

public class JcePKCSPBEInputDecryptorProviderBuilder {
    private JcaJceHelper helper = new DefaultJcaJceHelper();
    private boolean wrongPKCS12Zero = false;
    private SecretKeySizeProvider keySizeProvider = DefaultSecretKeySizeProvider.INSTANCE;

    public JcePKCSPBEInputDecryptorProviderBuilder setProvider(Provider provider) {
        this.helper = new ProviderJcaJceHelper(provider);
        return this;
    }

    public JcePKCSPBEInputDecryptorProviderBuilder setProvider(String providerName) {
        this.helper = new NamedJcaJceHelper(providerName);
        return this;
    }

    public JcePKCSPBEInputDecryptorProviderBuilder setTryWrongPKCS12Zero(boolean tryWrong) {
        this.wrongPKCS12Zero = tryWrong;
        return this;
    }

    public JcePKCSPBEInputDecryptorProviderBuilder setKeySizeProvider(SecretKeySizeProvider keySizeProvider) {
        this.keySizeProvider = keySizeProvider;
        return this;
    }

    public InputDecryptorProvider build(final char[] password) {
        return new InputDecryptorProvider(){
            private Cipher cipher;
            private SecretKey key;
            private AlgorithmIdentifier encryptionAlg;

            public InputDecryptor get(AlgorithmIdentifier algorithmIdentifier) throws OperatorCreationException {
                ASN1ObjectIdentifier algorithm = algorithmIdentifier.getAlgorithm();
                try {
                    if (algorithm.on(PKCSObjectIdentifiers.pkcs_12PbeIds)) {
                        PKCS12PBEParams pbeParams = PKCS12PBEParams.getInstance((Object)algorithmIdentifier.getParameters());
                        PBEKeySpec pbeSpec = new PBEKeySpec(password);
                        SecretKeyFactory keyFact = JcePKCSPBEInputDecryptorProviderBuilder.this.helper.createSecretKeyFactory(algorithm.getId());
                        PBEParameterSpec defParams = new PBEParameterSpec(pbeParams.getIV(), pbeParams.getIterations().intValue());
                        this.key = keyFact.generateSecret(pbeSpec);
                        if (this.key instanceof BCPBEKey) {
                            ((BCPBEKey)this.key).setTryWrongPKCS12Zero(JcePKCSPBEInputDecryptorProviderBuilder.this.wrongPKCS12Zero);
                        }
                        this.cipher = JcePKCSPBEInputDecryptorProviderBuilder.this.helper.createCipher(algorithm.getId());
                        this.cipher.init(2, (Key)this.key, defParams);
                        this.encryptionAlg = algorithmIdentifier;
                    } else if (algorithm.equals((Object)PKCSObjectIdentifiers.id_PBES2)) {
                        PBES2Parameters alg = PBES2Parameters.getInstance((Object)algorithmIdentifier.getParameters());
                        PBKDF2Params func = PBKDF2Params.getInstance((Object)alg.getKeyDerivationFunc().getParameters());
                        AlgorithmIdentifier encScheme = AlgorithmIdentifier.getInstance((Object)alg.getEncryptionScheme());
                        SecretKeyFactory keyFact = JcePKCSPBEInputDecryptorProviderBuilder.this.helper.createSecretKeyFactory(alg.getKeyDerivationFunc().getAlgorithm().getId());
                        this.key = func.isDefaultPrf() ? keyFact.generateSecret(new PBEKeySpec(password, func.getSalt(), func.getIterationCount().intValue(), JcePKCSPBEInputDecryptorProviderBuilder.this.keySizeProvider.getKeySize(encScheme))) : keyFact.generateSecret((KeySpec)new PBKDF2KeySpec(password, func.getSalt(), func.getIterationCount().intValue(), JcePKCSPBEInputDecryptorProviderBuilder.this.keySizeProvider.getKeySize(encScheme), func.getPrf()));
                        this.cipher = JcePKCSPBEInputDecryptorProviderBuilder.this.helper.createCipher(alg.getEncryptionScheme().getAlgorithm().getId());
                        this.encryptionAlg = AlgorithmIdentifier.getInstance((Object)alg.getEncryptionScheme());
                        ASN1Encodable encParams = alg.getEncryptionScheme().getParameters();
                        if (encParams instanceof ASN1OctetString) {
                            this.cipher.init(2, (Key)this.key, new IvParameterSpec(ASN1OctetString.getInstance((Object)encParams).getOctets()));
                        } else {
                            GOST28147Parameters gParams = GOST28147Parameters.getInstance((Object)encParams);
                            this.cipher.init(2, (Key)this.key, (AlgorithmParameterSpec)new GOST28147ParameterSpec(gParams.getEncryptionParamSet(), gParams.getIV()));
                        }
                    }
                }
                catch (Exception e) {
                    throw new OperatorCreationException("unable to create InputDecryptor: " + e.getMessage(), e);
                }
                return new InputDecryptor(){

                    public AlgorithmIdentifier getAlgorithmIdentifier() {
                        return encryptionAlg;
                    }

                    public InputStream getInputStream(InputStream input) {
                        return new CipherInputStream(input, cipher);
                    }
                };
            }
        };
    }
}

