/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.operator.bc;

import java.io.OutputStream;
import java.security.SecureRandom;
import org.spongycastle.asn1.x509.AlgorithmIdentifier;
import org.spongycastle.crypto.CipherParameters;
import org.spongycastle.crypto.CryptoException;
import org.spongycastle.crypto.Signer;
import org.spongycastle.crypto.params.AsymmetricKeyParameter;
import org.spongycastle.crypto.params.ParametersWithRandom;
import org.spongycastle.operator.ContentSigner;
import org.spongycastle.operator.OperatorCreationException;
import org.spongycastle.operator.RuntimeOperatorException;
import org.spongycastle.operator.bc.BcDefaultDigestProvider;
import org.spongycastle.operator.bc.BcDigestProvider;
import org.spongycastle.operator.bc.BcSignerOutputStream;

public abstract class BcContentSignerBuilder {
    private SecureRandom random;
    private AlgorithmIdentifier sigAlgId;
    private AlgorithmIdentifier digAlgId;
    protected BcDigestProvider digestProvider;

    public BcContentSignerBuilder(AlgorithmIdentifier sigAlgId, AlgorithmIdentifier digAlgId) {
        this.sigAlgId = sigAlgId;
        this.digAlgId = digAlgId;
        this.digestProvider = BcDefaultDigestProvider.INSTANCE;
    }

    public BcContentSignerBuilder setSecureRandom(SecureRandom random) {
        this.random = random;
        return this;
    }

    public ContentSigner build(AsymmetricKeyParameter privateKey) throws OperatorCreationException {
        final Signer sig = this.createSigner(this.sigAlgId, this.digAlgId);
        if (this.random != null) {
            sig.init(true, (CipherParameters)new ParametersWithRandom((CipherParameters)privateKey, this.random));
        } else {
            sig.init(true, (CipherParameters)privateKey);
        }
        return new ContentSigner(){
            private BcSignerOutputStream stream;
            {
                this.stream = new BcSignerOutputStream(sig);
            }

            public AlgorithmIdentifier getAlgorithmIdentifier() {
                return BcContentSignerBuilder.this.sigAlgId;
            }

            public OutputStream getOutputStream() {
                return this.stream;
            }

            public byte[] getSignature() {
                try {
                    return this.stream.getSignature();
                }
                catch (CryptoException e) {
                    throw new RuntimeOperatorException("exception obtaining signature: " + e.getMessage(), e);
                }
            }
        };
    }

    protected abstract Signer createSigner(AlgorithmIdentifier var1, AlgorithmIdentifier var2) throws OperatorCreationException;
}

