/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.cert.dane;

import org.spongycastle.cert.X509CertificateHolder;
import org.spongycastle.cert.dane.DANEEntry;
import org.spongycastle.cert.dane.DANEEntrySelector;
import org.spongycastle.cert.dane.DANEEntrySelectorFactory;
import org.spongycastle.cert.dane.DANEException;
import org.spongycastle.operator.DigestCalculator;

public class DANEEntryFactory {
    private final DANEEntrySelectorFactory selectorFactory;

    public DANEEntryFactory(DigestCalculator digestCalculator) {
        this.selectorFactory = new DANEEntrySelectorFactory(digestCalculator);
    }

    public DANEEntry createEntry(String emailAddress, X509CertificateHolder certificate) throws DANEException {
        DANEEntrySelector entrySelector = this.selectorFactory.createSelector(emailAddress);
        byte[] flags = new byte[]{3, 0, 0};
        return new DANEEntry(entrySelector.getDomainName(), flags, certificate);
    }
}

