/*
 * Decompiled with CFR 0.152.
 */
package cds.xml;

import cds.aladin.Aladin;
import cds.aladin.MyInputStream;
import cds.aladin.TapManager;
import cds.xml.XMLConsumer;
import cds.xml.XMLParser;
import java.io.IOException;
import java.net.URL;
import java.util.Hashtable;

public class VOSICapabilitiesReader
implements XMLConsumer {
    private boolean inTableAccessCapabilityTag = false;
    private int readHardUploadLimit = -1;
    private boolean uploadAllowed = false;
    private long uploadHardLimit = -1L;

    public boolean load(URL capabilitiesUrl) {
        XMLParser xmlParser = new XMLParser(this);
        boolean result = false;
        MyInputStream inputStream = null;
        this.resetFlags();
        try {
            long startTime = TapManager.getTimeToLog();
            inputStream = new MyInputStream(capabilitiesUrl.openStream());
            long time = TapManager.getTimeToLog();
            if (Aladin.levelTrace >= 4) {
                System.out.println("getTapCapabilities got inputstream: " + time + " total time taken: " + (time - startTime));
            }
            startTime = TapManager.getTimeToLog();
            result = xmlParser.parse(inputStream);
            time = TapManager.getTimeToLog();
            if (Aladin.levelTrace >= 4) {
                System.out.println("getTapCapabilities parsed: " + time + " total time taken: " + (time - startTime));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private void resetFlags() {
        this.inTableAccessCapabilityTag = false;
        this.readHardUploadLimit = -1;
    }

    @Override
    public void startElement(String name, Hashtable atts) {
        if (name.equals("capability")) {
            if (atts.containsKey("standardid") && atts.get("standardid").equals("ivo://ivoa.net/std/TAP") && atts.containsKey("xsi:type") && atts.get("xsi:type").equals("tr:TableAccess")) {
                this.inTableAccessCapabilityTag = true;
            }
        } else if (this.inTableAccessCapabilityTag) {
            if (name.equals("uploadMethod")) {
                this.uploadAllowed = true;
            } else if (name.equals("uploadLimit")) {
                ++this.readHardUploadLimit;
            } else if (name.equals("hard") && this.readHardUploadLimit == 0) {
                ++this.readHardUploadLimit;
            }
        }
    }

    @Override
    public void endElement(String name) {
        if (this.inTableAccessCapabilityTag && name.equals("capability")) {
            this.inTableAccessCapabilityTag = false;
        } else if (name.equals("uploadLimit")) {
            this.readHardUploadLimit = -1;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws Exception {
        String data = new String(ch, start, length);
        if (this.inTableAccessCapabilityTag && this.readHardUploadLimit == 1) {
            this.uploadHardLimit = Long.parseLong(data);
        }
    }

    public boolean isUploadAllowed() {
        return this.uploadAllowed;
    }

    public void setUploadAllowed(boolean uploadAllowed) {
        this.uploadAllowed = uploadAllowed;
    }

    public long getUploadHardLimit() {
        return this.uploadHardLimit;
    }

    public void setUploadHardLimit(long uploadHardLimit) {
        this.uploadHardLimit = uploadHardLimit;
    }
}

