/*
 * Decompiled with CFR 0.152.
 */
package cds.xml;

import cds.aladin.Aladin;
import cds.xml.XMLParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Random;
import java.util.Stack;

public class ExamplesReader {
    public char prevChar;
    public boolean isInTag = false;
    public boolean isInEndTag = false;
    public boolean isInAttri = false;
    public boolean isAttriStart = false;
    public boolean isAttributeValue = false;
    public char attributeEndChar;
    public boolean doReadContent = false;
    public String attriName;
    public String attriValue;
    public StringBuffer content = new StringBuffer();
    public StringBuffer tag = new StringBuffer();
    public Map attributes = new HashMap();
    private Stack tagStack;

    public static void main(String[] args) {
        try {
            URL address = new URL("http://130.79.129.54:8080/griTapExamples.1");
            new ExamplesReader().parse(address.openStream());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Map<String, String> parse(InputStream is) throws IOException {
        int charNext;
        InputStreamReader pageInput = new InputStreamReader(is);
        BufferedReader source = new BufferedReader(pageInput);
        DaliExamplesReader reader = new DaliExamplesReader();
        this.tagStack = new Stack();
        while ((charNext = source.read()) != -1) {
            char characterRead = (char)charNext;
            if (characterRead == '<') {
                if (this.content.length() > 0) {
                    reader.characters(this.content);
                    this.content = new StringBuffer();
                }
                this.isInTag = true;
                this.tag = new StringBuffer();
            } else if (characterRead == '!' && this.prevChar == '<') {
                this.isInTag = false;
                this.isInAttri = false;
                this.tag = new StringBuffer();
                this.doReadContent = false;
                this.isInEndTag = false;
            } else if ((this.isInTag || this.isInAttri) && characterRead == '>' && this.prevChar == '/') {
                this.isInTag = false;
                this.isInAttri = false;
                reader.startElement(this.tag.toString(), this.attributes);
                this.attributes.clear();
                reader.endElement(this.tag.toString());
                this.tag = new StringBuffer();
            } else if ((this.isInTag || this.isInAttri) && characterRead == '>') {
                this.isInAttri = false;
                this.isInTag = false;
                this.tagStack.push(this.tag.toString());
                reader.startElement(this.tag.toString(), this.attributes);
                this.attributes.clear();
                this.content = new StringBuffer();
                this.doReadContent = true;
            } else if (characterRead == '/' && this.prevChar == '<') {
                this.tag = new StringBuffer();
                this.isInTag = false;
                this.isInEndTag = true;
                this.isInAttri = false;
                this.doReadContent = false;
                if (!this.tagStack.isEmpty() && this.content.length() > 0) {
                    reader.characters(this.content);
                    this.content = new StringBuffer();
                }
            } else if (this.isInEndTag && characterRead == '>') {
                this.isInEndTag = false;
                if (!this.tagStack.isEmpty()) {
                    this.tagStack.pop();
                    reader.endElement(this.tag.toString());
                }
                this.doReadContent = true;
            } else if (this.isInTag && characterRead == ' ') {
                this.isInAttri = true;
                this.isAttriStart = true;
                this.content = new StringBuffer();
                this.isInTag = false;
            } else if (this.isInTag || this.isInEndTag) {
                if (characterRead != '>' && characterRead != '/') {
                    this.tag.append(characterRead);
                }
            } else if (this.isInAttri) {
                if (this.isAttriStart && (characterRead == ' ' || characterRead == '=') && this.content.toString().trim().length() > 0) {
                    this.attriName = this.content.toString();
                    this.attriName = this.attriName.replaceAll("\\s", "");
                    this.content = new StringBuffer();
                    this.attributeEndChar = (char)32;
                    this.isAttriStart = false;
                    this.isAttributeValue = true;
                } else if (this.isAttributeValue && characterRead == '=') {
                    this.isAttributeValue = true;
                } else if (this.isAttributeValue) {
                    if (this.attriName != null && characterRead == this.attributeEndChar && this.content.length() > 0) {
                        this.attriValue = this.content.toString();
                        this.attributes.put(this.attriName, this.attriValue);
                        this.isAttributeValue = false;
                        this.isAttriStart = true;
                        this.content = new StringBuffer();
                        this.attriName = null;
                        this.attriValue = null;
                    } else if (this.content.length() == 0 && (characterRead == '\'' || characterRead == '\"')) {
                        this.attributeEndChar = characterRead;
                    } else {
                        this.content.append(characterRead);
                    }
                } else {
                    this.content.append(characterRead);
                }
            } else if (this.doReadContent) {
                this.content.append(characterRead);
            }
            this.prevChar = characterRead;
        }
        pageInput.close();
        source.close();
        Aladin.trace(3, "Read these many examples " + reader.examples.size());
        return reader.examples;
    }

    class DaliExamplesReader {
        private boolean inExamplesTag = true;
        private boolean inExampleTag = false;
        private boolean inNameTag = false;
        private boolean inQueryTag = false;
        private String exampleTag = null;
        private String nameTag = null;
        private String queryTag = null;
        private String exampleLabel = null;
        private boolean wait = false;
        private Stack tagStack;
        private StringBuffer content = null;
        private Map<String, String> examples = new Hashtable<String, String>();

        public void startElement(String qName, Map<String, String> attributes) {
            if (this.inExamplesTag) {
                if (this.inExampleTag) {
                    this.tagStack.push(qName);
                    if (attributes.get("property") != null) {
                        String propertyValue = attributes.get("property");
                        if (propertyValue.equalsIgnoreCase("name") || propertyValue.equalsIgnoreCase("name")) {
                            this.inNameTag = true;
                            this.nameTag = qName;
                        } else if (propertyValue.equals("query")) {
                            this.inQueryTag = true;
                            this.queryTag = qName;
                        }
                    }
                } else if (attributes.get("typeof") != null && attributes.get("typeof").equals("example")) {
                    this.inExampleTag = true;
                    this.tagStack = new Stack();
                    this.tagStack.push(qName);
                    this.exampleTag = qName;
                    this.content = new StringBuffer();
                }
            }
        }

        public void endElement(String qName) {
            if (this.inExampleTag) {
                String tagLeft = (String)this.tagStack.pop();
                if (this.tagStack.isEmpty() && tagLeft.equals(this.exampleTag)) {
                    this.inExampleTag = false;
                } else if (this.inNameTag && tagLeft.equals(this.nameTag)) {
                    this.inNameTag = false;
                } else if (this.inQueryTag && tagLeft.equals(this.queryTag)) {
                    String value;
                    if (this.exampleLabel == null) {
                        this.exampleLabel = "Service provided example ";
                        this.exampleLabel = this.generateQueryName(this.exampleLabel);
                    }
                    if ((value = XMLParser.XMLDecode(this.content.toString())) != null) {
                        this.examples.put(this.exampleLabel, value);
                    }
                    this.inQueryTag = false;
                    this.resetInExampleFlags();
                }
            }
        }

        public void characters(StringBuffer ch) {
            if (ch.length() > 0) {
                String data = ch.toString();
                if (this.inExamplesTag && this.inExampleTag) {
                    if (this.inNameTag) {
                        this.exampleLabel = data;
                        this.inNameTag = false;
                    } else if (this.inQueryTag) {
                        this.content.append(data);
                    }
                }
            }
        }

        public String generateQueryName(String prefix) {
            String uploadTableName = prefix + new Random().nextInt(31);
            if (!this.examples.containsKey(uploadTableName)) {
                return uploadTableName;
            }
            return this.generateQueryName(prefix);
        }

        private void resetInExampleFlags() {
            this.inExampleTag = false;
            this.inNameTag = false;
            this.inQueryTag = false;
            this.exampleLabel = null;
            this.content = new StringBuffer();
        }

        public Map<String, String> getExamples() {
            if (this.examples != null && this.examples.isEmpty()) {
                this.examples = null;
            }
            return this.examples;
        }
    }
}

