/*
 * Decompiled with CFR 0.152.
 */
package cds.vizier;

import java.awt.Font;
import java.awt.Toolkit;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public final class VizieRList
extends JList {
    protected JTextField catalog;
    protected JButton getReadMe;
    protected int hCaracterCount = 0;
    protected MyList list;
    static final boolean LSCREEN = Toolkit.getDefaultToolkit().getScreenSize().width > 1000;
    protected static final int SIZE = LSCREEN ? 12 : 10;
    protected static Font COURIER = new Font("Monospaced", 0, SIZE);

    public VizieRList(JTextField catalog, JButton getReadMe, Vector v) {
        this(catalog, getReadMe, v, 20);
    }

    public VizieRList(JTextField catalog, JButton getReadMe, Vector v, int rows) {
        this.setVisibleRowCount(rows);
        this.catalog = catalog;
        this.getReadMe = getReadMe;
        this.setFont(COURIER);
        this.list = new MyList();
        this.setModel(this.list);
        this.preSelection(v);
        this.addListSelectionListener(new ListenList());
    }

    public VizieRList(Vector v) {
        this(null, null, v, 20);
    }

    public void preSelection(Vector v) {
        this.list.initList(v);
    }

    public Vector getList() {
        return this.list.v;
    }

    public void resetList() {
        this.getSelectionModel().clearSelection();
    }

    public JTextField getCatalogField() {
        return this.catalog;
    }

    public JTextField getCatalogTextField() {
        return this.catalog;
    }

    public void setReadMeButton(JButton getReadMe) {
        this.getReadMe = getReadMe;
    }

    public void setCatalogTextField(JTextField catalog) {
        this.catalog = catalog;
    }

    public JButton getReadMeButton() {
        return this.getReadMe;
    }

    public int getHCaracterCount() {
        return this.hCaracterCount;
    }

    class ListenList
    implements ListSelectionListener {
        ListenList() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            int i;
            String s = "";
            Object[] name = VizieRList.this.getSelectedValues();
            for (i = 0; i < name.length; ++i) {
                StringTokenizer st = new StringTokenizer((String)name[i], " :");
                String id = st.nextToken();
                s = !s.equals("") ? s + "," + id : id;
            }
            if (VizieRList.this.catalog != null) {
                VizieRList.this.catalog.setText(s);
            }
            if (VizieRList.this.getReadMe != null) {
                VizieRList.this.getReadMe.setEnabled(i == 1);
                String lastSelectedCatalog = (String)VizieRList.this.getSelectedValue();
                if (lastSelectedCatalog != null) {
                    StringTokenizer st = new StringTokenizer(lastSelectedCatalog, " :");
                    String id = st.nextToken();
                }
            }
        }
    }

    class MyList
    implements ListModel {
        private Vector v;

        MyList() {
        }

        protected int initList(Vector v) {
            this.v = (Vector)v.clone();
            int hCaracterCount = 0;
            Enumeration e = v.elements();
            while (e.hasMoreElements()) {
                int l = ((String)e.nextElement()).length();
                if (l <= hCaracterCount) continue;
                hCaracterCount = l;
            }
            return hCaracterCount;
        }

        protected void add(String s) {
            this.v.add(s);
        }

        public Object getElementAt(int index) {
            return this.v.elementAt(index);
        }

        @Override
        public int getSize() {
            return this.v.size();
        }

        @Override
        public void addListDataListener(ListDataListener l) {
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
        }
    }
}

