/*
 * Decompiled with CFR 0.152.
 */
package cds.tools;

import java.awt.Color;
import java.awt.Component;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class TwoColorJTable
extends JTable {
    public static Color DEFAULT_ALTERNATE_COLOR = new Color(241, 241, 254);
    private Color alternateColor = DEFAULT_ALTERNATE_COLOR;

    public TwoColorJTable(TableModel tableModel, Color alternateColor) {
        super(tableModel);
        this.alternateColor = alternateColor;
    }

    public TwoColorJTable(Vector<Vector<String>> tabledata, Vector<String> columnNames) {
        super(tabledata, columnNames);
    }

    public TwoColorJTable() {
    }

    public TwoColorJTable(TableModel tableModel) {
        super(tableModel);
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        if (this.getParent() instanceof JViewport) {
            JViewport parent = (JViewport)this.getParent();
            return parent.getHeight() > this.getPreferredSize().height;
        }
        return false;
    }

    protected Color colorForRow(int row) {
        return row % 2 == 0 ? this.getBackground() : this.alternateColor;
    }

    @Override
    public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
        Component c = super.prepareRenderer(renderer, row, column);
        if (!this.isCellSelected(row, column)) {
            c.setBackground(this.colorForRow(row));
            c.setForeground(UIManager.getColor("Table.foreground"));
        } else {
            c.setBackground(UIManager.getColor("Table.selectionBackground"));
            c.setForeground(UIManager.getColor("Table.selectionForeground"));
        }
        return c;
    }
}

