/*
 * Decompiled with CFR 0.152.
 */
package cds.tools;

import cds.aladin.Aladin;
import cds.astro.Unit;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ScientificUnitsUtil {
    static final double light_speed_m_per_second = 2.998E8;
    static final double hc_wavelength_to_ev_constant = 1.24E-6;
    static final String FREQUENCYUNIT_STRING = "Hz";
    static final String METERUNIT_STRING = "m";
    static final String eVUNIT_STRING = "eV";
    static final String EXPONENT_STRING = "E";
    static final String NUMBER_FORMATTER_STRING = "##0.#####E0";
    static final Map<String, String> metricPrefixes = new HashMap<String, String>();
    static final String endOfWordPrefix = "[a-zA-Z]$";
    private static final NumberFormat formatter;

    public static double getUnitInMeters(String input) throws ParseException {
        double result;
        try {
            Pattern alphabetsPrefix = Pattern.compile(endOfWordPrefix);
            Matcher m = alphabetsPrefix.matcher(input);
            if (m.find()) {
                String s = m.group(0);
                Unit inputUnit = new Unit(s + METERUNIT_STRING);
                inputUnit.value = Double.parseDouble(input.replaceAll(endOfWordPrefix, ""));
                ScientificUnitsUtil.convertToMeters(inputUnit);
                result = inputUnit.value;
            } else {
                result = Double.parseDouble(input);
            }
        }
        catch (ParseException e) {
            if (Aladin.levelTrace >= 3) {
                e.printStackTrace();
            }
            throw e;
        }
        return result;
    }

    public static void convertToMeters(Unit input) {
        block2: {
            try {
                Unit unitInMeter = new Unit(METERUNIT_STRING);
                input.convertTo(unitInMeter);
            }
            catch (ParseException e) {
                if (Aladin.levelTrace < 3) break block2;
                e.printStackTrace();
            }
        }
    }

    public static Unit convertMeter2Frequency(Double wavelength) {
        Unit frequency;
        block2: {
            frequency = null;
            try {
                Double frequencyValue = 2.998E8 / wavelength;
                frequency = new Unit(FREQUENCYUNIT_STRING);
                frequency.value = frequencyValue;
            }
            catch (ParseException e) {
                if (Aladin.levelTrace < 3) break block2;
                e.printStackTrace();
            }
        }
        return frequency;
    }

    public static Unit convertMeter2eV(Double wavelength) {
        Unit energy;
        block2: {
            energy = null;
            try {
                Double energyValue = 1.24E-6 / wavelength;
                energy = new Unit(eVUNIT_STRING);
                energy.value = energyValue;
            }
            catch (ParseException e) {
                if (Aladin.levelTrace < 3) break block2;
                e.printStackTrace();
            }
        }
        return energy;
    }

    public static String prefixProcessing(Unit unitToProcess) {
        StringBuilder displayString;
        String unit = unitToProcess.getUnit();
        String metricPrefix = null;
        String valueInProcess = formatter.format(unitToProcess.value);
        int i = valueInProcess.indexOf(69);
        if (i > 0) {
            String numeral = valueInProcess.substring(0, i);
            String basePower = valueInProcess.substring(i + 1);
            metricPrefix = metricPrefixes.get(basePower);
            displayString = new StringBuilder(numeral).append(metricPrefix).append(unit);
        } else {
            displayString = new StringBuilder(valueInProcess).append(unit);
        }
        return displayString.toString();
    }

    static {
        metricPrefixes.put("-24", "y");
        metricPrefixes.put("-21", "z");
        metricPrefixes.put("-18", "a");
        metricPrefixes.put("-15", "f");
        metricPrefixes.put("-12", "p");
        metricPrefixes.put("-9", "n");
        metricPrefixes.put("-6", "\u00b5");
        metricPrefixes.put("-3", METERUNIT_STRING);
        metricPrefixes.put("0", "");
        metricPrefixes.put("3", "k");
        metricPrefixes.put("6", "M");
        metricPrefixes.put("9", "G");
        metricPrefixes.put("12", "T");
        metricPrefixes.put("15", "P");
        metricPrefixes.put("18", EXPONENT_STRING);
        metricPrefixes.put("21", "Z");
        metricPrefixes.put("24", "Y");
        formatter = new DecimalFormat(NUMBER_FORMATTER_STRING);
    }
}

