/*
 * Decompiled with CFR 0.152.
 */
package cds.savot.samples;

import cds.savot.binary.DataBinaryReader;
import cds.savot.model.FieldSet;
import cds.savot.model.SavotBinary;
import cds.savot.model.SavotResource;
import cds.savot.stax.SavotStaxParser;
import java.io.File;
import java.io.PrintStream;
import java.util.Date;

public class VotableReader_SavotBinary {
    SavotStaxParser sb = null;
    private static final String PARENT_DIRECTORY = "/Users/andre/eclipse-workspace2/Savot/VOTable-Tests-V4.0/b";
    private static final String VOTABLE_PATH = "/Users/andre/eclipse-workspace2/Savot/VOTable-Tests-V4.0/b" + File.separatorChar + "fat64.xml";
    private static final String DATA_OUTPUT = null;

    public static final void main(String[] args) throws Exception {
        VotableReader_SavotBinary parser = new VotableReader_SavotBinary();
        parser.parse(VOTABLE_PATH);
    }

    public void parse(String fileOrUrl) throws Exception {
        System.out.println("Parsing begin ");
        Date dates = new Date();
        this.sb = new SavotStaxParser(fileOrUrl, 0);
        System.out.println("item count : " + this.sb.getAllResources().getResources().getItemCount());
        Date datef = new Date();
        System.out.println("Parsing ends with a duration of " + (datef.getHours() * 3600 + datef.getMinutes() * 60 + datef.getSeconds() - (dates.getHours() * 3600 + dates.getMinutes() * 60 + dates.getSeconds())) + " s");
        for (int item = 0; item < this.sb.getAllResources().getResources().getItemCount(); ++item) {
            SavotBinary binary = ((SavotResource)this.sb.getAllResources().getResources().getItemAt(item)).getData(0).getBinary();
            if (binary != null) {
                System.out.println(binary.getStream().getContent());
                FieldSet fields = ((SavotResource)this.sb.getAllResources().getResources().getItemAt(item)).getFieldSet(0);
                DataBinaryReader parser = new DataBinaryReader(binary.getStream(), fields, false, PARENT_DIRECTORY);
                PrintStream output = DATA_OUTPUT != null ? new PrintStream(DATA_OUTPUT) : System.out;
                output.println("\n*** DATA ***");
                if (!parser.next()) continue;
                output.print("-> ");
                for (int j = 0; j < fields.getItemCount(); ++j) {
                    output.print(parser.getCellAsString(j) + " ; ");
                }
                output.println();
                continue;
            }
            System.out.println("no binary");
        }
        System.out.println("item count : " + this.sb.getAllResources().getResources().getItemCount());
        System.out.println("Parsing end ");
    }
}

