/*
 * Decompiled with CFR 0.152.
 */
package cds.savot.model.interpreter;

import cds.savot.model.interpreter.BinaryFieldInterpreter;
import cds.savot.model.interpreter.BinaryInterpreterException;

public class IntegerInterpreter
extends BinaryFieldInterpreter<Integer> {
    public IntegerInterpreter() throws BinaryInterpreterException {
        this(new int[]{1});
    }

    public IntegerInterpreter(int[] arraysizes) throws BinaryInterpreterException {
        super(arraysizes, "integer value", 4);
    }

    @Override
    public Integer decodePrimary(byte[] b, int offset) throws BinaryInterpreterException {
        return (b[offset] & 0xFF) << 24 | (b[offset + 1] & 0xFF) << 16 | (b[offset + 2] & 0xFF) << 8 | b[offset + 3] & 0xFF;
    }

    @Override
    protected Class<Integer[]> getArrayClass() {
        return Integer[].class;
    }

    @Override
    protected Integer convertPrimary(Object value) throws BinaryInterpreterException {
        if (value == null) {
            return null;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof String) {
            try {
                return Integer.parseInt((String)value);
            }
            catch (NumberFormatException nfe) {
                throw new BinaryInterpreterException("Impossible to convert \"" + value + "\" into an Integer: " + nfe.getMessage() + " !");
            }
        }
        throw new BinaryInterpreterException("Impossible to convert a " + value.getClass().getName() + " into an Integer !");
    }

    @Override
    public byte[] encodePrimary(Integer value) throws BinaryInterpreterException {
        if (value == null) {
            return new byte[]{-1, -1, -1, -1};
        }
        byte[] encoded = new byte[]{(byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)(value & 0xFF)};
        return encoded;
    }
}

