/*
 * Decompiled with CFR 0.152.
 */
package cds.savot.model.interpreter;

import cds.savot.model.interpreter.BinaryFieldInterpreter;
import cds.savot.model.interpreter.BinaryInterpreterException;

public class BooleanInterpreter
extends BinaryFieldInterpreter<Boolean> {
    public BooleanInterpreter(int[] arraysizes) throws BinaryInterpreterException {
        super(arraysizes, "logical value", 1);
    }

    @Override
    public Boolean decodePrimary(byte[] b, int offset) throws BinaryInterpreterException {
        char temp = (char)(b[offset] & 0xFF);
        switch (temp) {
            case '1': 
            case 'T': 
            case 't': {
                return Boolean.TRUE;
            }
            case '0': 
            case 'F': 
            case 'f': {
                return Boolean.FALSE;
            }
            case '\u0000': 
            case ' ': 
            case '?': {
                return null;
            }
        }
        throw new BinaryInterpreterException("Unknown logical representation: \"" + temp + "\" !");
    }

    @Override
    protected Class<Boolean[]> getArrayClass() {
        return Boolean[].class;
    }

    @Override
    protected Boolean convertPrimary(Object value) throws BinaryInterpreterException {
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.equalsIgnoreCase("true") || str.equalsIgnoreCase("t") || str.equalsIgnoreCase("1")) {
                return Boolean.TRUE;
            }
            if (str.equalsIgnoreCase("false") || str.equalsIgnoreCase("f") || str.equalsIgnoreCase("0")) {
                return Boolean.FALSE;
            }
            return null;
        }
        throw new BinaryInterpreterException("Impossible to convert a " + value.getClass().getName() + " into a Boolean !");
    }

    @Override
    public byte[] encodePrimary(Boolean value) throws BinaryInterpreterException {
        if (value == null) {
            return this.getPadding();
        }
        return new byte[]{value != false ? (byte)49 : 48};
    }
}

