/*
 * Decompiled with CFR 0.152.
 */
package cds.savot.binary;

import cds.savot.binary.Base64;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class Base64InputStream
extends FilterInputStream {
    private static int defaultBufferSize = 8192;
    private byte[] buffer;
    private int fetchSize;
    private int pos;
    private int count;
    private boolean eom = false;
    private int pad = 0;
    private int group = 0;
    private int nbGroupedChars = 0;

    public Base64InputStream(InputStream encodedStream) {
        this(encodedStream, defaultBufferSize);
    }

    public Base64InputStream(InputStream encodedStream, int bufferSize) {
        super(encodedStream);
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("bufferSize <= 0");
        }
        this.buffer = new byte[bufferSize];
        this.count = 0;
        this.pos = 0;
        this.fetchSize = bufferSize / 3;
        if (bufferSize % 3 != 0) {
            ++this.fetchSize;
        }
        this.fetchSize *= 4;
    }

    private void ensureOpen() throws IOException {
        if (this.in == null) {
            throw new IOException("Stream closed");
        }
    }

    private void fill() throws IOException {
        this.pos = 0;
        this.count = 0;
        byte[] data = new byte[this.fetchSize];
        int n1 = this.in.read(data);
        if (n1 == -1) {
            if (this.nbGroupedChars > 0) {
                throw new IOException("Encoded message corrupted: unexpected EOF !");
            }
            return;
        }
        for (int i = 0; !this.eom && i < n1; ++i) {
            if (Base64.base64decode[data[i]] > -1) {
                if (this.pad > 0 && data[i] != 61) {
                    throw new IOException("Encoded message corrupted: \"" + (char)data[i] + "\" has been encountered after a padding character (\"" + '=' + "\") !");
                }
                this.group |= (Base64.base64decode[data[i]] & 0x3F) << 6 * (3 - this.nbGroupedChars);
                ++this.nbGroupedChars;
                if (data[i] == 61) {
                    ++this.pad;
                }
            } else if (!Character.isWhitespace(data[i])) {
                System.err.println("Warning: encoded message may be corrupted: unknown base64 character encountered: \"" + (char)data[i] + "\" !");
            }
            if (this.nbGroupedChars != 4) continue;
            if (this.pad > 0) {
                this.eom = true;
            }
            if (this.pad > 2) {
                throw new IOException("Encoded message corrupted: a message encoding in base64 can end with at most 2 padding characters (\"=\") !");
            }
            this.buffer[this.count++] = (byte)(this.group >> 16);
            if (this.pad <= 1) {
                this.buffer[this.count++] = (byte)(this.group >> 8);
                if (this.pad <= 0) {
                    this.buffer[this.count++] = (byte)this.group;
                }
            }
            this.group = 0;
            this.nbGroupedChars = 0;
        }
    }

    @Override
    public int available() throws IOException {
        this.ensureOpen();
        return this.count - this.pos + this.in.available() * 6 / 8;
    }

    @Override
    public int read() throws IOException {
        if (this.pos >= this.count) {
            this.ensureOpen();
            this.fill();
            if (this.pos >= this.count) {
                return -1;
            }
        }
        return this.buffer[this.pos++] & 0xFF;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.ensureOpen();
        if (b == null) {
            throw new NullPointerException("The given byte buffer is NULL !");
        }
        if (off < 0) {
            throw new ArrayIndexOutOfBoundsException("The offset parameter is negative (" + off + ") !");
        }
        if (off >= b.length) {
            throw new ArrayIndexOutOfBoundsException("The offset parameter (" + off + ") is greater than the buffer size (" + b.length + ") !");
        }
        if (len == 0) {
            return 0;
        }
        if (len < 0) {
            throw new ArrayIndexOutOfBoundsException("The length parameter is negative (" + len + ") !");
        }
        if (off + len > b.length) {
            throw new ArrayIndexOutOfBoundsException("Impossible to store " + len + " bytes in a byte array whose the size is " + b.length + " from the " + off + "-th item !");
        }
        int nbReadBytes = 0;
        while (nbReadBytes < len) {
            int avail;
            if (this.pos >= this.count) {
                this.fill();
            }
            if ((avail = this.count - this.pos) <= 0) {
                return nbReadBytes == 0 ? -1 : nbReadBytes;
            }
            int remLen = len - nbReadBytes;
            int cnt = remLen < avail ? remLen : avail;
            System.arraycopy(this.buffer, this.pos, b, off + nbReadBytes, cnt);
            nbReadBytes += cnt;
            this.pos += cnt;
        }
        return nbReadBytes;
    }

    @Override
    public long skip(long n) throws IOException {
        int nbRead;
        if (n < 0L) {
            throw new IllegalArgumentException("Number of bytes to skip < 0");
        }
        if (n == 0L) {
            return 0L;
        }
        long nbSkipped = 0L;
        long nbIteration = n / (long)this.buffer.length;
        byte[] skipped = new byte[this.buffer.length];
        for (long i = 0L; i < nbIteration; ++i) {
            nbRead = this.read(skipped);
            if (nbRead == -1) {
                return nbSkipped;
            }
            nbSkipped += (long)nbRead;
        }
        skipped = new byte[(int)(n % (long)this.buffer.length)];
        nbRead = this.read(skipped);
        if (nbRead > 0) {
            nbSkipped += (long)nbRead;
        }
        return nbSkipped;
    }

    @Override
    public void close() throws IOException {
        if (this.in == null) {
            return;
        }
        this.in.close();
        this.in = null;
        this.buffer = null;
        this.count = 0;
        this.pos = 0;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public synchronized void mark(int readlimit) {
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new IOException("Mark not supported in a Base64InputStream !");
    }
}

