/*
 * Decompiled with CFR 0.152.
 */
package cds.mocmulti;

import java.io.EOFException;
import java.io.RandomAccessFile;

public final class BufReader {
    private static final int MAX = 512;
    public byte[] buf = new byte[512];
    protected int offset = 0;
    protected int size = 0;
    private RandomAccessFile in;

    public BufReader(RandomAccessFile in) {
        this.in = in;
    }

    public String readString() throws Exception {
        short n = this.readShort();
        if (n == -1) {
            return null;
        }
        this.availability(n);
        String s = new String(this.buf, this.offset, (int)n);
        this.offset += n;
        return s;
    }

    public boolean readBoolean() throws Exception {
        this.availability(1);
        return this.buf[this.offset++] != 0;
    }

    public byte readByte() throws Exception {
        this.availability(1);
        return this.buf[this.offset++];
    }

    public short readShort() throws Exception {
        this.availability(2);
        return (short)(this.buf[this.offset++] & 0xFF | (this.buf[this.offset++] & 0xFF) << 8);
    }

    public int readInteger() throws Exception {
        this.availability(4);
        return this.buf[this.offset++] & 0xFF | (this.buf[this.offset++] & 0xFF) << 8 | (this.buf[this.offset++] & 0xFF) << 16 | (this.buf[this.offset++] & 0xFF) << 24;
    }

    public long readLong() throws Exception {
        this.availability(8);
        return (long)this.buf[this.offset++] & 0xFFL | ((long)this.buf[this.offset++] & 0xFFL) << 8 | ((long)this.buf[this.offset++] & 0xFFL) << 16 | ((long)this.buf[this.offset++] & 0xFFL) << 24 | ((long)this.buf[this.offset++] & 0xFFL) << 32 | ((long)this.buf[this.offset++] & 0xFFL) << 40 | ((long)this.buf[this.offset++] & 0xFFL) << 48 | ((long)this.buf[this.offset++] & 0xFFL) << 56;
    }

    private void availability(int n) throws Exception {
        if (this.offset + n < this.size) {
            return;
        }
        if (this.buf.length < this.offset + n) {
            int reste = this.size - this.offset;
            byte[] nbuf = new byte[n > 512 ? n : 512];
            if (reste > 0) {
                System.arraycopy(this.buf, this.offset, nbuf, 0, reste);
            }
            this.size = reste;
            this.offset = 0;
            this.buf = nbuf;
        }
        int manque = n - (this.size - this.offset);
        int place = this.buf.length - this.size;
        while (manque > 0) {
            int k = this.in.read(this.buf, this.size, place);
            if (k == -1) {
                throw new EOFException();
            }
            this.size += k;
            manque -= k;
            place -= k;
        }
    }
}

