/*
 * Decompiled with CFR 0.152.
 */
package cds.mocmulti;

import cds.aladin.MyProperties;
import cds.moc.Array;
import cds.moc.IntArray;
import cds.moc.LongArray;
import cds.moc.SMoc;
import cds.moc.ShortArray;
import cds.mocmulti.BufReader;
import cds.mocmulti.BufWriter;
import cds.mocmulti.MocItem;
import cds.mocmulti.MultiMoc;
import java.io.File;
import java.io.RandomAccessFile;

public final class BinaryDump {
    private static boolean debug = false;
    private static final byte[] BINVERSION = new byte[]{77, 67, 48, 56};

    public MultiMoc load(String path) throws Exception {
        long deb = System.currentTimeMillis();
        File f = new File(path);
        RandomAccessFile rf = new RandomAccessFile(f, "r");
        byte[] version = new byte[4];
        rf.readFully(version);
        String va = new String(version);
        String vb = new String(BINVERSION);
        if (!va.equals(vb)) {
            rf.close();
            throw new Exception("MultiMoc binary dump not compatible (found [" + va + "], required [" + vb + "]");
        }
        int taille = (int)rf.length() - 4;
        BufReader buf = new BufReader(rf);
        MultiMoc moc = this.parseDump(buf);
        rf.close();
        long fin = System.currentTimeMillis();
        long duree = fin - deb;
        if (debug) {
            System.out.println("MultiMoc binary dump read in " + (double)duree / 1000.0 + "s");
        }
        return moc;
    }

    public void save(MultiMoc mMoc, String path) throws Exception {
        long deb = System.currentTimeMillis();
        File f = new File(path);
        f.delete();
        RandomAccessFile rf = new RandomAccessFile(f, "rw");
        rf.write(BINVERSION);
        this.createDump(mMoc, rf);
        rf.close();
        long fin = System.currentTimeMillis();
        long duree = fin - deb;
        if (debug) {
            System.out.println("MultiMoc binary dump written in " + (double)duree / 1000.0 + "s");
        }
    }

    public MultiMoc parseDump(BufReader buf) throws Exception {
        MultiMoc mMoc = new MultiMoc();
        mMoc.clear();
        buf.readString();
        int nbMoc = buf.readInteger();
        for (int i = 0; i < nbMoc; ++i) {
            int j;
            long dateMoc = buf.readLong();
            String mocId = buf.readString();
            SMoc moc = new SMoc();
            int maxOrder = buf.readInteger();
            if (maxOrder == -1) {
                moc = null;
            } else {
                block6: for (int o = 0; o <= maxOrder; ++o) {
                    int size = buf.readInteger();
                    int type = SMoc.getType(o);
                    switch (type) {
                        case 0: {
                            short[] val = new short[size];
                            for (j = 0; j < size; ++j) {
                                val[j] = buf.readShort();
                            }
                            moc.setPixLevel(o, val);
                            continue block6;
                        }
                        case 1: {
                            int[] val1 = new int[size];
                            for (int j2 = 0; j2 < size; ++j2) {
                                val1[j2] = buf.readInteger();
                            }
                            moc.setPixLevel(o, val1);
                            continue block6;
                        }
                        case 2: {
                            long[] val2 = new long[size];
                            for (int j3 = 0; j3 < size; ++j3) {
                                val2[j3] = buf.readLong();
                            }
                            moc.setPixLevel(o, val2);
                        }
                    }
                }
            }
            long dateProp = buf.readLong();
            int n = buf.readInteger();
            MyProperties prop = n > 0 ? new MyProperties() : null;
            for (j = 0; j < n; ++j) {
                String key = buf.readString();
                String value = buf.readString();
                prop.put(key, value);
            }
            mMoc.add(mocId, moc, prop, dateMoc, dateProp);
        }
        return mMoc;
    }

    public void createDump(MultiMoc mMoc, RandomAccessFile rf) throws Exception {
        BufWriter buf = new BufWriter(rf);
        buf.memoString(mMoc.getCoordSys());
        buf.memoInteger(mMoc.size());
        for (MocItem mi : mMoc) {
            buf.memoLong(mi.dateMoc);
            SMoc moc = mi.moc;
            String mocId = mi.mocId;
            buf.memoString(mocId);
            if (moc == null) {
                buf.memoInteger(-1);
            } else {
                int maxOrder = moc.getMaxUsedOrder();
                buf.memoInteger(maxOrder);
                block6: for (int o = 0; o <= maxOrder; ++o) {
                    int size = moc.getSize(o);
                    buf.memoInteger(size);
                    Array a = moc.getArray(o);
                    int type = SMoc.getType(o);
                    switch (type) {
                        case 0: {
                            short[] val = ((ShortArray)a).seeArray();
                            for (int i = 0; i < size; ++i) {
                                buf.memoShort(val[i]);
                            }
                            continue block6;
                        }
                        case 1: {
                            int[] val1 = ((IntArray)a).seeArray();
                            for (int i = 0; i < size; ++i) {
                                buf.memoInteger(val1[i]);
                            }
                            continue block6;
                        }
                        case 2: {
                            long[] val2 = ((LongArray)a).seeArray();
                            for (int i = 0; i < size; ++i) {
                                buf.memoLong(val2[i]);
                            }
                            continue block6;
                        }
                    }
                }
            }
            buf.memoLong(mi.dateProp);
            MyProperties prop = mi.prop;
            if (prop == null) {
                buf.memoInteger(0);
            } else {
                int n = prop.size();
                buf.memoInteger(n);
                for (String key : prop.getKeys()) {
                    buf.memoString(key);
                    String val = prop.get(key);
                    buf.memoString(val);
                }
            }
            buf.flush();
        }
    }
}

