/*
 * Decompiled with CFR 0.152.
 */
package cds.moc;

import cds.aladin.Coord;
import cds.moc.Moc;
import cds.moc.MocIO;
import cds.moc.Range;
import cds.moc.SpaceMoc;
import java.io.OutputStream;
import java.util.InputMismatchException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class TimeMoc
extends SpaceMoc {
    public static final double DAYMICROSEC = 8.64E10;
    public static final double MAXDAY = 3.335999723978E12;
    private static long Y = 31557600000000L;
    private static long D = 86400000000L;
    private static long H = 3600000000L;
    private static long M = 60000000L;
    private static long S = 1000000L;
    private static long MS = 1000L;

    public TimeMoc() {
        this(-1);
    }

    public TimeMoc(int mocOrder) {
        this.init("JD", 0, mocOrder);
        this.spaceRange = new Range(1024);
    }

    public TimeMoc(Range range) throws Exception {
        super(range);
    }

    public void add(double jdmin, double jdmax) {
        long min = (long)(jdmin * 8.64E10);
        long max = (long)(jdmax * 8.64E10) + 1L;
        Range rtmp = new Range();
        rtmp.append(min, max);
        if (!rtmp.isEmpty()) {
            this.spaceRange = this.spaceRange.union(rtmp);
        }
    }

    @Override
    public Moc clone() {
        TimeMoc moc = new TimeMoc();
        return this.clone1(moc);
    }

    @Override
    public TimeMoc getTimeMoc() throws Exception {
        return this;
    }

    @Override
    public SpaceMoc getSpaceMoc() throws Exception {
        throw new Exception("No spatial dimension");
    }

    @Override
    public Moc union(Moc moc) throws Exception {
        return this.operation(moc.getTimeMoc(), 0);
    }

    @Override
    public Moc intersection(Moc moc) throws Exception {
        return this.operation(moc.getTimeMoc(), 1);
    }

    @Override
    public Moc subtraction(Moc moc) throws Exception {
        return this.operation(moc.getTimeMoc(), 2);
    }

    @Override
    public Moc difference(Moc moc) throws Exception {
        TimeMoc m = moc.getTimeMoc();
        Moc inter = this.intersection(m);
        Moc union = this.union(m);
        return union.subtraction(inter);
    }

    @Override
    public TimeMoc complement() throws Exception {
        TimeMoc allsky = new TimeMoc();
        allsky.add("0/0");
        allsky.toRangeSet();
        this.toRangeSet();
        TimeMoc res = new TimeMoc(this.maxLimitOrder);
        res.spaceRange = allsky.spaceRange.difference(this.spaceRange);
        res.toHealpixMoc();
        return res;
    }

    public boolean contains(double jd) {
        long npix = (long)(jd * 8.64E10);
        this.toRangeSet();
        return this.spaceRange.contains(npix);
    }

    @Override
    protected void testCompatibility(SpaceMoc moc) throws Exception {
        if (!(moc instanceof TimeMoc)) {
            throw new Exception("Incompatible => not a TMOC");
        }
    }

    public double getTimeMin() {
        if (this.isEmpty()) {
            return -1.0;
        }
        this.toRangeSet();
        return (double)this.spaceRange.begins(0) / 8.64E10;
    }

    public double getTimeMax() {
        if (this.isEmpty()) {
            return -1.0;
        }
        this.toRangeSet();
        return (double)this.spaceRange.ends(this.spaceRange.nranges() - 1) / 8.64E10;
    }

    public static double getTime(int order, long npix) {
        int shift = 2 * (29 - order);
        long t = npix << shift;
        return (double)t / 8.64E10;
    }

    public static long getDuration(int order) {
        int shift = 2 * (29 - order);
        return 1L << shift;
    }

    public Iterator<long[]> jdIterator(double jdStart, double jdStop) {
        if (jdStart > jdStop) {
            throw new InputMismatchException();
        }
        this.toRangeSet();
        return new JDIterator((long)(jdStart * 8.64E10), (long)(jdStop * 8.64E10));
    }

    @Override
    protected int writeSpecificFitsProp(OutputStream out) throws Exception {
        int n = 0;
        out.write(MocIO.getFitsLine("MOC", "TIME", "Temporal MOC"));
        n += 80;
        out.write(MocIO.getFitsLine("ORDERING", "NUNIQ", "NUNIQ coding method"));
        n += 80;
        out.write(MocIO.getFitsLine("MOCORDER", "" + this.getMocOrder(), "Time MOC resolution (best order)"));
        n += 80;
        out.write(MocIO.getFitsLine("TIMESYS", "JD", "Time ref system JD BARYCENTRIC TCB, 1 microsec order 29"));
        return n += 80;
    }

    public static void main(String[] argv) {
        try {
            System.out.println("  Order    Space res.   Time resolution");
            for (int i = 0; i <= 29; ++i) {
                String spaceRes = Coord.getUnit(Math.sqrt(SpaceMoc.getPixelArea(i)));
                String timeRes = TimeMoc.getTemps(TimeMoc.getDuration(i));
                System.out.printf("   %2d     %-10s %s\n", i, spaceRes, timeRes);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getTemps(long microsec) {
        return TimeMoc.getTemps(microsec, false);
    }

    public static String getTemps(long microsec, boolean flagRound) {
        StringBuilder s = new StringBuilder();
        if (microsec < MS) {
            s.append(microsec + "\u00b5s");
        } else if (microsec < S) {
            s.append((double)microsec / (double)MS + "ms");
        } else {
            long y = -1L;
            long j = -1L;
            long h = -1L;
            long m = -1L;
            if (microsec > Y) {
                y = microsec / Y;
                microsec -= y * Y;
                s.append(y + "y");
            }
            if (microsec > D) {
                j = microsec / D;
                microsec -= j * D;
                if (s.length() > 0) {
                    s.append(' ');
                }
                s.append(j + "d");
            }
            if (flagRound && y != -1L && y > 1L) {
                return s.toString();
            }
            if (microsec > H) {
                h = microsec / H;
                microsec -= h * H;
                if (s.length() > 0) {
                    s.append(' ');
                }
                s.append(h + "h");
            }
            if (flagRound && j != -1L && j > 1L) {
                return s.toString();
            }
            if (microsec > M) {
                m = microsec / M;
                microsec -= m * M;
                if (s.length() > 0) {
                    s.append(' ');
                }
                s.append(m + "m");
            }
            if (flagRound && h != -1L && h > 1L) {
                return s.toString();
            }
            if (microsec > 0L) {
                if (s.length() > 0) {
                    s.append(' ');
                }
                s.append((double)microsec / (double)S + "s");
            }
        }
        return s.toString();
    }

    class JDIterator
    implements Iterator<long[]> {
        int pos;
        int endpos;

        JDIterator(long start, long end) {
            this.pos = TimeMoc.this.spaceRange.indexOf(start) / 2;
            if (this.pos < 0) {
                this.pos = 0;
            }
            this.endpos = TimeMoc.this.spaceRange.indexOf(end) / 2 + 1;
        }

        @Override
        public boolean hasNext() {
            return this.pos < this.endpos;
        }

        @Override
        public long[] next() {
            if (this.pos > this.endpos) {
                throw new NoSuchElementException();
            }
            long[] ret = new long[]{TimeMoc.this.spaceRange.begins(this.pos), TimeMoc.this.spaceRange.ends(this.pos)};
            ++this.pos;
            return ret;
        }

        @Override
        public void remove() {
        }
    }
}

