/*
 * Decompiled with CFR 0.152.
 */
package cds.moc;

import cds.aladin.Coord;
import cds.moc.Moc;
import cds.moc.MocIO;
import cds.moc.Range;
import cds.moc.SMoc;
import java.io.OutputStream;
import java.util.InputMismatchException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class TMoc
extends SMoc {
    public static final double DAYMICROSEC = 8.64E10;
    public static final double MAXDAY = 3.335999723978E12;
    private static long Y = 31557600000000L;
    private static long D = 86400000000L;
    private static long H = 3600000000L;
    private static long M = 60000000L;
    private static long S = 1000000L;
    private static long MS = 1000L;

    public TMoc() {
        this(-1);
    }

    public TMoc(int mocOrder) {
        this.init("JD", 0, mocOrder);
        this.range = new Range(1024);
    }

    public TMoc(String s) throws Exception {
        this();
        this.add(s);
    }

    public TMoc(Range range) throws Exception {
        super(range);
    }

    @Override
    protected void initPropSys(String sys) {
        this.property.put("TIMESYS", sys);
    }

    public void add(double jdmin, double jdmax) {
        long min = (long)(jdmin * 8.64E10);
        long max = (long)(jdmax * 8.64E10) + 1L;
        Range rtmp = new Range();
        rtmp.append(min, max);
        if (!rtmp.isEmpty()) {
            this.range = this.range.union(rtmp);
        }
    }

    @Override
    public Moc clone() {
        TMoc moc = new TMoc();
        return this.clone1(moc);
    }

    @Override
    public TMoc getTimeMoc() throws Exception {
        return this;
    }

    @Override
    public SMoc getSpaceMoc() throws Exception {
        throw new Exception("No spatial dimension");
    }

    @Override
    public int getSpaceOrder() {
        return -1;
    }

    @Override
    public int getTimeOrder() {
        return this.getMocOrder();
    }

    @Override
    public void setSpaceOrder(int order) throws Exception {
        throw new Exception("No spatial dimension");
    }

    @Override
    public void setTimeOrder(int order) throws Exception {
        this.setMocOrder(order);
    }

    @Override
    public boolean isSpace() {
        return false;
    }

    @Override
    public boolean isTime() {
        return true;
    }

    @Override
    public Moc union(Moc moc) throws Exception {
        return this.operation(moc.getTimeMoc(), 0);
    }

    @Override
    public Moc intersection(Moc moc) throws Exception {
        return this.operation(moc.getTimeMoc(), 1);
    }

    @Override
    public Moc subtraction(Moc moc) throws Exception {
        return this.operation(moc.getTimeMoc(), 2);
    }

    @Override
    public Moc difference(Moc moc) throws Exception {
        TMoc m = moc.getTimeMoc();
        Moc inter = this.intersection(m);
        Moc union = this.union(m);
        return union.subtraction(inter);
    }

    @Override
    public TMoc complement() throws Exception {
        TMoc allsky = new TMoc();
        allsky.add("0/0");
        allsky.toRangeSet();
        this.toRangeSet();
        TMoc res = new TMoc(this.mocOrder);
        res.range = allsky.range.difference(this.range);
        res.toMocSet();
        return res;
    }

    @Override
    public void accretion() throws Exception {
        this.accretion(this.getTimeOrder());
    }

    @Override
    public void accretion(int order) throws Exception {
        this.toRangeSet();
        Range r = new Range(this.range.sz);
        int shift = (29 - order) * 2;
        long add = 1L << shift;
        for (int i = 0; i < this.range.sz; i += 2) {
            long a = this.range.r[i] - add;
            long b = this.range.r[i + 1] + add;
            r.add(a, b);
        }
        this.range = r;
        this.toMocSet();
    }

    public boolean contains(double jd) {
        long npix = (long)(jd * 8.64E10);
        this.toRangeSet();
        return this.range.contains(npix);
    }

    @Override
    protected void testCompatibility(SMoc moc) throws Exception {
        if (!(moc instanceof TMoc)) {
            throw new Exception("Incompatible => not a TMOC");
        }
    }

    public double getTimeMin() {
        if (this.isEmpty()) {
            return -1.0;
        }
        this.toRangeSet();
        return (double)this.range.begins(0) / 8.64E10;
    }

    public double getTimeMax() {
        if (this.isEmpty()) {
            return -1.0;
        }
        this.toRangeSet();
        return (double)this.range.ends(this.range.nranges() - 1) / 8.64E10;
    }

    public static double getTime(int order, long npix) {
        int shift = 2 * (29 - order);
        long t = npix << shift;
        return (double)t / 8.64E10;
    }

    public static long getDuration(int order) {
        int shift = 2 * (29 - order);
        return 1L << shift;
    }

    public Iterator<long[]> jdIterator(double jdStart, double jdStop) {
        if (jdStart > jdStop) {
            throw new InputMismatchException();
        }
        this.toRangeSet();
        return new JDIterator((long)(jdStart * 8.64E10), (long)(jdStop * 8.64E10));
    }

    @Override
    protected int writeSpecificFitsProp(OutputStream out) throws Exception {
        int n = 0;
        out.write(MocIO.getFitsLine("MOC", "TIME", "Temporal MOC"));
        n += 80;
        out.write(MocIO.getFitsLine("ORDERING", "NUNIQ", "NUNIQ coding method"));
        n += 80;
        out.write(MocIO.getFitsLine("MOCORDER", "" + this.getMocOrder(), "Time MOC resolution (best order)"));
        n += 80;
        out.write(MocIO.getFitsLine("TIMESYS", "JD", "Time ref system JD BARYCENTRIC TCB, 1 microsec order 29"));
        return n += 80;
    }

    public static void main(String[] argv) {
        try {
            System.out.println("  Order    Space res.   Time resolution");
            for (int i = 0; i <= 29; ++i) {
                String spaceRes = Coord.getUnit(Math.sqrt(SMoc.getPixelArea(i)));
                String timeRes = TMoc.getTemps(TMoc.getDuration(i));
                System.out.printf("   %2d     %-10s %s\n", i, spaceRes, timeRes);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getTemps(long microsec) {
        return TMoc.getTemps(microsec, false);
    }

    public static String getTemps(long microsec, boolean flagRound) {
        StringBuilder s = new StringBuilder();
        if (microsec < MS) {
            s.append(microsec + "\u00b5s");
        } else if (microsec < S) {
            s.append((double)microsec / (double)MS + "ms");
        } else {
            long y = -1L;
            long j = -1L;
            long h = -1L;
            long m = -1L;
            if (microsec > Y) {
                y = microsec / Y;
                microsec -= y * Y;
                s.append(y + "y");
            }
            if (microsec > D) {
                j = microsec / D;
                microsec -= j * D;
                if (s.length() > 0) {
                    s.append(' ');
                }
                s.append(j + "d");
            }
            if (flagRound && y != -1L && y > 1L) {
                return s.toString();
            }
            if (microsec > H) {
                h = microsec / H;
                microsec -= h * H;
                if (s.length() > 0) {
                    s.append(' ');
                }
                s.append(h + "h");
            }
            if (flagRound && j != -1L && j > 1L) {
                return s.toString();
            }
            if (microsec > M) {
                m = microsec / M;
                microsec -= m * M;
                if (s.length() > 0) {
                    s.append(' ');
                }
                s.append(m + "m");
            }
            if (flagRound && h != -1L && h > 1L) {
                return s.toString();
            }
            if (microsec > 0L) {
                if (s.length() > 0) {
                    s.append(' ');
                }
                s.append((double)microsec / (double)S + "s");
            }
        }
        return s.toString();
    }

    class JDIterator
    implements Iterator<long[]> {
        int pos;
        int endpos;

        JDIterator(long start, long end) {
            this.pos = TMoc.this.range.indexOf(start) / 2;
            if (this.pos < 0) {
                this.pos = 0;
            }
            this.endpos = TMoc.this.range.indexOf(end) / 2 + 1;
        }

        @Override
        public boolean hasNext() {
            return this.pos < this.endpos;
        }

        @Override
        public long[] next() {
            if (this.pos > this.endpos) {
                throw new NoSuchElementException();
            }
            long[] ret = new long[]{TMoc.this.range.begins(this.pos), TMoc.this.range.ends(this.pos)};
            ++this.pos;
            return ret;
        }

        @Override
        public void remove() {
        }
    }
}

