/*
 * Decompiled with CFR 0.152.
 */
package cds.moc;

import cds.moc.Array;
import cds.moc.HealpixMoc;
import cds.moc.Moc;
import cds.moc.MocCell;
import cds.moc.MocIO;
import cds.moc.Range;
import cds.moc.Range2;
import cds.moc.SpaceMoc;
import cds.moc.TimeMoc;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;

public class SpaceTimeMoc
extends Moc {
    public Range2 timeRange;
    private int timeOrder = -1;
    private int spaceOrder = -1;
    private StringBuilder buf = null;
    private HealpixMoc tmoc = null;
    private static final String[][] TEST = new String[][]{{"Ajout \u00e0 vide", "", "t5-10s2", "t5-10s2", ""}, {"Ajout singleton derri\u00e8re singleton", "t4s1", "t5s2", "t4s1 t5s2", ""}, {"Ajout singleton avant singleton", "t5s2", "t4s1", "t4s1 t5s2", ""}, {"Ajout intervalle entrelac\u00e9s apr\u00e8s", "t4-6s1", "t5-8s2", "t4s1 t5-6s1-2 t7-8s2", ""}, {"Ajout intervalle entrelac\u00e9s avant", "t5-8s2", "t4-6s1", "t4s1 t5-6s1-2 t7-8s2", ""}, {"Ajout intervalle englobant (s diff\u00e9rents)", "t2-6s2", "t1-8s1", "t1s1 t2-6s1-2 t7-8s1", ""}, {"Ajout intervalle englobant (s identiques)", "t2-6s2", "t1-8s2", "t1-8s2", "t2-6s2"}, {"Ajout intervalle interne (s diff\u00e9rents)", "t1-8s1", "t2-6s2", "t1s1 t2-6s1-2 t7-8s1", ""}, {"Ajout intervalle interne (s identiques)", "t1-8s2", "t2-6s2", "t1-8s2", "t2-6s2"}, {"Intercallage", "t6-7 11s1", "t9s2", "t6-7s1 t9s2 t11s1", ""}, {"Fusion diff\u00e9rents s", "t2-6 8-9s2", "t7s1", "t2-6s2 t7s1 t8-9s2", ""}, {"Fusion indentiques s", "t2-6 8-9s2", "t7s2", "t2-9s2", ""}, {"Remplacement sur d\u00e9but", "t2-6s2 t7s1", "t2-7s2", "t2-6s2 t7s1-2", "t2-6s2"}, {"Remplacement sur fin", "t3-7s2 t8s1", "t2-7s2", "t2-7s2 t8s1", "t3-7s2"}, {"Remplacement sur fin2", "t2-4s2 t6s1", "t6s2", "t2-4s2 t6s1-2", ""}, {"Tordu", "t3s1 t4-5s2", "t3-5s3", "t3s1,3 t4-5s2-3", ""}, {"Inter simple", "t3-5s1-3", "t4-8s2-4", "t3s1-3 t4-5s1-4 t6-8s2-4", "t4-5s2-3"}, {"Inter sp\u00e9cial", "t1s1-6 t3-9s2", "t3s5-7 t8s1-2", "t1s1-6 t3s2,5-7 t4-7s2 t8s1-2 t9s2", "t8s2"}, {"Ajout en suite", "t1-4s1", "t5-6s1", "t1-6s1", ""}};

    public SpaceTimeMoc() {
        this.init();
        this.timeRange = new Range2();
    }

    public SpaceTimeMoc(int spaceOrder, int timeOrder) {
        this();
        this.timeOrder = timeOrder;
        this.spaceOrder = spaceOrder;
    }

    public SpaceTimeMoc(int spaceOrder, int timeOrder, Range2 rangeSet) {
        this.init();
        this.spaceOrder = spaceOrder;
        this.timeOrder = timeOrder;
        this.timeRange = new Range2(rangeSet);
    }

    public SpaceTimeMoc(String s) throws Exception {
        this();
        if (s != null && s.length() > 0) {
            this.append(s);
        }
    }

    private void init() {
        this.property = new HashMap();
        this.property.put("MOCTOOL", "CDSjavaAPI-6.0");
        this.property.put("DATE", String.format("%tFT%<tR", new Date()));
    }

    public boolean contains(long npix, double jd) {
        long npixTime = (long)(jd * 8.64E10);
        if (!this.timeRange.contains(npixTime)) {
            return false;
        }
        for (Range range : this.timeRange.rangeArray) {
            if (!range.contains(npix)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        this.timeRange.clear();
    }

    @Override
    public void setTimeOrder(int order) throws Exception {
        this.timeOrder = order;
    }

    @Override
    public int getTimeOrder() {
        return this.timeOrder;
    }

    @Override
    public void setSpaceOrder(int order) throws Exception {
        this.spaceOrder = order;
    }

    @Override
    public int getSpaceOrder() {
        return this.spaceOrder;
    }

    @Override
    public void setMocOrder(int order) throws Exception {
        this.setSpaceOrder(order);
    }

    @Override
    public int getMocOrder() {
        return this.getSpaceOrder();
    }

    @Override
    public long getMem() {
        return this.timeRange.getMem() + 20L;
    }

    @Override
    public int getSize() {
        int size = this.timeRange.sz;
        for (int i = 0; i < this.timeRange.sz / 2; ++i) {
            size += this.timeRange.rangeArray[i].sz;
        }
        return size;
    }

    public int getTimeRanges() {
        return this.timeRange.nranges();
    }

    @Override
    public void add(String s) throws Exception {
    }

    @Override
    public void add(Moc moc) throws Exception {
    }

    @Override
    public void check() throws Exception {
    }

    @Override
    public void setProperty(String key, String value) throws Exception {
    }

    @Override
    public boolean isIntersecting(Moc moc) {
        return false;
    }

    @Override
    public Moc union(Moc moc) throws Exception {
        return new SpaceTimeMoc(this.spaceOrder, this.timeOrder, this.timeRange.union(((SpaceTimeMoc)moc).timeRange));
    }

    @Override
    public Moc intersection(Moc moc) throws Exception {
        return new SpaceTimeMoc(this.spaceOrder, this.timeOrder, this.timeRange.intersection(((SpaceTimeMoc)moc).timeRange));
    }

    @Override
    public Moc subtraction(Moc moc) throws Exception {
        return new SpaceTimeMoc(this.spaceOrder, this.timeOrder, this.timeRange.difference(((SpaceTimeMoc)moc).timeRange));
    }

    @Override
    public boolean isEmpty() {
        return this.timeRange.isEmpty();
    }

    @Override
    public void trim() {
    }

    @Override
    public Iterator<MocCell> iterator() {
        return null;
    }

    public int getSize(int order) {
        return 0;
    }

    public Array getArray(int order) {
        return null;
    }

    @Override
    public void setCurrentOrder(int order) {
    }

    public void setCoordSys(String s) {
        System.err.println("Not yet implemented");
    }

    public long getVal(long val, int order) {
        if (order == 29) {
            return val;
        }
        int deltaOrder = 29 - order << 1;
        val = val >>> deltaOrder << deltaOrder;
        return val;
    }

    public void add(long tmin, long tmax, long smin, long smax) {
        tmin = this.getVal(tmin, this.timeOrder);
        if ((tmax = this.getVal(tmax, this.timeOrder)) == tmin) {
            ++tmax;
        }
        smin = this.getVal(smin, this.spaceOrder);
        if ((smax = this.getVal(smax, this.spaceOrder)) == smin) {
            ++smax;
        }
        Range r = new Range();
        r.append(smin, smax);
        this.timeRange.add(tmin, tmax, r);
    }

    public void sortAndFix() {
        this.timeRange.sortAndFix();
    }

    public boolean add(int order, long npix) throws Exception {
        return false;
    }

    public int getMaxOrder() {
        return this.getSpaceOrder();
    }

    public String getCoordSys() {
        return null;
    }

    @Override
    public void setCheckConsistencyFlag(boolean flag) throws Exception {
    }

    public void toHealpixMoc() throws Exception {
    }

    @Override
    public void addHpix(String s) throws Exception {
        if (s == null || s.charAt(0) == 't') {
            if (this.tmoc != null) {
                HealpixMoc moc = new HealpixMoc(this.buf.toString());
                moc.toRangeSet();
                if (moc.getMocOrder() > this.spaceOrder) {
                    this.spaceOrder = moc.getMocOrder();
                }
                for (int i = 0; i < this.tmoc.spaceRange.sz; i += 2) {
                    this.timeRange.append(this.tmoc.spaceRange.r[i], this.tmoc.spaceRange.r[i + 1], moc.spaceRange);
                }
                this.tmoc = null;
                this.buf = null;
            }
            if (s != null) {
                this.buf = new StringBuilder(s.substring(1));
            }
        } else if (s.charAt(0) == 's') {
            this.tmoc = new HealpixMoc(this.buf.toString());
            this.tmoc.toRangeSet();
            if (this.tmoc.getMocOrder() > this.timeOrder) {
                this.timeOrder = this.tmoc.getMocOrder();
            }
            this.buf = new StringBuilder(s.substring(1));
        } else {
            this.buf.append(' ');
            this.buf.append(s);
        }
    }

    public void append(String s1) throws Exception {
        if (s1.charAt(0) != 't') {
            throw new Exception("Invalid STMOC syntax (expecting 't')");
        }
        StringTokenizer tok = new StringTokenizer(s1, "t");
        while (tok.hasMoreTokens()) {
            String s = "t" + tok.nextToken();
            int e = s.indexOf(115);
            HealpixMoc moc = null;
            HealpixMoc tmoc = null;
            if (e > 0) {
                int se = s.indexOf(47, e);
                moc = new HealpixMoc((se < 0 ? "29/" : "") + s.substring(e + 1));
                moc.toRangeSet();
            } else {
                e = s.length();
            }
            int st = s.lastIndexOf(47, e - 1);
            tmoc = new HealpixMoc((st < 0 ? "29/" : "") + s.substring(1, e));
            tmoc.toRangeSet();
            for (int i = 0; i < tmoc.spaceRange.sz; i += 2) {
                this.timeRange.append(tmoc.spaceRange.r[i], tmoc.spaceRange.r[i + 1], moc.spaceRange);
            }
        }
    }

    @Override
    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean flagNL) {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < this.timeRange.sz; i += 2) {
            Range m;
            long a = this.timeRange.r[i];
            long b = this.timeRange.r[i + 1];
            s.append("t" + a);
            if (b - 1L != a) {
                s.append("-" + (b - 1L));
            }
            if ((m = this.timeRange.rangeArray[i >>> 1]) != null && !m.isEmpty()) {
                s.append(flagNL ? " s" : "s");
                if (flagNL) {
                    try {
                        HealpixMoc moc = new HealpixMoc(m);
                        s.append(moc.toASCII());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    for (int j = 0; j < m.sz; j += 2) {
                        s.append(m.r[j]);
                        if (m.r[j + 1] - 1L != m.r[j]) {
                            s.append("-" + (m.r[j + 1] - 1L));
                        }
                        if (j >= m.sz - 2) continue;
                        s.append(',');
                    }
                }
            }
            if (i >= this.timeRange.sz - 2) continue;
            s.append(flagNL ? (char)'\n' : ' ');
        }
        return s.toString();
    }

    public String toString2() {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < this.timeRange.sz; i += 2) {
            Range m;
            s.append("t" + this.timeRange.r[i]);
            if (this.timeRange.r[i + 1] - 1L != this.timeRange.r[i]) {
                s.append("-" + (this.timeRange.r[i + 1] - 1L));
            }
            if ((m = this.timeRange.rangeArray[i >>> 1]) != null && !m.isEmpty()) {
                s.append(" s");
                try {
                    HealpixMoc moc = new HealpixMoc(m);
                    s.append(moc.toASCII());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (i >= this.timeRange.sz - 2) continue;
            s.append('\n');
        }
        return s.toString();
    }

    public String toString3() {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < this.timeRange.sz; i += 2) {
            HealpixMoc moc;
            s.append("t");
            try {
                moc = new HealpixMoc((Range)this.timeRange);
                s.append(moc.toASCII());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Range m = this.timeRange.rangeArray[i >>> 1];
            if (m != null && !m.isEmpty()) {
                s.append(" s");
                try {
                    moc = new HealpixMoc(m);
                    s.append(moc.toASCII());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (i >= this.timeRange.sz - 2) continue;
            s.append('\n');
        }
        return s.toString();
    }

    static final void test() throws Exception {
        SpaceTimeMoc.test(-1);
    }

    static final void test(int x) throws Exception {
        String[][] stringArray;
        if (x == -1) {
            stringArray = TEST;
        } else {
            String[][] stringArrayArray = new String[1][];
            stringArray = stringArrayArray;
            stringArrayArray[0] = TEST[x];
        }
        String[][] listTest = stringArray;
        StringBuilder s = new StringBuilder();
        int i = x == -1 ? 0 : x;
        for (String[] test : listTest) {
            SpaceTimeMoc stmoc1 = new SpaceTimeMoc(test[1]);
            SpaceTimeMoc stmoc2 = new SpaceTimeMoc(test[2]);
            s.append("\n" + i++ + ") " + test[0] + ":");
            s.append("\n A: " + stmoc1 + "\n B: " + stmoc2);
            SpaceTimeMoc stmoc4 = (SpaceTimeMoc)stmoc1.intersection(stmoc2);
            s.append("\n Inter: " + stmoc4);
            s.append(test[4].equals(stmoc4.toString()) ? " => OK" : " => ERROR waiting: " + test[4]);
            SpaceTimeMoc stmoc3 = (SpaceTimeMoc)stmoc1.union(stmoc2);
            s.append("\n Union: " + stmoc3);
            s.append(test[3].equals(stmoc3.toString()) ? " => OK" : " => ERROR waiting: " + test[3]);
            for (int j = 0; j < stmoc2.timeRange.sz; j += 2) {
                stmoc1.timeRange.add(stmoc2.timeRange.r[j], stmoc2.timeRange.r[j + 1], stmoc2.timeRange.rangeArray[j / 2]);
            }
            s.append("\n Add  : " + stmoc1);
            s.append(test[3].equals(stmoc1.toString()) ? " => OK" : " => ERROR waiting: " + test[3]);
            s.append("\n");
        }
        System.out.println(s);
    }

    @Override
    protected int writeSpecificFitsProp(OutputStream out) throws Exception {
        int n = 0;
        out.write(MocIO.getFitsLine("MOC", "TIME.SPACE", "STMOC: Time dimension first, "));
        n += 80;
        out.write(MocIO.getFitsLine("ORDERING", "RANGE29", "Range coding"));
        n += 80;
        out.write(MocIO.getFitsLine("MOCORDER", "" + this.getTimeOrder(), "Time MOC resolution"));
        n += 80;
        out.write(MocIO.getFitsLine("MOCORD_1", "" + this.getMocOrder(), "Space MOC resolution"));
        n += 80;
        out.write(MocIO.getFitsLine("COORDSYS", "C", "Space reference frame (C=ICRS)"));
        n += 80;
        out.write(MocIO.getFitsLine("TIMESYS", "JD", "Time ref system JD BARYCENTRIC TCB, 1 microsec order 29"));
        return n += 80;
    }

    @Override
    protected int writeSpecificData(OutputStream out) throws Exception {
        byte[] buf = new byte[8];
        int size = 0;
        for (int i = 0; i < this.timeRange.sz; i += 2) {
            long tmin = -this.timeRange.r[i];
            size += MocIO.writeVal(out, tmin, buf);
            long tmax = -this.timeRange.r[i + 1];
            size += MocIO.writeVal(out, tmax, buf);
            Range m = this.timeRange.rangeArray[i >>> 1];
            for (int j = 0; j < m.sz; j += 2) {
                long smin = m.r[j];
                size += MocIO.writeVal(out, smin, buf);
                long smax = m.r[j + 1];
                size += MocIO.writeVal(out, smax, buf);
            }
        }
        return size;
    }

    @Override
    protected void readSpecificData(InputStream in, int naxis1, int naxis2, int nbyte, MocIO.HeaderFits header) throws Exception {
        String type = header.getStringFromHeader("MOC");
        if (type == null || type.equals("SPACETIME")) {
            this.timeOrder = header.getIntFromHeader("TORDER");
            this.spaceOrder = header.getIntFromHeader("MOCORDER");
        } else {
            this.timeOrder = header.getIntFromHeader("MOCORDER");
            this.spaceOrder = header.getIntFromHeader("MOCORD_1");
        }
        byte[] buf = new byte[naxis1 * naxis2];
        MocIO.readFully(in, buf);
        this.createMocByFits(naxis1 * naxis2 / nbyte, buf);
    }

    protected long readLong(byte[] t, int i) {
        int a = t[i] << 24 | (t[i + 1] & 0xFF) << 16 | (t[i + 2] & 0xFF) << 8 | t[i + 3] & 0xFF;
        int b = t[i + 4] << 24 | (t[i + 5] & 0xFF) << 16 | (t[i + 6] & 0xFF) << 8 | t[i + 7] & 0xFF;
        long val = (long)a << 32 | (long)b & 0xFFFFFFFFL;
        return val;
    }

    protected void createMocByFits(int nval, byte[] t) throws Exception {
        int i = 0;
        int startT = 0;
        Range m = new Range(100000);
        int k = 0;
        while (k < nval) {
            long min = this.readLong(t, i);
            long max = this.readLong(t, i + 8);
            if (min < 0L) {
                if (!m.isEmpty()) {
                    for (int j = startT; j < this.timeRange.sz; j += 2) {
                        this.timeRange.rangeArray[j >>> 1] = new Range(m);
                    }
                    m.clear();
                    startT = this.timeRange.sz;
                }
                this.timeRange.append(-min, -max, null);
            } else {
                m.append(min, max);
            }
            k += 2;
            i += 16;
        }
        if (!m.isEmpty()) {
            for (int j = startT; j < this.timeRange.sz; j += 2) {
                this.timeRange.rangeArray[j >>> 1] = m;
            }
        }
    }

    @Override
    protected int getType() {
        return 2;
    }

    public double getTimeMin() {
        if (this.isEmpty()) {
            return -1.0;
        }
        return (double)this.timeRange.begins(0) / 8.64E10;
    }

    public double getTimeMax() {
        if (this.isEmpty()) {
            return -1.0;
        }
        return (double)this.timeRange.ends(this.timeRange.nranges() - 1) / 8.64E10;
    }

    public TimeMoc getTimeMoc() throws Exception {
        TimeMoc moc = new TimeMoc();
        moc.spaceRange = this.timeRange;
        moc.toHealpixMoc();
        return moc;
    }

    public TimeMoc getTimeMoc(SpaceMoc spaceMoc) throws Exception {
        if (spaceMoc == null || spaceMoc.isEmpty()) {
            return this.getTimeMoc();
        }
        TimeMoc moc = new TimeMoc();
        Range range = new Range();
        spaceMoc.toRangeSet();
        for (int i = 0; i < this.timeRange.sz; i += 2) {
            Range m = this.timeRange.rangeArray[i >>> 1];
            if (!spaceMoc.spaceRange.overlaps(m)) continue;
            range.append(this.timeRange.r[i], this.timeRange.r[i + 1]);
        }
        moc.spaceRange = range;
        moc.toHealpixMoc();
        return moc;
    }

    public SpaceMoc getSpaceMoc() throws Exception {
        return this.getSpaceMoc(-1L, Long.MAX_VALUE);
    }

    public SpaceMoc getSpaceMoc(long tmin, long tmax) throws Exception {
        if (tmin >= tmax) {
            tmin = -1L;
            tmax = Long.MAX_VALUE;
        }
        SpaceMoc moc = new SpaceMoc();
        int pos = this.timeRange.indexOf(tmin);
        if ((pos & 1) == 1) {
            ++pos;
        }
        long[] buf = new long[this.getSize()];
        int size = 0;
        for (int i = pos; i < this.timeRange.sz && this.timeRange.r[i] <= tmax; i += 2) {
            Range m = this.timeRange.rangeArray[i >>> 1];
            for (int j = 0; j < m.sz; ++j) {
                buf[size++] = m.r[j];
            }
        }
        Range range = new Range(buf, size);
        range.sortAndFix();
        moc.spaceRange = range;
        moc.toHealpixMoc();
        return moc;
    }

    public static void main(String[] a) {
        try {
            SpaceTimeMoc moc = new SpaceTimeMoc();
            moc.read("C:/Users/Pierre/Downloads/Moc.txt");
            System.out.println(moc.toASCII());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public Moc clone() {
        SpaceTimeMoc moc = new SpaceTimeMoc();
        moc.timeOrder = this.timeOrder;
        moc.spaceOrder = this.spaceOrder;
        moc.timeRange = new Range2(this.timeRange);
        return moc;
    }
}

