/*
 * Decompiled with CFR 0.152.
 */
package cds.moc;

import cds.aladin.Coord;
import cds.aladin.Localisation;
import cds.moc.Array;
import cds.moc.Healpix;
import cds.moc.HealpixImpl;
import cds.moc.IntArray;
import cds.moc.LongArray;
import cds.moc.Moc;
import cds.moc.MocCell;
import cds.moc.MocIO;
import cds.moc.Range;
import cds.moc.ShortArray;
import cds.moc.TimeMoc;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;

public class SpaceMoc
extends Moc {
    public static final int SHORT = 0;
    public static final int INT = 1;
    public static final int LONG = 2;
    private static final int MAXADDS = 500000;
    protected String coordSys;
    protected int minLimitOrder;
    protected int maxLimitOrder;
    protected Array[] level;
    private int nOrder;
    private boolean testConsistency;
    private boolean isConsistant;
    private int currentOrder = -1;
    public Range spaceRange = null;
    private static final int MAXWORD = 20;
    private static final int MAXSIZE = 80;
    private static final double SKYAREA = Math.PI * 4 * Math.toDegrees(1.0) * Math.toDegrees(1.0);

    public static int getType(int order) {
        return order < 6 ? 0 : (order < 14 ? 1 : 2);
    }

    public SpaceMoc() {
        this.init("C", 0, -1);
    }

    public SpaceMoc(int maxLimitOrder) throws Exception {
        this.init("C", 0, maxLimitOrder);
    }

    public SpaceMoc(int minLimitOrder, int maxLimitOrder) throws Exception {
        this.init("C", minLimitOrder, maxLimitOrder);
    }

    public SpaceMoc(String coordSys, int minLimitOrder, int maxLimitOrder) throws Exception {
        this.init(coordSys, minLimitOrder, maxLimitOrder);
    }

    public SpaceMoc(Range r) throws Exception {
        this();
        this.spaceRange = r;
        this.toHealpixMoc();
    }

    public SpaceMoc(String s) throws Exception {
        this();
        this.add(s);
    }

    public SpaceMoc(InputStream in) throws Exception {
        this.read(in);
    }

    public SpaceMoc(InputStream in, int mode) throws Exception {
        this();
        this.read(in, mode);
    }

    @Override
    public void clear() {
        this.init(this.coordSys, this.minLimitOrder, this.maxLimitOrder);
    }

    @Override
    public Moc clone() {
        SpaceMoc moc = new SpaceMoc();
        return this.clone1(moc);
    }

    protected Moc clone1(SpaceMoc moc) {
        moc.coordSys = this.coordSys;
        moc.maxLimitOrder = this.maxLimitOrder;
        moc.minLimitOrder = this.minLimitOrder;
        moc.nOrder = this.nOrder;
        moc.testConsistency = this.testConsistency;
        moc.currentOrder = this.currentOrder;
        moc.spaceRange = this.spaceRange == null ? null : new Range(this.spaceRange);
        for (int order = 0; order < this.nOrder; ++order) {
            moc.level[order] = (Array)this.level[order].clone();
        }
        moc.property = (HashMap)this.property.clone();
        return moc;
    }

    public void setMinLimitOrder(int limitOrder) throws Exception {
        if (limitOrder == this.minLimitOrder) {
            return;
        }
        if (limitOrder > 29) {
            throw new Exception("Min limit order exceed HEALPix library possibility (29)");
        }
        if (limitOrder < 0 || this.maxLimitOrder != -1 && limitOrder > this.maxLimitOrder) {
            throw new Exception("Min limit greater than max limit order");
        }
        this.isConsistant = false;
        this.minLimitOrder = limitOrder;
        this.setCheckConsistencyFlag(true);
    }

    @Override
    public void setMocOrder(int order) throws Exception {
        this.setMaxLimitOrder(order);
    }

    public void setMaxLimitOrder(int limitOrder) throws Exception {
        if (limitOrder == this.maxLimitOrder) {
            return;
        }
        if (limitOrder > 29) {
            throw new Exception("Max limit order exceed HEALPix library possibility (29)");
        }
        if (limitOrder != -1 && limitOrder < this.minLimitOrder) {
            throw new Exception("Max limit order smaller than min limit order");
        }
        this.property.put("MOCORDER", "" + (limitOrder == -1 ? 29 : limitOrder));
        this.maxLimitOrder = limitOrder;
        this.isConsistant = false;
        if (this.getSize() > 0) {
            this.checkAndFix();
        }
        if (limitOrder != -1) {
            this.nOrder = limitOrder + 1;
        }
    }

    public int getMinLimitOrder() {
        return this.minLimitOrder;
    }

    public int getMaxLimitOrder() {
        return this.maxLimitOrder >= 0 ? this.maxLimitOrder : (this.currentOrder >= 0 ? this.currentOrder : this.nOrder - 1);
    }

    @Override
    public int getMocOrder() {
        return this.getMaxLimitOrder();
    }

    public void setMocOrder(String mocOrder) throws Exception {
        int n = Integer.parseInt(mocOrder);
        if (n == 29) {
            n = -1;
        }
        this.setMaxLimitOrder(n);
    }

    public int getLimitOrder() {
        return this.getMaxLimitOrder();
    }

    public void setLimitOrder(int limitOrder) throws Exception {
        this.setMaxLimitOrder(limitOrder);
    }

    public String getCoordSys() {
        return this.coordSys;
    }

    public void setCoordSys(String coordSys) {
        this.coordSys = coordSys;
        this.property.put("COORDSYS", coordSys);
    }

    @Override
    public void setCurrentOrder(int order) {
        this.currentOrder = order;
    }

    @Override
    public int getSize() {
        int size = 0;
        for (int order = 0; order < this.nOrder; ++order) {
            size += this.getSize(order);
        }
        return size;
    }

    @Override
    public long getMem() {
        long mem = 0L;
        for (int order = 0; order < this.nOrder; ++order) {
            mem += this.getMem(order);
        }
        return mem;
    }

    public long getMem(int order) {
        return this.level[order].getMem();
    }

    public int getSize(int order) {
        return this.level[order].getSize();
    }

    public Array getArray(int order) {
        return this.level[order];
    }

    public double getAngularRes() {
        return Math.sqrt(SpaceMoc.getPixelArea(this.getMocOrder()));
    }

    public int getMaxOrder() {
        return this.nOrder - 1;
    }

    @Override
    public void setCheckConsistencyFlag(boolean flag) throws Exception {
        this.testConsistency = flag;
        if (this.testConsistency) {
            this.checkAndFix();
        }
    }

    public int getDescendantOrder(int order, long npix) {
        long pix = npix / 4L;
        int o = order - 1;
        while (o >= 0) {
            if (this.level[o].find(pix) >= 0) {
                return o;
            }
            --o;
            pix /= 4L;
        }
        return -1;
    }

    @Override
    public void add(String s) throws Exception {
        StringTokenizer st = new StringTokenizer(s, " ;,\n\r\t{}");
        while (st.hasMoreTokens()) {
            String s1 = st.nextToken();
            if (s1.length() == 0) continue;
            this.addHpix(s1);
        }
    }

    @Override
    public void add(Moc m) throws Exception {
        SpaceMoc moc = (SpaceMoc)m;
        if (moc.getSize() > 250000) {
            this.setCheckConsistencyFlag(false);
        }
        int nadds = 0;
        for (int order = moc.nOrder - 1; order >= 0; --order) {
            for (long npix : moc.getArray(order)) {
                if (nadds > 500000) {
                    this.checkAndFix();
                    nadds = 0;
                }
                this.add(order, npix);
                ++nadds;
            }
        }
        this.setCheckConsistencyFlag(true);
    }

    public void add(int order, long[] npixs) throws Exception {
        if (npixs.length > 250000) {
            this.setCheckConsistencyFlag(false);
        }
        int nadds = 0;
        for (long npix : npixs) {
            if (nadds > 500000) {
                this.checkAndFix();
                nadds = 0;
            }
            this.add(order, npix);
            ++nadds;
        }
        this.setCheckConsistencyFlag(true);
    }

    public void add(int order, Collection<Long> a) throws Exception {
        if (a.size() > 250000) {
            this.setCheckConsistencyFlag(false);
        }
        int nadds = 0;
        for (long npix : a) {
            if (nadds > 500000) {
                this.checkAndFix();
                nadds = 0;
            }
            this.add(order, npix);
            ++nadds;
        }
        this.setCheckConsistencyFlag(true);
    }

    public boolean add(MocCell cell) throws Exception {
        return this.add(cell.order, cell.npix);
    }

    public boolean add(HealpixImpl healpix, double alpha, double delta) throws Exception {
        int order = this.getMaxOrder();
        if (order == -1) {
            return false;
        }
        long npix = healpix.ang2pix(order, alpha, delta);
        return this.add(order, npix);
    }

    public boolean add(int order, long npix) throws Exception {
        return this.add(order, npix, true);
    }

    private boolean add(int order, long npix, boolean testHierarchy) throws Exception {
        this.spaceRange = null;
        if (!this.testConsistency) {
            this.isConsistant = false;
            return this.add1(order, npix);
        }
        if (npix >= 0L) {
            if (testHierarchy) {
                if (order > this.minLimitOrder && this.isDescendant(order, npix)) {
                    return false;
                }
                this.deleteDescendant(order, npix);
            }
            if (order > this.minLimitOrder && this.deleteBrothers(order, npix)) {
                return this.add(order - 1, npix >>> 2, testHierarchy);
            }
        }
        return this.add1(order, npix);
    }

    private boolean deleteBrothers(int order, long me) {
        return this.level[order].deleteBrothers(me);
    }

    public void delete(String s) {
        StringTokenizer st = new StringTokenizer(s, " ;,\n\r\t");
        while (st.hasMoreTokens()) {
            this.deleteHpix(st.nextToken());
        }
    }

    public boolean delete(int order, long npix) {
        if (order >= this.nOrder) {
            return false;
        }
        this.spaceRange = null;
        return this.level[order].delete(npix);
    }

    public boolean deleteDescendant(int order, long npix) {
        this.spaceRange = null;
        long v1 = npix * 4L;
        long v2 = (npix + 1L) * 4L - 1L;
        boolean rep = false;
        int o = order + 1;
        while (o < this.nOrder) {
            rep |= this.getArray(o).delete(v1, v2);
            ++o;
            v1 *= 4L;
            v2 = (v2 + 1L) * 4L - 1L;
        }
        return rep;
    }

    public void sort() {
        for (int order = 0; order < this.nOrder; ++order) {
            this.level[order].sort();
        }
    }

    public boolean isSorted() {
        for (int order = 0; order < this.nOrder; ++order) {
            if (this.level[order].isSorted()) continue;
            return false;
        }
        return true;
    }

    public boolean isInTree(int order, long npix) {
        return this.isIntersecting(order, npix);
    }

    public boolean isInTree(SpaceMoc moc) {
        return this.isIntersecting(moc);
    }

    public void checkAndFix() throws Exception {
        if (this.getMaxOrder() == -1 || this.isConsistant) {
            return;
        }
        this.spaceRange = null;
        this.sort();
        SpaceMoc res = new SpaceMoc(this.coordSys, this.minLimitOrder, this.maxLimitOrder);
        int[] p = new int[this.getMaxOrder() + 1];
        for (int npix = 0; npix < 12; ++npix) {
            this.checkAndFix(res, p, 0, npix);
        }
        for (int order = res.nOrder - 1; order >= 0; --order) {
            Array a;
            this.level[order] = a = res.getArray(order);
        }
        this.nOrder = p.length;
        res = null;
        this.isConsistant = true;
    }

    private void checkAndFix(SpaceMoc res, int[] p, int order, long pix) throws Exception {
        block10: {
            long mx;
            int o;
            long t = -1L;
            Array a = this.getArray(order);
            if (p[order] < a.getSize()) {
                t = a.get(p[order]);
            }
            if (t == pix) {
                res.add(order, pix, false);
                for (int o2 = order; o2 < p.length; ++o2) {
                    long mx2 = pix + 1L << (o2 - order << 1);
                    a = this.getArray(o2);
                    while (p[o2] < a.getSize() && a.get(p[o2]) < mx2) {
                        int n = o2;
                        p[n] = p[n] + 1;
                    }
                }
                return;
            }
            boolean found = false;
            for (o = order + 1; o < p.length; ++o) {
                mx = pix + 1L << (o - order << 1);
                a = this.getArray(o);
                if (p[o] >= a.getSize() || a.get(p[o]) >= mx) continue;
                found = true;
                break;
            }
            if (!found) break block10;
            if (res.maxLimitOrder != -1 && order > res.maxLimitOrder) {
                res.add(order, pix, false);
                for (o = order; o < p.length; ++o) {
                    mx = pix + 1L << (o - order << 1);
                    a = this.getArray(o);
                    while (p[o] < a.getSize() && a.get(p[o]) < mx) {
                        int n = o;
                        p[n] = p[n] + 1;
                    }
                }
            } else {
                for (int i = 0; i < 4; ++i) {
                    this.checkAndFix(res, p, order + 1, (pix << 2) + (long)i);
                }
            }
        }
    }

    public boolean isAscendant(int order, long npix) {
        long range = 4L;
        int o = order + 1;
        while (o < this.nOrder) {
            if (this.level[o].intersectRange(npix * range, (npix + 1L) * range - 1L)) {
                return true;
            }
            ++o;
            range *= 4L;
        }
        return false;
    }

    public boolean isDescendant(int order, long npix) {
        long pix = npix / 4L;
        int o = order - 1;
        while (o >= this.minLimitOrder) {
            if (this.level[o].find(pix) >= 0) {
                return true;
            }
            --o;
            pix /= 4L;
        }
        return false;
    }

    public boolean isIn(int order, long npix) {
        return this.level[order].find(npix) >= 0;
    }

    @Override
    public void setProperty(String key, String value) throws Exception {
        if (key.equals("MOCORDER")) {
            int mocOrder = Integer.parseInt(value);
            this.setMaxLimitOrder(mocOrder);
        } else if (key.equals("COORDSYS")) {
            this.setCoordSys(value);
        } else {
            this.property.put(key, value);
        }
    }

    public double getCoverage() {
        long area = this.getArea();
        for (long usedArea = this.getUsedArea(); area > Long.MAX_VALUE || usedArea > Long.MAX_VALUE; area /= 2L, usedArea /= 2L) {
        }
        if (area == 0L) {
            return 0.0;
        }
        return (double)this.getUsedArea() / (double)area;
    }

    public long getUsedArea() {
        long n = 0L;
        long sizeCell = 1L;
        int order = this.getMocOrder();
        while (order >= 0) {
            n += (long)this.getSize(order) * sizeCell;
            --order;
            sizeCell *= 4L;
        }
        return n;
    }

    public long getArea() {
        int nOrder = this.getMocOrder() + 1;
        long nside = SpaceMoc.pow2(nOrder - 1);
        return 12L * nside * nside;
    }

    @Override
    public Iterator<MocCell> iterator() {
        return new HpixListIterator();
    }

    public Iterator<Long> pixelIterator() {
        this.sort();
        return new PixelIterator();
    }

    @Override
    public void trim() {
        for (int order = 0; order < this.nOrder; ++order) {
            this.level[order].trim();
        }
    }

    public String todebug() {
        StringBuffer s = new StringBuffer();
        double coverage = (double)((int)(this.getCoverage() * 10000.0)) / 100.0;
        s.append("nOrder=" + this.getMocOrder() + " [" + this.minLimitOrder + ".." + (this.maxLimitOrder == -1 ? "max" : this.maxLimitOrder + "") + "] mem=" + this.getMem() / 1024L + "KB size=" + this.getSize() + " coverage=" + coverage + "%" + (this.isSorted() ? " sorted" : "") + (this.isConsistant ? " consistant" : "") + "\n");
        long oOrder = -1L;
        Iterator<MocCell> it = this.iterator();
        for (int i = 0; it.hasNext() && i < 80; ++i) {
            MocCell x = it.next();
            if ((long)x.order != oOrder) {
                s.append(" " + x.order + "/");
            } else {
                s.append(",");
            }
            s.append(x.npix);
            oOrder = x.order;
        }
        if (it.hasNext()) {
            s.append("...\n");
        }
        for (int order = 0; order < this.nOrder; ++order) {
            s.append(" " + order + ":" + this.level[order].getSize());
        }
        return s.toString();
    }

    @Override
    public String toString() {
        try {
            return this.toASCII();
        }
        catch (Exception e) {
            return null;
        }
    }

    public String toJSON() {
        StringBuilder res = new StringBuilder(this.getSize() * 8);
        int order = -1;
        boolean flagNL = this.getSize() > 20;
        boolean first = true;
        int sizeLine = 0;
        res.append("{");
        for (MocCell c : this) {
            if (res.length() > 0) {
                if (c.order != order) {
                    if (!first) {
                        res.append("],");
                    }
                    if (flagNL) {
                        res.append("\n");
                        sizeLine = 0;
                    } else {
                        res.append(" ");
                    }
                } else {
                    int n = (c.npix + "").length();
                    if (flagNL && n + sizeLine > 80) {
                        res.append(",\n ");
                        sizeLine = 3;
                    } else {
                        res.append(',');
                        ++sizeLine;
                    }
                }
                first = false;
            }
            String s = c.order != order ? "\"" + c.order + "\":[" + c.npix : c.npix + "";
            res.append(s);
            sizeLine += s.length();
            order = c.order;
        }
        int n = res.length();
        if (first) {
            res.append("}");
        } else if (res.charAt(n - 1) == ',') {
            res.replace(n - 1, n - 1, "]" + (flagNL ? "\n" : " ") + "}");
        } else {
            res.append("]" + (flagNL ? "\n" : " ") + "}");
        }
        return res.toString();
    }

    public void toRangeSet() {
        if (this.spaceRange != null) {
            return;
        }
        this.sort();
        this.spaceRange = new Range(this.getSize());
        Range rtmp = new Range();
        for (int order = 0; order < this.nOrder; ++order) {
            rtmp.clear();
            int shift = 2 * (29 - order);
            for (long npix : this.getArray(order)) {
                rtmp.append(npix << shift, npix + 1L << shift);
            }
            if (rtmp.isEmpty()) continue;
            this.spaceRange = this.spaceRange.union(rtmp);
        }
    }

    public void toHealpixMoc() throws Exception {
        this.clear();
        this.setCheckConsistencyFlag(false);
        Range r2 = new Range(this.spaceRange);
        Range r3 = new Range();
        for (int o = 0; o <= 29; ++o) {
            if (r2.isEmpty()) {
                return;
            }
            int shift = 2 * (29 - o);
            long ofs = (1L << shift) - 1L;
            r3.clear();
            for (int iv = 0; iv < r2.nranges(); ++iv) {
                long a = r2.begins(iv) + ofs >>> shift;
                long b = r2.ends(iv) >>> shift;
                r3.append(a << shift, b << shift);
                for (long c = a; c < b; ++c) {
                    this.add1(o, c);
                }
            }
            if (r3.isEmpty()) continue;
            r2 = r2.difference(r3);
        }
        this.setCheckConsistencyFlag(true);
    }

    public boolean contains(long npix) {
        this.toRangeSet();
        return this.spaceRange.contains(npix);
    }

    public boolean isIntersecting(int order, long npix) {
        return this.isIn(order, npix) || this.isAscendant(order, npix) || this.isDescendant(order, npix);
    }

    @Override
    public boolean isIntersecting(Moc moc) {
        if (this.isAllSky()) {
            return true;
        }
        this.sort();
        ((SpaceMoc)moc).sort();
        int n = moc.getMaxOrder();
        for (int o = 0; o <= n; ++o) {
            Array a = moc.getArray(o);
            if (!this.isInTree(o, a)) continue;
            return true;
        }
        return false;
    }

    public boolean isIncluding(SpaceMoc moc) {
        if (this.isAllSky()) {
            return true;
        }
        for (MocCell c : moc) {
            if (this.isIn(c.order, c.npix) || this.isDescendant(c.order, c.npix)) continue;
            return false;
        }
        return true;
    }

    public SpaceMoc getSpaceMoc() throws Exception {
        return this;
    }

    public TimeMoc getTimeMoc() throws Exception {
        throw new Exception("No temporal dimension");
    }

    @Override
    public Moc union(Moc moc) throws Exception {
        return this.operation(moc.getSpaceMoc(), 0);
    }

    @Override
    public Moc intersection(Moc moc) throws Exception {
        return this.operation(moc.getSpaceMoc(), 1);
    }

    @Override
    public Moc subtraction(Moc moc) throws Exception {
        return this.operation(moc.getSpaceMoc(), 2);
    }

    public Moc difference(Moc moc) throws Exception {
        SpaceMoc m = moc.getSpaceMoc();
        Moc inter = this.intersection(m);
        Moc union = this.union(m);
        return union.subtraction(inter);
    }

    public SpaceMoc complement() throws Exception {
        SpaceMoc allsky = new SpaceMoc();
        allsky.add("0/0-11");
        allsky.toRangeSet();
        this.toRangeSet();
        SpaceMoc res = new SpaceMoc(this.coordSys, this.minLimitOrder, this.maxLimitOrder);
        res.spaceRange = allsky.spaceRange.difference(this.spaceRange);
        res.toHealpixMoc();
        return res;
    }

    protected SpaceMoc operation(SpaceMoc moc, int op) throws Exception {
        this.testCompatibility(moc);
        this.toRangeSet();
        moc.toRangeSet();
        int min = Math.min(this.minLimitOrder, moc.minLimitOrder);
        int max = Math.max(this.getMocOrder(), moc.getMocOrder());
        SpaceMoc res = new SpaceMoc(this.coordSys, min, max);
        switch (op) {
            case 0: {
                res.spaceRange = this.spaceRange.union(moc.spaceRange);
                break;
            }
            case 1: {
                res.spaceRange = this.spaceRange.intersection(moc.spaceRange);
                break;
            }
            case 2: {
                res.spaceRange = this.spaceRange.difference(moc.spaceRange);
            }
        }
        res.toHealpixMoc();
        return res;
    }

    public boolean isAllSky() {
        return (long)this.getSize(this.minLimitOrder) == 12L * SpaceMoc.pow2(this.minLimitOrder) * SpaceMoc.pow2(this.minLimitOrder);
    }

    @Override
    public boolean isEmpty() {
        return this.getSize() == 0;
    }

    public boolean equals(Object moc) {
        if (this == moc) {
            return true;
        }
        try {
            int o;
            SpaceMoc m = (SpaceMoc)moc;
            this.testCompatibility(m);
            if (m.nOrder != this.nOrder) {
                return false;
            }
            for (o = 0; o < this.nOrder; ++o) {
                if (this.getSize(o) == m.getSize(o)) continue;
                return false;
            }
            for (o = 0; o < this.nOrder; ++o) {
                if (this.getArray(o).equals(m.getArray(o))) continue;
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public SpaceMoc queryCell(int order, long npix) throws Exception {
        return (SpaceMoc)this.intersection(new SpaceMoc(order + "/" + npix));
    }

    public void setPixLevel(int order, long[] val) throws Exception {
        if (SpaceMoc.getType(order) != 2) {
            throw new Exception("The order " + order + " requires long[] array");
        }
        this.level[order] = new LongArray(val);
        if (this.nOrder < order + 1) {
            this.nOrder = order + 1;
        }
    }

    public void setPixLevel(int order, int[] val) throws Exception {
        if (SpaceMoc.getType(order) != 1) {
            throw new Exception("The order " + order + " requires int[] array");
        }
        this.level[order] = new IntArray(val);
        if (this.nOrder < order + 1) {
            this.nOrder = order + 1;
        }
    }

    public void setPixLevel(int order, short[] val) throws Exception {
        if (SpaceMoc.getType(order) != 0) {
            throw new Exception("The order " + order + " requires short[] array");
        }
        this.level[order] = new ShortArray(val);
        if (this.nOrder < order + 1) {
            this.nOrder = order + 1;
        }
    }

    public long[] getPixLevel(int order) {
        int size = this.getSize(order);
        long[] lev = new long[size];
        if (size == 0) {
            return lev;
        }
        Array a = this.level[order];
        for (int i = 0; i < size; ++i) {
            lev[i] = a.get(i);
        }
        return lev;
    }

    @Override
    public void read(String filename) throws Exception {
        new MocIO(this).read(filename);
    }

    @Override
    public void read(String filename, int mode) throws Exception {
        new MocIO(this).read(filename, mode);
    }

    @Override
    public void read(InputStream in) throws Exception {
        new MocIO(this).read(in);
    }

    @Override
    public void read(InputStream in, int mode) throws Exception {
        new MocIO(this).read(in, mode);
    }

    @Override
    public void readASCII(InputStream in) throws Exception {
        new MocIO(this).read(in, 2);
    }

    @Override
    public void readJSON(InputStream in) throws Exception {
        new MocIO(this).read(in, 1);
    }

    @Override
    public void readFits(InputStream in) throws Exception {
        new MocIO(this).read(in, 0);
    }

    @Override
    public void write(String filename) throws Exception {
        this.check();
        new MocIO(this).write(filename);
    }

    @Override
    public void write(String filename, int mode) throws Exception {
        this.check();
        new MocIO(this).write(filename, mode);
    }

    @Override
    public void write(OutputStream out, int mode) throws Exception {
        this.check();
        new MocIO(this).write(out, mode);
    }

    @Override
    public void writeASCII(OutputStream out) throws Exception {
        this.check();
        new MocIO(this).writeASCII(out);
    }

    @Override
    public void writeJSON(OutputStream out) throws Exception {
        this.check();
        new MocIO(this).writeJSON(out);
    }

    @Override
    public void writeFits(OutputStream out) throws Exception {
        this.writeFITS(out);
    }

    @Override
    public void writeFITS(OutputStream out) throws Exception {
        this.check();
        new MocIO(this).writeFits(out);
    }

    @Override
    protected int writeSpecificFitsProp(OutputStream out) throws Exception {
        int n = 0;
        out.write(MocIO.getFitsLine("TTYPE1", "UNIQ", "UNIQ pixel number"));
        n += 80;
        out.write(MocIO.getFitsLine("PIXTYPE", "HEALPIX", "HEALPix magic code"));
        n += 80;
        out.write(MocIO.getFitsLine("ORDERING", "NUNIQ", "NUNIQ coding method"));
        n += 80;
        out.write(MocIO.getFitsLine("COORDSYS", "" + this.getCoordSys(), "reference frame (C=ICRS)"));
        n += 80;
        out.write(MocIO.getFitsLine("MOC", "SPACE", "Spacial MOC"));
        n += 80;
        out.write(MocIO.getFitsLine("MOCORDER", "" + this.getMocOrder(), "MOC resolution (best order)"));
        return n += 80;
    }

    @Override
    protected int writeSpecificData(OutputStream out) throws Exception {
        if (this.getSize() <= 0) {
            return 0;
        }
        int nbytes = SpaceMoc.getType(this.getMaxOrder()) == 2 ? 8 : 4;
        byte[] buf = new byte[nbytes];
        int size = 0;
        int nOrder = this.getMaxOrder() + 1;
        for (int order = 0; order < nOrder; ++order) {
            int n = this.getSize(order);
            if (n == 0) continue;
            Array a = this.getArray(order);
            for (int i = 0; i < n; ++i) {
                long val = SpaceMoc.hpix2uniq(order, a.get(i));
                size += MocIO.writeVal(out, val, buf);
            }
        }
        return size;
    }

    @Override
    protected void readSpecificData(InputStream in, int naxis1, int naxis2, int nbyte, MocIO.HeaderFits header) throws Exception {
        byte[] buf = new byte[naxis1 * naxis2];
        MocIO.readFully(in, buf);
        this.createUniq(naxis1 * naxis2 / nbyte, nbyte, buf);
    }

    protected void createUniq(int nval, int nbyte, byte[] t) throws Exception {
        int i = 0;
        long[] hpix = null;
        long oval = -1L;
        for (int k = 0; k < nval; ++k) {
            long val = 0L;
            int a = t[i] << 24 | (t[i + 1] & 0xFF) << 16 | (t[i + 2] & 0xFF) << 8 | t[i + 3] & 0xFF;
            if (nbyte == 4) {
                val = a;
            } else {
                int b = t[i + 4] << 24 | (t[i + 5] & 0xFF) << 16 | (t[i + 6] & 0xFF) << 8 | t[i + 7] & 0xFF;
                val = (long)a << 32 | (long)b & 0xFFFFFFFFL;
            }
            i += nbyte;
            long min = val;
            if (val < 0L) {
                min = oval + 1L;
                val = -val;
            }
            for (long v = min; v <= val; ++v) {
                hpix = SpaceMoc.uniq2hpix(v, hpix);
                int order = (int)hpix[0];
                this.add(order, hpix[1]);
            }
            oval = val;
        }
    }

    @Override
    protected int getType() {
        return SpaceMoc.getType(this.getMaxOrder());
    }

    protected void init(String coordSys, int minLimitorder, int maxLimitOrder) {
        this.coordSys = coordSys;
        this.minLimitOrder = minLimitorder;
        this.maxLimitOrder = maxLimitOrder;
        this.property = new HashMap();
        if (maxLimitOrder != -1) {
            this.property.put("MOCORDER", maxLimitOrder + "");
        }
        this.property.put("COORDSYS", coordSys);
        this.property.put("MOCTOOL", "CDSjavaAPI-6.0");
        this.property.put("DATE", String.format("%tFT%<tR", new Date()));
        this.testConsistency = true;
        this.isConsistant = true;
        this.level = new Array[30];
        for (int order = 0; order < 30; ++order) {
            int type = SpaceMoc.getType(order);
            int bloc = (1 + order) * 10;
            Array a = type == 0 ? new ShortArray(bloc) : (type == 1 ? new IntArray(bloc) : new LongArray(bloc));
            this.level[order] = a;
        }
    }

    protected boolean add1(int order, long npix) throws Exception {
        if (order < this.minLimitOrder) {
            return this.add2(order, npix, this.minLimitOrder);
        }
        if (this.maxLimitOrder != -1 && order > this.maxLimitOrder) {
            return this.add(this.maxLimitOrder, npix >>> (order - this.maxLimitOrder << 1));
        }
        if (order > 29) {
            throw new Exception("Out of MOC order");
        }
        if (order >= this.nOrder) {
            this.nOrder = order + 1;
        }
        if (npix < 0L) {
            return false;
        }
        return this.level[order].add(npix, this.testConsistency);
    }

    private boolean add2(int orderSrc, long npix, int orderTrg) throws Exception {
        if (orderTrg > 29) {
            throw new Exception("Out of MOC order");
        }
        if (orderTrg >= this.nOrder) {
            this.nOrder = orderTrg + 1;
        }
        if (npix < 0L) {
            return false;
        }
        long fct = SpaceMoc.pow2(orderTrg - orderSrc);
        fct *= fct;
        npix *= fct;
        boolean rep = false;
        int i = 0;
        while ((long)i < fct) {
            rep |= this.level[orderTrg].add(npix + (long)i, this.testConsistency);
            ++i;
        }
        return rep;
    }

    @Override
    public void addHpix(String s) throws Exception {
        int j;
        if (s == null) {
            return;
        }
        int i = s.indexOf(47);
        if (i < 0) {
            i = s.indexOf(58);
        }
        if (i > 0) {
            this.currentOrder = Integer.parseInt(this.unQuote(s.substring(0, i)));
        }
        if ((j = s.indexOf(45, i + 1)) < 0) {
            String s1 = this.unBracket(s.substring(i + 1));
            long npix = s1.trim().length() == 0 ? -1L : Long.parseLong(s1);
            this.add(this.currentOrder, npix);
        } else {
            long startIndex = Long.parseLong(s.substring(i + 1, j));
            long endIndex = Long.parseLong(s.substring(j + 1));
            if (endIndex - startIndex > 10L) {
                this.addRange(this.currentOrder, startIndex, endIndex);
            } else {
                for (long k = startIndex; k <= endIndex; ++k) {
                    this.add(this.currentOrder, k);
                }
            }
        }
    }

    private void addRange(int order, long start, long end) throws Exception {
        int shift = (29 - order) * 2;
        end = end + 1L << shift;
        this.toRangeSet();
        this.spaceRange.add(start <<= shift, end);
        this.toHealpixMoc();
    }

    private String unQuote(String s) {
        int n = s.length();
        if (n > 2 && s.charAt(0) == '\"' && s.charAt(n - 1) == '\"') {
            return s.substring(1, n - 1);
        }
        return s;
    }

    private String unBracket(String s) {
        int n = s.length();
        if (n < 1) {
            return s;
        }
        int o1 = s.charAt(0) == '[' ? 1 : 0;
        int o2 = s.charAt(n - 1) == ']' ? n - 1 : n;
        return s.substring(o1, o2);
    }

    private void deleteHpix(String s) {
        int j;
        int i = s.indexOf(47);
        if (i > 0) {
            this.currentOrder = Integer.parseInt(s.substring(0, i));
        }
        if ((j = s.indexOf(45, i + 1)) < 0) {
            this.delete(this.currentOrder, Integer.parseInt(s.substring(i + 1)));
        } else {
            int startIndex = Integer.parseInt(s.substring(i + 1, j));
            int endIndex = Integer.parseInt(s.substring(j + 1));
            for (int k = startIndex; k <= endIndex; ++k) {
                this.delete(this.currentOrder, k);
            }
        }
    }

    @Override
    public void check() throws Exception {
        if (!this.testConsistency) {
            this.checkAndFix();
        } else {
            this.sort();
        }
    }

    protected void testCompatibility(SpaceMoc moc) throws Exception {
        if (this.getCoordSys().charAt(0) != moc.getCoordSys().charAt(0)) {
            throw new Exception("Incompatible MOC coordsys");
        }
    }

    private int strategie(int size1, int size2) {
        if (size1 == 0 || size2 == 0) {
            return 0;
        }
        double m1 = (double)size1 * (1.0 + Math.log(size2) / Math.log(2.0));
        double m2 = (double)size2 * (1.0 + Math.log(size1) / Math.log(2.0));
        double m3 = size1 + size2;
        if (m1 < m2 && m1 < m3) {
            return 1;
        }
        if (m2 < m1 && m2 < m3) {
            return 2;
        }
        return 3;
    }

    private boolean isIn(int order, Array a) {
        Array a1 = this.level[order];
        Array a2 = a;
        int size2 = a2.getSize();
        int size1 = a1.getSize();
        if (!a1.intersectRange(a2.get(0), a2.get(size2 - 1))) {
            return false;
        }
        switch (this.strategie(size1, size2)) {
            case 0: {
                return false;
            }
            case 1: {
                for (long x : a1) {
                    if (a2.find(x) < 0) continue;
                    return true;
                }
                return false;
            }
            case 2: {
                for (long x : a2) {
                    if (a1.find(x) < 0) continue;
                    return true;
                }
                return false;
            }
        }
        boolean incr1 = true;
        long x1 = a1.get(0);
        long x2 = a2.get(0);
        int i1 = 0;
        int i2 = 0;
        while (i1 < size1 && i2 < size2) {
            if (incr1) {
                x1 = a1.get(i1);
            } else {
                x2 = a2.get(i2);
            }
            if (x1 == x2) {
                return true;
            }
            boolean bl = incr1 = x1 < x2;
            if (incr1) {
                ++i1;
                continue;
            }
            ++i2;
        }
        return false;
    }

    private boolean isAscendant(int order, Array a) {
        long range = 4L;
        int o = order + 1;
        while (o < this.nOrder) {
            Array a1 = this.level[o];
            Array a2 = a;
            int size2 = a2.getSize();
            int size1 = a1.getSize();
            if (a1.intersectRange(a2.get(0) * range, (a2.get(size2 - 1) + 1L) * range - 1L)) {
                switch (this.strategie(size1, size2)) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        long onpix = -1L;
                        for (long x : a1) {
                            long npix = x / range;
                            if (npix == onpix) continue;
                            if (a2.find(npix) >= 0) {
                                return true;
                            }
                            onpix = npix;
                        }
                        break;
                    }
                    case 2: {
                        for (long pix : a2) {
                            if (!a1.intersectRange(pix * range, (pix + 1L) * range - 1L)) continue;
                            return true;
                        }
                        break;
                    }
                    default: {
                        boolean incr1 = true;
                        long x1 = a1.get(0);
                        long x2 = a2.get(0) * range;
                        long x3 = (a2.get(0) + 1L) * range - 1L;
                        int i1 = 0;
                        int i2 = 0;
                        while (i1 < size1 && i2 < size2) {
                            if (incr1) {
                                x1 = a1.get(i1);
                            } else {
                                x2 = a2.get(i2) * range;
                                x3 = (a2.get(i2) + 1L) * range - 1L;
                            }
                            if (x2 <= x1 && x1 <= x3) {
                                return true;
                            }
                            boolean bl = incr1 = x1 < x3;
                            if (incr1) {
                                ++i1;
                                continue;
                            }
                            ++i2;
                        }
                        break block0;
                    }
                }
            }
            ++o;
            range *= 4L;
        }
        return false;
    }

    private boolean isDescendant(int order, Array a) {
        long range = 4L;
        int o = order - 1;
        while (o >= 0) {
            Array a1 = this.level[o];
            Array a2 = a;
            int size2 = a2.getSize();
            int size1 = a1.getSize();
            if (a1.intersectRange(a2.get(0) / range, a2.get(size2 - 1) / range)) {
                switch (this.strategie(size1, size2)) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        for (long x : a1) {
                            if (!a2.intersectRange(x * range, (x + 1L) * range - 1L)) continue;
                            return true;
                        }
                        break;
                    }
                    case 2: {
                        long onpix = -1L;
                        for (long x : a2) {
                            long npix = x / range;
                            if (npix == onpix) continue;
                            if (a1.find(npix) >= 0) {
                                return true;
                            }
                            onpix = npix;
                        }
                        break;
                    }
                    default: {
                        boolean incr1 = true;
                        long x1 = a1.get(0);
                        long x2 = a2.get(0) / range;
                        int i1 = 0;
                        int i2 = 0;
                        while (i1 < size1 && i2 < size2) {
                            if (incr1) {
                                x1 = a1.get(i1);
                            } else {
                                x2 = a2.get(i2) / range;
                            }
                            if (x1 == x2) {
                                return true;
                            }
                            boolean bl = incr1 = x1 < x2;
                            if (incr1) {
                                ++i1;
                                continue;
                            }
                            ++i2;
                        }
                        break block0;
                    }
                }
            }
            --o;
            range *= 4L;
        }
        return false;
    }

    private boolean isInTree(int order, Array a) {
        if (a == null || a.getSize() == 0) {
            return false;
        }
        if (a.getSize() == 1) {
            return this.isInTree(order, a.get(0));
        }
        return this.isIn(order, a) || this.isAscendant(order, a) || this.isDescendant(order, a);
    }

    public static double getPixelArea(int order) {
        if (order < 0) {
            return SKYAREA;
        }
        long nside = SpaceMoc.pow2(order);
        long npixels = 12L * nside * nside;
        return SKYAREA / (double)npixels;
    }

    public static SpaceMoc convertTo(SpaceMoc moc, String coordSys) throws Exception {
        int frameSrc;
        if (coordSys.equals(moc.getCoordSys())) {
            return moc;
        }
        char a = moc.getCoordSys().charAt(0);
        char b = coordSys.charAt(0);
        int n = a == 'G' ? 3 : (frameSrc = a == 'E' ? 2 : 0);
        int frameDst = b == 'G' ? 3 : (b == 'E' ? 2 : 0);
        Healpix hpx = new Healpix();
        int order = moc.getMaxOrder();
        SpaceMoc moc1 = new SpaceMoc(coordSys, moc.getMinLimitOrder(), moc.getMocOrder());
        moc1.setCheckConsistencyFlag(false);
        long onpix1 = -1L;
        Iterator<Long> it = moc.pixelIterator();
        while (it.hasNext()) {
            long npix = it.next();
            for (int i = 0; i < 4; ++i) {
                double[] coo = hpx.pix2ang(order + 1, npix * 4L + (long)i);
                Coord c = new Coord(coo[0], coo[1]);
                c = Localisation.frameToFrame(c, frameSrc, frameDst);
                long npix1 = hpx.ang2pix(order + 1, c.al, c.del);
                if (npix1 == onpix1) continue;
                onpix1 = npix1;
                moc1.add(order, npix1 / 4L);
            }
        }
        moc1.setCheckConsistencyFlag(true);
        return moc1;
    }

    private class PixelIterator
    implements Iterator<Long> {
        private boolean ready = false;
        private long current;
        private int order = -1;
        private long indice = 0L;
        private long range = 0L;
        private long currentTete;
        private boolean hasNext = true;
        private int[] p = new int[SpaceMoc.this.getMocOrder() + 1];

        private PixelIterator() {
        }

        @Override
        public boolean hasNext() {
            this.goNext();
            return this.hasNext;
        }

        @Override
        public Long next() {
            if (!this.hasNext()) {
                return null;
            }
            this.ready = false;
            return this.current;
        }

        @Override
        public void remove() {
        }

        private void goNext() {
            if (this.ready) {
                return;
            }
            if (this.indice == this.range) {
                long min = Long.MAX_VALUE;
                long fct = 1L;
                long tete = -1L;
                int mocOrder = SpaceMoc.this.getMocOrder();
                this.order = -1;
                int o = mocOrder;
                while (o >= SpaceMoc.this.minLimitOrder) {
                    Array a = SpaceMoc.this.level[o];
                    if (a != null) {
                        long l = tete = this.p[o] < a.getSize() ? a.get(this.p[o]) * fct : -1L;
                        if (tete != -1L && tete < min) {
                            min = tete;
                            this.order = o;
                            this.range = fct;
                        }
                    }
                    --o;
                    fct *= 4L;
                }
                if (this.order == -1) {
                    this.hasNext = false;
                    this.ready = true;
                    return;
                }
                this.currentTete = min;
                this.indice = 0L;
            }
            this.current = new Long(this.currentTete + this.indice);
            ++this.indice;
            if (this.indice == this.range) {
                int n = this.order;
                this.p[n] = this.p[n] + 1;
            }
            this.ready = true;
        }
    }

    private class HpixListIterator
    implements Iterator<MocCell> {
        private int currentOrder = 0;
        private int indice = -1;
        private boolean ready = false;

        private HpixListIterator() {
        }

        @Override
        public boolean hasNext() {
            this.goNext();
            return this.currentOrder < SpaceMoc.this.nOrder;
        }

        @Override
        public MocCell next() {
            if (!this.hasNext()) {
                return null;
            }
            this.ready = false;
            Array a = SpaceMoc.this.level[this.currentOrder];
            return new MocCell(this.currentOrder, a.get(this.indice));
        }

        @Override
        public void remove() {
        }

        private void goNext() {
            if (this.ready) {
                return;
            }
            ++this.indice;
            while (this.currentOrder < SpaceMoc.this.nOrder && this.indice >= SpaceMoc.this.getSize(this.currentOrder)) {
                ++this.currentOrder;
                this.indice = 0;
            }
            this.ready = true;
        }
    }
}

