/*
 * Decompiled with CFR 0.152.
 */
package cds.moc;

import cds.moc.Moc;
import cds.moc.MocCell;
import cds.moc.MocIO;
import cds.moc.Range;
import cds.moc.Range2;
import cds.moc.SMoc;
import cds.moc.TMoc;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;

public class STMoc
extends Moc {
    public Range2 range;
    private int timeOrder = -1;
    private int spaceOrder = -1;
    private StringBuilder buf = null;
    private SMoc tmoc = null;
    private static final String[][] TEST = new String[][]{{"Ajout \u00e0 vide", "", "t29/5-10 s29/2", "t29/5-10 s29/2", ""}, {"Ajout singleton derri\u00e8re singleton", "t29/4 s29/1", "t29/5 s29/2", "t29/4 s29/1 t29/5 s29/2", ""}, {"Ajout singleton avant singleton", "t29/5 s29/2", "t29/4 s29/1", "t29/4 s29/1 t29/5 s29/2", ""}, {"Ajout intervalle entrelac\u00e9s apr\u00e8s", "t29/4-6 s29/1", "t29/5-8 s29/2", "t29/4 s29/1 t29/5-6 s29/1-2 t29/7-8 s29/2", ""}, {"Ajout intervalle entrelac\u00e9s avant", "t29/5-8 s29/2", "t29/4-6 s29/1", "t29/4 s29/1 t29/5-6 s29/1-2 t29/7-8 s29/2", ""}, {"Ajout intervalle englobant (s diff\u00e9rents)", "t29/2-6 s29/2", "t29/1-8 s29/1", "t29/1 s29/1 t29/2-6 s29/1-2 t29/7-8 s29/1", ""}, {"Ajout intervalle englobant (s identiques)", "t29/2-6 s29/2", "t29/1-8 s29/2", "t29/1-8 s29/2", "t29/2-6 s29/2"}, {"Ajout intervalle interne (s diff\u00e9rents)", "t29/1-8 s29/1", "t29/2-6 s29/2", "t29/1 s29/1 t29/2-6 s29/1-2 t29/7-8 s29/1", ""}, {"Ajout intervalle interne (s identiques)", "t29/1-8 s29/2", "t29/2-6 s29/2", "t29/1-8 s29/2", "t29/2-6 s29/2"}, {"Intercallage", "t29/6-7 11 s29/1", "t29/9 s29/2", "t29/6-7 s29/1 t29/9 s29/2 t29/11 s29/1", ""}, {"Fusion diff\u00e9rents s", "t29/2-6 8-9 s29/2", "t29/7 s29/1", "t29/2-6 s29/2 t29/7 s29/1 t29/8-9 s29/2", ""}, {"Fusion indentiques s", "t29/2-6 8-9 s29/2", "t29/7 s29/2", "t29/2-9 s29/2", ""}, {"Remplacement sur d\u00e9but", "t29/2-6 s29/2 t29/7 s29/1", "t29/2-7 s29/2", "t29/2-6 s29/2 t29/7 s29/1-2", "t29/2-6 s29/2"}, {"Remplacement sur fin", "t29/3-7 s29/2 t29/8 s29/1", "t29/2-7 s29/2", "t29/2-7 s29/2 t29/8 s29/1", "t29/3-7 s29/2"}, {"Remplacement sur fin2", "t29/2-4 s29/2 t29/6 s29/1", "t29/6 s29/2", "t29/2-4 s29/2 t29/6 s29/1-2", ""}, {"Tordu", "t29/3 s29/1 t29/4-5 s29/2", "t29/3-5 s29/3", "t29/3 s29/1 3 t29/4-5 s29/2-3", ""}, {"Inter simple", "t29/3-5 s29/1-3", "t29/4-8 s29/2-4", "t29/3 s29/1-3 t29/4-5 s29/1-4 t29/6-8 s29/2-4", "t29/4-5 s29/2-3"}, {"Inter sp\u00e9cial", "t29/1 s29/1-6 t29/3-9 s29/2", "t29/3 s29/5-7 t29/8 s29/1-2", "t29/1 s29/1-6 t29/3 s29/2 5-7 t29/4-7 s29/2 t29/8 s29/1-2 t29/9 s29/2", "t29/8 s29/2"}, {"Ajout en suite", "t29/1-4 s29/1", "t29/5-6 s29/1", "t29/1-6 s29/1", ""}};

    public STMoc() {
        this.init();
        this.range = new Range2();
    }

    public STMoc(int spaceOrder, int timeOrder) {
        this();
        this.timeOrder = timeOrder;
        this.spaceOrder = spaceOrder;
    }

    public STMoc(int spaceOrder, int timeOrder, Range2 rangeSet) {
        this.init();
        this.spaceOrder = spaceOrder;
        this.timeOrder = timeOrder;
        this.range = new Range2(rangeSet);
    }

    public STMoc(String s) throws Exception {
        this();
        if (s != null && s.length() > 0) {
            this.append(s);
        } else {
            this.spaceOrder = 29;
            this.timeOrder = 29;
        }
    }

    private void init() {
        this.property = new HashMap();
        this.property.put("MOCTOOL", "CDSjavaAPI-7.0");
        this.property.put("DATE", String.format("%tFT%<tR", new Date()));
    }

    public boolean contains(long npix, double jd) {
        long npixTime = (long)(jd * 8.64E10);
        if (!this.range.contains(npixTime)) {
            return false;
        }
        for (Range r : this.range.rr) {
            if (!r.contains(npix)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        this.range.clear();
    }

    @Override
    public void setTimeOrder(int order) throws Exception {
        if (order < this.timeOrder) {
            this.degradeTimeOrder(order);
        }
        this.timeOrder = order;
    }

    @Override
    public int getTimeOrder() {
        return this.timeOrder;
    }

    @Override
    public void setSpaceOrder(int order) throws Exception {
        if (order < this.spaceOrder) {
            this.degradeSpaceOrder(order);
        }
        this.spaceOrder = order;
    }

    @Override
    public int getSpaceOrder() {
        return this.spaceOrder;
    }

    private void degradeSpaceOrder(int order) {
        this.degradeOrder(-1, order);
    }

    private void degradeTimeOrder(int order) {
        this.degradeOrder(order, -1);
    }

    private void degradeOrder(int timeOrder, int spaceOrder) {
        int shift1 = timeOrder == -1 ? 0 : (29 - timeOrder) * 2;
        int shift2 = spaceOrder == -1 ? 0 : (29 - spaceOrder) * 2;
        this.range = this.range.degrade(shift1, shift2);
    }

    @Override
    public void setMocOrder(int order) throws Exception {
        this.setTimeOrder(order);
    }

    @Override
    public int getMocOrder() {
        try {
            return this.getTimeOrder();
        }
        catch (Exception exception) {
            return -1;
        }
    }

    @Override
    public long getMem() {
        return this.range.getMem() + 20L;
    }

    @Override
    public int getSize() {
        int size = this.range.sz;
        for (int i = this.range.sz / 2 - 1; i >= 0; --i) {
            size += this.range.rr[i].sz;
        }
        return size;
    }

    public int getTimeRanges() {
        return this.range.nranges();
    }

    @Override
    public void add(String s) throws Exception {
    }

    @Override
    public void add(Moc moc) throws Exception {
    }

    @Override
    public void check() throws Exception {
    }

    @Override
    public void setProperty(String key, String value) throws Exception {
    }

    @Override
    public void accretion() throws Exception {
        this.accretion(this.getTimeOrder());
    }

    public void accretion(int order) throws Exception {
        Range2 r = new Range2(this.range.sz);
        int shift = (29 - order) * 2;
        long add = 1L << shift;
        for (int i = 0; i < this.range.sz; i += 2) {
            long a = this.range.r[i] - add;
            long b = this.range.r[i + 1] + add;
            r.add(a, b, this.range.rr[i >>> 1]);
        }
        this.range = r;
    }

    @Override
    public boolean isIntersecting(Moc moc) {
        return false;
    }

    private int maxT(Moc moc) {
        int o = moc.getTimeOrder();
        return this.timeOrder < o ? o : this.timeOrder;
    }

    private int maxS(Moc moc) {
        int o = moc.getSpaceOrder();
        return this.spaceOrder < o ? o : this.spaceOrder;
    }

    @Override
    public Moc union(Moc moc) throws Exception {
        return new STMoc(this.maxS(moc), this.maxT(moc), this.range.union(((STMoc)moc).range));
    }

    @Override
    public Moc intersection(Moc moc) throws Exception {
        STMoc m;
        if (moc instanceof STMoc) {
            m = (STMoc)moc;
        } else {
            if (moc instanceof TMoc) {
                throw new Exception("Not yet supported with TMoc");
            }
            Range2 r = new Range2(2);
            r.add(this.range.r[0], this.range.r[this.range.sz - 1], moc.getRange());
            m = new STMoc(moc.getMocOrder(), this.getMocOrder(), r);
        }
        return new STMoc(this.maxS(m), this.maxT(m), this.range.intersection(m.range));
    }

    @Override
    public Moc subtraction(Moc moc) throws Exception {
        return new STMoc(this.maxS(moc), this.maxT(moc), this.range.difference(((STMoc)moc).range));
    }

    @Override
    public String getSys() {
        return "C";
    }

    @Override
    public boolean isSpace() {
        return true;
    }

    @Override
    public boolean isTime() {
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.range.isEmpty();
    }

    @Override
    public boolean isFull() {
        return false;
    }

    public long getVal(long val, int order) {
        if (order == 29) {
            return val;
        }
        int deltaOrder = 29 - order << 1;
        val = val >>> deltaOrder << deltaOrder;
        return val;
    }

    public void add(long tmin, long tmax, long smin, long smax) {
        tmin = this.getVal(tmin, this.timeOrder);
        if ((tmax = this.getVal(tmax, this.timeOrder)) == tmin) {
            ++tmax;
        }
        smin = this.getVal(smin, this.spaceOrder);
        if ((smax = this.getVal(smax, this.spaceOrder)) == smin) {
            ++smax;
        }
        Range r = new Range();
        r.append(smin, smax);
        this.range.add(tmin, tmax, r);
    }

    public void sortAndFix() {
        this.range.sortAndFix();
    }

    @Override
    public int getMaxUsedOrder() {
        return -1;
    }

    @Override
    public void setCheckConsistencyFlag(boolean flag) throws Exception {
    }

    @Override
    public void toMocSet() throws Exception {
    }

    @Override
    public void setCurrentOrder(int order) {
    }

    @Override
    public void trim() {
    }

    @Override
    public Iterator<MocCell> iterator() {
        return null;
    }

    @Override
    protected void addHpix(String s) throws Exception {
        if (s == null || s.charAt(0) == 't') {
            if (this.tmoc != null) {
                SMoc moc = new SMoc(this.buf.toString());
                moc.toRangeSet();
                if (moc.getMocOrder() > this.spaceOrder) {
                    this.spaceOrder = moc.getMocOrder();
                }
                for (int i = 0; i < this.tmoc.range.sz; i += 2) {
                    this.range.append(this.tmoc.range.r[i], this.tmoc.range.r[i + 1], moc.range);
                }
                this.tmoc = null;
                this.buf = null;
            }
            if (s != null) {
                this.buf = new StringBuilder(s.substring(1));
            }
        } else if (s.charAt(0) == 's') {
            this.tmoc = new SMoc(this.buf.toString());
            this.tmoc.toRangeSet();
            if (this.tmoc.getMocOrder() > this.timeOrder) {
                this.timeOrder = this.tmoc.getMocOrder();
            }
            this.buf = new StringBuilder(s.substring(1));
        } else {
            if (this.buf == null) {
                throw new Exception("Moc syntax error [token=" + s + "]");
            }
            this.buf.append(' ');
            this.buf.append(s);
        }
    }

    public void append(String s) throws Exception {
        StringTokenizer st = new StringTokenizer(s, " ;,\n\r\t{}");
        while (st.hasMoreTokens()) {
            String s1 = st.nextToken();
            if (s1.length() == 0) continue;
            this.addHpix(s1);
        }
        this.addHpix(null);
    }

    public String toString2() {
        return this.toString2(false);
    }

    public String toString2(boolean flagNL) {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < this.range.sz; i += 2) {
            Range m;
            long a = this.range.r[i];
            long b = this.range.r[i + 1];
            s.append("t" + a);
            if (b - 1L != a) {
                s.append("-" + (b - 1L));
            }
            if ((m = this.range.rr[i >>> 1]) != null && !m.isEmpty()) {
                s.append(flagNL ? " s" : "s");
                if (flagNL) {
                    try {
                        SMoc moc = new SMoc(m);
                        s.append(moc.toASCII());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    for (int j = 0; j < m.sz; j += 2) {
                        s.append(m.r[j]);
                        if (m.r[j + 1] - 1L != m.r[j]) {
                            s.append("-" + (m.r[j + 1] - 1L));
                        }
                        if (j >= m.sz - 2) continue;
                        s.append(',');
                    }
                }
            }
            if (i >= this.range.sz - 2) continue;
            s.append(flagNL ? (char)'\n' : ' ');
        }
        return s.toString();
    }

    public String toString3() {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < this.range.sz; i += 2) {
            Range m;
            s.append("t" + this.range.r[i]);
            if (this.range.r[i + 1] - 1L != this.range.r[i]) {
                s.append("-" + (this.range.r[i + 1] - 1L));
            }
            if ((m = this.range.rr[i >>> 1]) != null && !m.isEmpty()) {
                s.append(" s");
                try {
                    SMoc moc = new SMoc(m);
                    s.append(moc.toASCII());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (i >= this.range.sz - 2) continue;
            s.append('\n');
        }
        return s.toString();
    }

    public String toString4() {
        StringBuilder s = new StringBuilder();
        int shift = (29 - this.timeOrder) * 2;
        for (int i = 0; i < this.range.sz; i += 2) {
            s.append("t");
            try {
                long deb = this.range.r[i];
                long fin = this.range.r[i + 1];
                fin = fin - 1L >>> shift;
                s.append(this.timeOrder + "/" + (deb >>>= shift) + (fin == deb ? "" : "-" + fin));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Range m = this.range.rr[i >>> 1];
            if (m != null && !m.isEmpty()) {
                s.append(" s");
                try {
                    SMoc moc = new SMoc(m);
                    s.append(moc.toASCII());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (i >= this.range.sz - 2) continue;
            s.append(' ');
        }
        return s.toString();
    }

    static final void test() throws Exception {
        STMoc.test(-1);
    }

    static final void test(int x) throws Exception {
        String[][] stringArray;
        if (x == -1) {
            stringArray = TEST;
        } else {
            String[][] stringArrayArray = new String[1][];
            stringArray = stringArrayArray;
            stringArrayArray[0] = TEST[x];
        }
        String[][] listTest = stringArray;
        StringBuilder s = new StringBuilder();
        try {
            int i = x == -1 ? 0 : x;
            for (String[] test : listTest) {
                STMoc stmoc1 = new STMoc(test[1]);
                STMoc stmoc2 = new STMoc(test[2]);
                s.append("\n" + i++ + ") " + test[0] + ":");
                s.append("\n A: " + stmoc1 + "\n B: " + stmoc2);
                STMoc stmoc4 = (STMoc)stmoc1.intersection(stmoc2);
                s.append("\n Inter: " + stmoc4);
                s.append(test[4].equals(stmoc4.toString()) ? " => OK" : " => ERROR waiting: " + test[4]);
                STMoc stmoc3 = (STMoc)stmoc1.union(stmoc2);
                s.append("\n Union: " + stmoc3);
                s.append(test[3].equals(stmoc3.toString()) ? " => OK" : " => ERROR waiting: " + test[3]);
                for (int j = 0; j < stmoc2.range.sz; j += 2) {
                    stmoc1.range.add(stmoc2.range.r[j], stmoc2.range.r[j + 1], stmoc2.range.rr[j / 2]);
                }
                s.append("\n Add  : " + stmoc1);
                s.append(test[3].equals(stmoc1.toString()) ? " => OK" : " => ERROR waiting: " + test[3]);
                s.append("\n");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println(s);
    }

    @Override
    public void writeASCII(OutputStream out) throws Exception {
        if (this.isEmpty()) {
            return;
        }
        int spaceOrder = 0;
        int timeOrder = this.getTimeOrder();
        boolean flagNL = this.getTimeRanges() > 20;
        int shift = (29 - timeOrder) * 2;
        StringBuilder res = new StringBuilder(1000);
        for (int i = 0; i < this.getTimeRanges(); ++i) {
            long deb = this.range.r[i * 2] >>> shift;
            long fin = this.range.r[i * 2 + 1] - 1L >>> shift;
            if (i > 0) {
                res.append(flagNL ? CR : " ");
            }
            res.append("t" + timeOrder + "/" + deb + (fin == deb ? "" : "-" + fin));
            res.append(flagNL ? CR : " ");
            res.append('s');
            STMoc.writeASCIIFlush(out, res, false);
            int order = Moc.writeASCII(out, this.range.rr[i], flagNL);
            if (order <= spaceOrder) continue;
            spaceOrder = order;
        }
        if (spaceOrder != this.getSpaceOrder()) {
            res.append(flagNL ? CR : " ");
            res.append("t" + timeOrder + "/ s" + this.getSpaceOrder() + "/");
            if (flagNL) {
                res.append(CR);
            }
        }
        STMoc.writeASCIIFlush(out, res, false);
    }

    @Override
    protected int writeSpecificFitsProp(OutputStream out) throws Exception {
        int n = 0;
        out.write(MocIO.getFitsLine("MOC", "TIME.SPACE", "STMOC: Time dimension first, "));
        n += 80;
        out.write(MocIO.getFitsLine("ORDERING", "RANGE29", "Range coding"));
        n += 80;
        out.write(MocIO.getFitsLine("MOCORDER", "" + this.getTimeOrder(), "Time MOC resolution"));
        n += 80;
        out.write(MocIO.getFitsLine("MOCORD_1", "" + this.getSpaceOrder(), "Space MOC resolution"));
        n += 80;
        out.write(MocIO.getFitsLine("COORDSYS", "C", "Space reference frame (C=ICRS)"));
        n += 80;
        out.write(MocIO.getFitsLine("TIMESYS", "JD", "Time ref system JD BARYCENTRIC TCB, 1 microsec order 29"));
        return n += 80;
    }

    @Override
    protected int writeSpecificData(OutputStream out) throws Exception {
        byte[] buf = new byte[8];
        int size = 0;
        for (int i = 0; i < this.range.sz; i += 2) {
            long tmin = -this.range.r[i];
            size += MocIO.writeVal(out, tmin, buf);
            long tmax = -this.range.r[i + 1];
            size += MocIO.writeVal(out, tmax, buf);
            Range m = this.range.rr[i >>> 1];
            for (int j = 0; j < m.sz; j += 2) {
                long smin = m.r[j];
                size += MocIO.writeVal(out, smin, buf);
                long smax = m.r[j + 1];
                size += MocIO.writeVal(out, smax, buf);
            }
        }
        return size;
    }

    @Override
    protected void readSpecificData(InputStream in, int naxis1, int naxis2, int nbyte, MocIO.HeaderFits header) throws Exception {
        String type = header.getStringFromHeader("MOC");
        if (type == null || type.equals("SPACETIME")) {
            this.timeOrder = header.getIntFromHeader("TORDER");
            this.spaceOrder = header.getIntFromHeader("MOCORDER");
        } else {
            this.timeOrder = header.getIntFromHeader("MOCORDER");
            this.spaceOrder = header.getIntFromHeader("MOCORD_1");
        }
        byte[] buf = new byte[naxis1 * naxis2];
        MocIO.readFully(in, buf);
        this.createMocByFits(naxis1 * naxis2 / nbyte, buf);
    }

    protected long readLong(byte[] t, int i) {
        int a = t[i] << 24 | (t[i + 1] & 0xFF) << 16 | (t[i + 2] & 0xFF) << 8 | t[i + 3] & 0xFF;
        int b = t[i + 4] << 24 | (t[i + 5] & 0xFF) << 16 | (t[i + 6] & 0xFF) << 8 | t[i + 7] & 0xFF;
        long val = (long)a << 32 | (long)b & 0xFFFFFFFFL;
        return val;
    }

    protected void createMocByFits(int nval, byte[] t) throws Exception {
        int i = 0;
        int startT = 0;
        Range m = new Range(100000);
        int k = 0;
        while (k < nval) {
            long min = this.readLong(t, i);
            long max = this.readLong(t, i + 8);
            if (min < 0L) {
                if (!m.isEmpty()) {
                    for (int j = startT; j < this.range.sz; j += 2) {
                        this.range.rr[j >>> 1] = new Range(m);
                    }
                    m.clear();
                    startT = this.range.sz;
                }
                this.range.append(-min, -max, null);
            } else {
                m.append(min, max);
            }
            k += 2;
            i += 16;
        }
        if (!m.isEmpty()) {
            for (int j = startT; j < this.range.sz; j += 2) {
                this.range.rr[j >>> 1] = m;
            }
        }
    }

    @Override
    protected int getType() {
        return 2;
    }

    public double getTimeMin() {
        if (this.isEmpty()) {
            return -1.0;
        }
        return (double)this.range.begins(0) / 8.64E10;
    }

    public double getTimeMax() {
        if (this.isEmpty()) {
            return -1.0;
        }
        return (double)this.range.ends(this.range.nranges() - 1) / 8.64E10;
    }

    @Override
    public TMoc getTimeMoc() throws Exception {
        TMoc moc = new TMoc();
        moc.range = this.range;
        moc.toMocSet();
        return moc;
    }

    public TMoc getTimeMoc(SMoc spaceMoc) throws Exception {
        if (spaceMoc == null || spaceMoc.isEmpty()) {
            return this.getTimeMoc();
        }
        TMoc moc = new TMoc();
        Range r1 = new Range();
        spaceMoc.toRangeSet();
        for (int i = 0; i < this.range.sz; i += 2) {
            Range m = this.range.rr[i >>> 1];
            if (!spaceMoc.range.overlaps(m)) continue;
            r1.append(this.range.r[i], this.range.r[i + 1]);
        }
        moc.range = r1;
        moc.toMocSet();
        return moc;
    }

    @Override
    public SMoc getSpaceMoc() throws Exception {
        return this.getSpaceMoc(-1L, Long.MAX_VALUE);
    }

    public SMoc getSpaceMoc(long tmin, long tmax) throws Exception {
        if (tmin >= tmax) {
            tmin = -1L;
            tmax = Long.MAX_VALUE;
        }
        SMoc moc = new SMoc();
        int pos = this.range.indexOf(tmin);
        if ((pos & 1) == 1) {
            ++pos;
        }
        long[] buf = new long[this.getSize()];
        int size = 0;
        for (int i = pos; i < this.range.sz && this.range.r[i] <= tmax; i += 2) {
            Range m = this.range.rr[i >>> 1];
            for (int j = 0; j < m.sz; ++j) {
                buf[size++] = m.r[j];
            }
        }
        Range range = new Range(buf, size);
        range.sortAndFix();
        moc.range = range;
        moc.toMocSet();
        return moc;
    }

    public static void main(String[] a) {
        try {
            STMoc.test(0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public Moc clone() {
        STMoc moc = new STMoc();
        moc.timeOrder = this.timeOrder;
        moc.spaceOrder = this.spaceOrder;
        moc.range = new Range2(this.range);
        return moc;
    }

    @Override
    public Range getRange() {
        return this.range;
    }
}

