/*
 * Decompiled with CFR 0.152.
 */
package cds.moc;

import cds.aladin.Coord;
import cds.aladin.Localisation;
import cds.healpix.FlatHashList;
import cds.healpix.HealpixNested;
import cds.healpix.NeighbourList;
import cds.moc.Array;
import cds.moc.Healpix;
import cds.moc.HealpixImpl;
import cds.moc.IntArray;
import cds.moc.LongArray;
import cds.moc.Moc;
import cds.moc.MocCell;
import cds.moc.MocIO;
import cds.moc.Range;
import cds.moc.STMoc;
import cds.moc.ShortArray;
import cds.moc.TMoc;
import cds.tools.pixtools.CDSHealpix;
import cds.tools.pixtools.Util;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;

public class SMoc
extends Moc {
    public static final boolean RANGE = true;
    public static final int SHORT = 0;
    public static final int INT = 1;
    public static final int LONG = 2;
    private static final int MAXADDS = 500000;
    protected String sys;
    protected int minOrder;
    protected int mocOrder;
    protected Array[] level;
    private int nOrder;
    private boolean testConsistency;
    private boolean isConsistant;
    private int currentOrder = -1;
    public Range range = null;
    private static final int MAXWORD = 20;
    private static final int MAXSIZE = 80;
    private static final double SKYAREA = Math.PI * 4 * Math.toDegrees(1.0) * Math.toDegrees(1.0);

    public static int getType(int order) {
        return order < 6 ? 0 : (order < 14 ? 1 : 2);
    }

    public SMoc() {
        this.init("C", 0, -1);
    }

    public SMoc(int mocOrder) throws Exception {
        this.init("C", 0, mocOrder);
    }

    public SMoc(int minOrder, int mocOrder) throws Exception {
        this.init("C", minOrder, mocOrder);
    }

    public SMoc(String sys, int minOrder, int mocOrder) throws Exception {
        this.init(sys, minOrder, mocOrder);
    }

    public SMoc(Moc moc) throws Exception {
        if (moc instanceof STMoc) {
            moc = ((STMoc)moc).getSpaceMoc();
        }
        this.init(moc.getSys(), 0, moc.getSpaceOrder());
        this.range = new Range(moc.getRange());
        if (this.range != null) {
            this.toMocSet();
        }
    }

    public SMoc(Range r) throws Exception {
        this();
        this.range = r;
        this.toMocSet();
    }

    public SMoc(String s) throws Exception {
        this();
        this.add(s);
    }

    public SMoc(InputStream in) throws Exception {
        this.read(in);
    }

    public SMoc(InputStream in, int mode) throws Exception {
        this();
        this.read(in, mode);
    }

    @Override
    public void clear() {
        this.init(this.sys, this.minOrder, this.mocOrder);
    }

    @Override
    public Moc clone() {
        SMoc moc = new SMoc();
        return this.clone1(moc);
    }

    protected Moc clone1(SMoc moc) {
        moc.sys = this.sys;
        moc.mocOrder = this.mocOrder;
        moc.minOrder = this.minOrder;
        moc.nOrder = this.nOrder;
        moc.testConsistency = this.testConsistency;
        moc.currentOrder = this.currentOrder;
        moc.range = this.range == null ? null : new Range(this.range);
        for (int order = 0; order < this.nOrder; ++order) {
            moc.level[order] = (Array)this.level[order].clone();
        }
        moc.property = (HashMap)this.property.clone();
        return moc;
    }

    public void setMinOrder(int minOrder) throws Exception {
        if (minOrder == this.minOrder) {
            return;
        }
        if (minOrder > 29) {
            throw new Exception("Min order exceed HEALPix library possibility (29)");
        }
        if (minOrder < 0 || this.mocOrder != -1 && minOrder > this.mocOrder) {
            throw new Exception("Min limit greater than max limit order");
        }
        this.isConsistant = false;
        this.minOrder = minOrder;
        this.setCheckConsistencyFlag(true);
    }

    @Override
    public void setTimeOrder(int order) throws Exception {
        throw new Exception("No time dimension");
    }

    @Override
    public void setSpaceOrder(int order) throws Exception {
        this.setMocOrder(order);
    }

    @Override
    public void setMocOrder(int mocOrder) throws Exception {
        if (mocOrder == this.mocOrder) {
            return;
        }
        if (mocOrder > 29) {
            throw new Exception("Moc order exceed HEALPix library possibility (29)");
        }
        if (mocOrder != -1 && mocOrder < this.minOrder) {
            throw new Exception("Max limit order smaller than min limit order");
        }
        this.property.put("MOCORDER", "" + (mocOrder == -1 ? 29 : mocOrder));
        this.mocOrder = mocOrder;
        this.isConsistant = false;
        if (this.getSize() > 0) {
            this.checkAndFix();
        }
        if (mocOrder != -1) {
            this.nOrder = mocOrder + 1;
        }
    }

    public int getMinOrder() {
        return this.minOrder;
    }

    @Override
    public int getMocOrder() {
        return this.mocOrder >= 0 ? this.mocOrder : (this.currentOrder >= 0 ? this.currentOrder : this.nOrder - 1);
    }

    @Override
    public int getMaxUsedOrder() {
        return this.nOrder - 1;
    }

    @Override
    public int getSpaceOrder() {
        return this.getMocOrder();
    }

    @Override
    public int getTimeOrder() {
        return -1;
    }

    public void setMocOrder(String mocOrder) throws Exception {
        int n = Integer.parseInt(mocOrder);
        if (n == 29) {
            n = -1;
        }
        this.setMocOrder(n);
    }

    @Override
    public String getSys() {
        return this.sys;
    }

    public void setSys(String sys) {
        this.sys = sys;
        this.initPropSys(sys);
    }

    @Override
    protected void setCurrentOrder(int order) {
        this.currentOrder = order;
    }

    @Override
    public int getSize() {
        int size = 0;
        for (int order = 0; order < this.nOrder; ++order) {
            size += this.getSize(order);
        }
        return size;
    }

    @Override
    public long getMem() {
        long mem = 0L;
        for (int order = 0; order < this.nOrder; ++order) {
            mem += this.level[order].getMem();
        }
        return mem;
    }

    public int getSize(int order) {
        return this.level[order].getSize();
    }

    public Array getArray(int order) {
        return this.level[order];
    }

    public double getAngularRes() {
        return Math.sqrt(SMoc.getPixelArea(this.getMocOrder()));
    }

    @Override
    public void setCheckConsistencyFlag(boolean flag) throws Exception {
        this.testConsistency = flag;
        if (this.testConsistency) {
            this.checkAndFix();
        }
    }

    public int getDescendantOrder(int order, long npix) {
        long pix = npix / 4L;
        int o = order - 1;
        while (o >= 0) {
            if (this.level[o].find(pix) >= 0) {
                return o;
            }
            --o;
            pix /= 4L;
        }
        return -1;
    }

    @Override
    public void add(String s) throws Exception {
        StringTokenizer st = new StringTokenizer(s, " ;,\n\r\t{}");
        while (st.hasMoreTokens()) {
            String s1 = st.nextToken();
            if (s1.length() == 0) continue;
            this.addHpix(s1);
        }
    }

    @Override
    public void add(Moc m) throws Exception {
        SMoc moc = (SMoc)m;
        if (moc.getSize() > 250000) {
            this.setCheckConsistencyFlag(false);
        }
        int nadds = 0;
        for (int order = moc.nOrder - 1; order >= 0; --order) {
            for (long npix : moc.getArray(order)) {
                if (nadds > 500000) {
                    this.checkAndFix();
                    nadds = 0;
                }
                this.add(order, npix);
                ++nadds;
            }
        }
        this.setCheckConsistencyFlag(true);
    }

    public void add(int order, long[] npixs) throws Exception {
        if (npixs.length > 250000) {
            this.setCheckConsistencyFlag(false);
        }
        int nadds = 0;
        for (long npix : npixs) {
            if (nadds > 500000) {
                this.checkAndFix();
                nadds = 0;
            }
            this.add(order, npix);
            ++nadds;
        }
        this.setCheckConsistencyFlag(true);
    }

    public void add(int order, Collection<Long> a) throws Exception {
        if (a.size() > 250000) {
            this.setCheckConsistencyFlag(false);
        }
        int nadds = 0;
        for (long npix : a) {
            if (nadds > 500000) {
                this.checkAndFix();
                nadds = 0;
            }
            this.add(order, npix);
            ++nadds;
        }
        this.setCheckConsistencyFlag(true);
    }

    public boolean add(MocCell cell) throws Exception {
        return this.add(cell.order, cell.npix);
    }

    public boolean add(HealpixImpl healpix, double alpha, double delta) throws Exception {
        int order = this.getMocOrder();
        if (order == -1) {
            return false;
        }
        long npix = healpix.ang2pix(order, alpha, delta);
        return this.add(order, npix);
    }

    public boolean add(int order, long npix) throws Exception {
        return this.add(order, npix, true);
    }

    private boolean add(int order, long npix, boolean testHierarchy) throws Exception {
        this.range = null;
        if (!this.testConsistency) {
            this.isConsistant = false;
            return this.add1(order, npix);
        }
        if (npix >= 0L) {
            if (testHierarchy) {
                if (order > this.minOrder && this.isDescendant(order, npix)) {
                    return false;
                }
                this.deleteDescendant(order, npix);
            }
            if (order > this.minOrder && this.deleteBrothers(order, npix)) {
                return this.add(order - 1, npix >>> 2, testHierarchy);
            }
        }
        return this.add1(order, npix);
    }

    private boolean deleteBrothers(int order, long me) {
        return this.level[order].deleteBrothers(me);
    }

    public void delete(String s) {
        StringTokenizer st = new StringTokenizer(s, " ;,\n\r\t");
        while (st.hasMoreTokens()) {
            this.deleteHpix(st.nextToken());
        }
    }

    public boolean delete(int order, long npix) {
        if (order >= this.nOrder) {
            return false;
        }
        this.range = null;
        return this.level[order].delete(npix);
    }

    public boolean deleteDescendant(int order, long npix) {
        this.range = null;
        long v1 = npix * 4L;
        long v2 = (npix + 1L) * 4L - 1L;
        boolean rep = false;
        int o = order + 1;
        while (o < this.nOrder) {
            rep |= this.getArray(o).delete(v1, v2);
            ++o;
            v1 *= 4L;
            v2 = (v2 + 1L) * 4L - 1L;
        }
        return rep;
    }

    public void sort() {
        for (int order = 0; order < this.nOrder; ++order) {
            this.level[order].sort();
        }
    }

    public boolean isSorted() {
        for (int order = 0; order < this.nOrder; ++order) {
            if (this.level[order].isSorted()) continue;
            return false;
        }
        return true;
    }

    public void checkAndFix() throws Exception {
        this.range = null;
        if (this.nOrder == 0 || this.isConsistant) {
            return;
        }
        this.sort();
        SMoc res = new SMoc(this.sys, this.minOrder, this.mocOrder);
        int[] p = new int[this.nOrder];
        for (int npix = 0; npix < 12; ++npix) {
            this.checkAndFix(res, p, 0, npix);
        }
        for (int order = res.nOrder - 1; order >= 0; --order) {
            Array a;
            this.level[order] = a = res.getArray(order);
        }
        this.nOrder = p.length;
        res = null;
        this.isConsistant = true;
    }

    private void checkAndFix(SMoc res, int[] p, int order, long pix) throws Exception {
        block10: {
            long mx;
            int o;
            long t = -1L;
            Array a = this.getArray(order);
            if (p[order] < a.getSize()) {
                t = a.get(p[order]);
            }
            if (t == pix) {
                res.add(order, pix, false);
                for (int o2 = order; o2 < p.length; ++o2) {
                    long mx2 = pix + 1L << (o2 - order << 1);
                    a = this.getArray(o2);
                    while (p[o2] < a.getSize() && a.get(p[o2]) < mx2) {
                        int n = o2;
                        p[n] = p[n] + 1;
                    }
                }
                return;
            }
            boolean found = false;
            for (o = order + 1; o < p.length; ++o) {
                mx = pix + 1L << (o - order << 1);
                a = this.getArray(o);
                if (p[o] >= a.getSize() || a.get(p[o]) >= mx) continue;
                found = true;
                break;
            }
            if (!found) break block10;
            if (res.mocOrder != -1 && order > res.mocOrder) {
                res.add(order, pix, false);
                for (o = order; o < p.length; ++o) {
                    mx = pix + 1L << (o - order << 1);
                    a = this.getArray(o);
                    while (p[o] < a.getSize() && a.get(p[o]) < mx) {
                        int n = o;
                        p[n] = p[n] + 1;
                    }
                }
            } else {
                for (int i = 0; i < 4; ++i) {
                    this.checkAndFix(res, p, order + 1, (pix << 2) + (long)i);
                }
            }
        }
    }

    public boolean isAscendant(int order, long npix) {
        long range = 4L;
        int o = order + 1;
        while (o < this.nOrder) {
            if (this.level[o].intersectRange(npix * range, (npix + 1L) * range - 1L)) {
                return true;
            }
            ++o;
            range *= 4L;
        }
        return false;
    }

    public boolean isDescendant(int order, long npix) {
        long pix = npix >>> 2;
        int o = order - 1;
        while (o >= this.minOrder) {
            if (this.level[o].find(pix) >= 0) {
                return true;
            }
            --o;
            pix >>>= 2;
        }
        return false;
    }

    public boolean isIn(int order, long npix) {
        return this.level[order].find(npix) >= 0;
    }

    @Override
    public void setProperty(String key, String value) throws Exception {
        if (key.equals("MOCORDER")) {
            int mocOrder = Integer.parseInt(value);
            this.setMocOrder(mocOrder);
        } else if (key.equals("COORDSYS")) {
            this.setSys(value);
        } else {
            this.property.put(key, value);
        }
    }

    public double getCoverage() {
        long area;
        long usedArea = this.getNbCells();
        for (area = this.getNbCellsFull(); area > Long.MAX_VALUE || usedArea > Long.MAX_VALUE; area /= 2L, usedArea /= 2L) {
        }
        if (area == 0L) {
            return 0.0;
        }
        return (double)usedArea / (double)area;
    }

    public long getNbCells() {
        long n = 0L;
        long sizeCell = 1L;
        int order = this.getMocOrder();
        while (order >= 0) {
            n += (long)this.getSize(order) * sizeCell;
            --order;
            sizeCell *= 4L;
        }
        return n;
    }

    public long getNbCellsFull() {
        long nside = SMoc.pow2(this.getMocOrder());
        return 12L * nside * nside;
    }

    @Override
    public Iterator<MocCell> iterator() {
        return new HpixListIterator();
    }

    public Iterator<Long> pixelIterator() {
        this.sort();
        return new PixelIterator();
    }

    @Override
    public void trim() {
        for (int order = 0; order < this.nOrder; ++order) {
            this.level[order].trim();
        }
    }

    public String todebug() {
        StringBuffer s = new StringBuffer();
        double coverage = (double)((int)(this.getCoverage() * 10000.0)) / 100.0;
        s.append("mocOrder=" + this.getMocOrder() + " [" + this.minOrder + ".." + this.getMaxUsedOrder() + "] mem=" + this.getMem() / 1024L + "KB size=" + this.getSize() + " coverage=" + coverage + "%" + (this.isSorted() ? " sorted" : "") + (this.isConsistant ? " consistant" : "") + "\n");
        long oOrder = -1L;
        Iterator<MocCell> it = this.iterator();
        for (int i = 0; it.hasNext() && i < 80; ++i) {
            MocCell x = it.next();
            if ((long)x.order != oOrder) {
                s.append(" " + x.order + "/");
            } else {
                s.append(",");
            }
            s.append(x.npix);
            oOrder = x.order;
        }
        if (it.hasNext()) {
            s.append("...\n");
        }
        for (int order = 0; order < this.nOrder; ++order) {
            s.append(" " + order + ":" + this.level[order].getSize());
        }
        return s.toString();
    }

    public String toJSON() {
        StringBuilder res = new StringBuilder(this.getSize() * 8);
        int order = -1;
        boolean flagNL = this.getSize() > 20;
        boolean first = true;
        int sizeLine = 0;
        res.append("{");
        for (MocCell c : this) {
            if (res.length() > 0) {
                if (c.order != order) {
                    if (!first) {
                        res.append("],");
                    }
                    if (flagNL) {
                        res.append("\n");
                        sizeLine = 0;
                    } else {
                        res.append(" ");
                    }
                } else {
                    int n = (c.npix + "").length();
                    if (flagNL && n + sizeLine > 80) {
                        res.append(",\n ");
                        sizeLine = 3;
                    } else {
                        res.append(',');
                        ++sizeLine;
                    }
                }
                first = false;
            }
            String s = c.order != order ? "\"" + c.order + "\":[" + c.npix : c.npix + "";
            res.append(s);
            sizeLine += s.length();
            order = c.order;
        }
        int n = res.length();
        if (first) {
            res.append("}");
        } else if (res.charAt(n - 1) == ',') {
            res.replace(n - 1, n - 1, "]" + (flagNL ? "\n" : " ") + "}");
        } else {
            res.append("]" + (flagNL ? "\n" : " ") + "}");
        }
        return res.toString();
    }

    @Override
    public Range getRange() {
        this.toRangeSet();
        return this.range;
    }

    public void toRangeSet() {
        this.toRangeSet(false);
    }

    public void toRangeSet(boolean force) {
        if (!force && this.range != null) {
            return;
        }
        this.sort();
        this.range = new Range(this.getSize());
        Range rtmp = new Range();
        for (int order = 0; order < this.nOrder; ++order) {
            rtmp.clear();
            int shift = 2 * (29 - order);
            for (long npix : this.getArray(order)) {
                rtmp.append(npix << shift, npix + 1L << shift);
            }
            if (rtmp.isEmpty()) continue;
            this.range = this.range.union(rtmp);
        }
    }

    @Override
    public void toMocSet() throws Exception {
        this.toMocSetR();
    }

    public void toMocSetR() throws Exception {
        this.clear();
        this.setCheckConsistencyFlag(false);
        Range r2 = new Range(this.getRange());
        Range r3 = new Range();
        for (int o = 0; o <= 29 && !r2.isEmpty(); ++o) {
            int shift = 2 * (29 - o);
            long ofs = (1L << shift) - 1L;
            r3.clear();
            for (int i = 0; i < r2.sz; i += 2) {
                long a = r2.r[i] + ofs >>> shift;
                long b = r2.r[i + 1] >>> shift;
                if (a >= b) continue;
                r3.append(a << shift, b << shift);
                long c = a;
                while (c < b) {
                    this.add1(o, c++);
                }
            }
            if (r3.isEmpty()) continue;
            r2 = r2.difference(r3);
        }
    }

    public void toMocSetFX() throws Exception {
        this.clear();
        this.setCheckConsistencyFlag(false);
        Range range = new Range(this.getRange());
        for (int i = 0; i < range.sz; i += 2) {
            int twiceDd;
            long l = range.r[i];
            long h = range.r[i + 1];
            do {
                long len = h - l;
                assert (len > 0L);
                int ddMaxFromLen = 63 - Long.numberOfLeadingZeros(len) >> 1;
                int ddMaxFromLow = Long.numberOfTrailingZeros(l) >> 1;
                int dd = Math.min(29, Math.min(ddMaxFromLen, ddMaxFromLow));
                twiceDd = dd << 1;
                this.add1(29 - dd, l >> twiceDd);
            } while ((l += 1L << twiceDd) < h);
        }
    }

    public static void main(String[] b) {
        try {
            long tot = 0L;
            SMoc moc = new SMoc();
            moc.read("C:/Users/Pierre/Documents/Fits et XML/CDS-P-SDSS9-color-alt_MOC.fits");
            System.out.println("  Moc: " + moc.todebug());
            int N = 10;
            for (int i = 0; i < N; ++i) {
                moc.read("C:/Users/Pierre/Documents/Fits et XML/CDS-P-SDSS9-color-alt_MOC.fits");
                long t = cds.tools.Util.getTime();
                moc.accretion();
                long d = cds.tools.Util.getTime() - t;
                System.out.println("  Moc: " + moc.todebug() + " in " + d + "ms");
                tot += d;
            }
            System.out.println("Moyenne : " + tot / (long)N + "ms");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean contains(long npix) {
        this.toRangeSet();
        return this.range.contains(npix);
    }

    public boolean isIntersecting(int order, long npix) {
        if (this.range != null) {
            return this.range.contains(npix << (29 - order << 1));
        }
        return this.isIn(order, npix) || this.isAscendant(order, npix) || this.isDescendant(order, npix);
    }

    @Override
    public boolean isIntersecting(Moc moc) {
        if (this.isFull() && !moc.isEmpty() || moc.isFull() && !this.isEmpty()) {
            return true;
        }
        if (this.range != null && ((SMoc)moc).range != null) {
            return this.range.contains(((SMoc)moc).range);
        }
        this.sort();
        ((SMoc)moc).sort();
        for (int o = 0; o < this.nOrder; ++o) {
            Array a = ((SMoc)moc).getArray(o);
            if (!this.isInTree(o, a)) continue;
            return true;
        }
        return false;
    }

    public boolean isIncluding(SMoc moc) {
        if (this.isFull()) {
            return true;
        }
        for (MocCell c : moc) {
            if (this.isIn(c.order, c.npix) || this.isDescendant(c.order, c.npix)) continue;
            return false;
        }
        return true;
    }

    @Override
    public SMoc getSpaceMoc() throws Exception {
        return this;
    }

    @Override
    public TMoc getTimeMoc() throws Exception {
        throw new Exception("No temporal dimension");
    }

    @Override
    public Moc union(Moc moc) throws Exception {
        return this.operation(moc.getSpaceMoc(), 0);
    }

    @Override
    public Moc intersection(Moc moc) throws Exception {
        return this.operation(moc.getSpaceMoc(), 1);
    }

    @Override
    public Moc subtraction(Moc moc) throws Exception {
        return this.operation(moc.getSpaceMoc(), 2);
    }

    public Moc difference(Moc moc) throws Exception {
        SMoc m = moc.getSpaceMoc();
        Moc inter = this.intersection(m);
        Moc union = this.union(m);
        return union.subtraction(inter);
    }

    public SMoc complement() throws Exception {
        SMoc allsky = new SMoc();
        allsky.add("0/0-11");
        allsky.toRangeSet();
        this.toRangeSet();
        SMoc res = new SMoc(this.sys, this.minOrder, this.mocOrder);
        res.range = allsky.range.difference(this.range);
        res.toMocSet();
        return res;
    }

    protected SMoc operation(SMoc moc, int op) throws Exception {
        this.testCompatibility(moc);
        this.toRangeSet();
        moc.toRangeSet();
        int min = Math.min(this.minOrder, moc.minOrder);
        int max = Math.max(this.getMocOrder(), moc.getMocOrder());
        SMoc res = new SMoc(this.sys, min, max);
        switch (op) {
            case 0: {
                res.range = this.range.union(moc.range);
                break;
            }
            case 1: {
                res.range = this.range.intersection(moc.range);
                break;
            }
            case 2: {
                res.range = this.range.difference(moc.range);
            }
        }
        res.toMocSet();
        return res;
    }

    @Override
    public boolean isFull() {
        return (long)this.getSize(this.minOrder) == 12L * SMoc.pow2(this.minOrder) * SMoc.pow2(this.minOrder);
    }

    @Override
    public boolean isSpace() {
        return true;
    }

    @Override
    public boolean isTime() {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.getSize() == 0;
    }

    public boolean equals(Object moc) {
        if (this == moc) {
            return true;
        }
        try {
            int o;
            SMoc m = (SMoc)moc;
            this.testCompatibility(m);
            if (m.nOrder != this.nOrder) {
                return false;
            }
            for (o = 0; o < this.nOrder; ++o) {
                if (this.getSize(o) == m.getSize(o)) continue;
                return false;
            }
            for (o = 0; o < this.nOrder; ++o) {
                if (this.getArray(o).equals(m.getArray(o))) continue;
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public SMoc queryCell(int order, long npix) throws Exception {
        return (SMoc)this.intersection(new SMoc(order + "/" + npix));
    }

    public void setPixLevel(int order, long[] val) throws Exception {
        if (SMoc.getType(order) != 2) {
            throw new Exception("The order " + order + " requires long[] array");
        }
        this.level[order] = new LongArray(val);
        if (this.nOrder < order + 1) {
            this.nOrder = order + 1;
        }
    }

    public void setPixLevel(int order, int[] val) throws Exception {
        if (SMoc.getType(order) != 1) {
            throw new Exception("The order " + order + " requires int[] array");
        }
        this.level[order] = new IntArray(val);
        if (this.nOrder < order + 1) {
            this.nOrder = order + 1;
        }
    }

    public void setPixLevel(int order, short[] val) throws Exception {
        if (SMoc.getType(order) != 0) {
            throw new Exception("The order " + order + " requires short[] array");
        }
        this.level[order] = new ShortArray(val);
        if (this.nOrder < order + 1) {
            this.nOrder = order + 1;
        }
    }

    public long[] getPixLevel(int order) {
        int size = this.getSize(order);
        long[] lev = new long[size];
        if (size == 0) {
            return lev;
        }
        Array a = this.level[order];
        for (int i = 0; i < size; ++i) {
            lev[i] = a.get(i);
        }
        return lev;
    }

    @Override
    public void read(String filename) throws Exception {
        new MocIO(this).read(filename);
    }

    @Override
    public void read(String filename, int mode) throws Exception {
        new MocIO(this).read(filename, mode);
    }

    @Override
    public void read(InputStream in) throws Exception {
        new MocIO(this).read(in);
    }

    @Override
    public void read(InputStream in, int mode) throws Exception {
        new MocIO(this).read(in, mode);
    }

    @Override
    public void readASCII(InputStream in) throws Exception {
        new MocIO(this).read(in, 2);
    }

    @Override
    public void readJSON(InputStream in) throws Exception {
        new MocIO(this).read(in, 1);
    }

    @Override
    public void readFits(InputStream in) throws Exception {
        new MocIO(this).read(in, 0);
    }

    @Override
    public void write(String filename) throws Exception {
        this.check();
        new MocIO(this).write(filename);
    }

    @Override
    public void write(String filename, int mode) throws Exception {
        this.check();
        new MocIO(this).write(filename, mode);
    }

    @Override
    public void write(OutputStream out, int mode) throws Exception {
        this.check();
        new MocIO(this).write(out, mode);
    }

    @Override
    public void writeJSON(OutputStream out) throws Exception {
        this.check();
        new MocIO(this).writeJSON(out);
    }

    @Override
    public void writeFits(OutputStream out) throws Exception {
        this.writeFITS(out);
    }

    @Override
    public void writeFITS(OutputStream out) throws Exception {
        this.check();
        new MocIO(this).writeFits(out);
    }

    @Override
    protected int writeSpecificFitsProp(OutputStream out) throws Exception {
        int n = 0;
        out.write(MocIO.getFitsLine("TTYPE1", "UNIQ", "UNIQ pixel number"));
        n += 80;
        out.write(MocIO.getFitsLine("PIXTYPE", "HEALPIX", "HEALPix magic code"));
        n += 80;
        out.write(MocIO.getFitsLine("ORDERING", "NUNIQ", "NUNIQ coding method"));
        n += 80;
        out.write(MocIO.getFitsLine("COORDSYS", "" + this.getSys(), "reference frame (C=ICRS)"));
        n += 80;
        out.write(MocIO.getFitsLine("MOC", "SPACE", "Spacial MOC"));
        n += 80;
        out.write(MocIO.getFitsLine("MOCORDER", "" + this.getMocOrder(), "MOC resolution (best order)"));
        return n += 80;
    }

    @Override
    protected int writeSpecificData(OutputStream out) throws Exception {
        if (this.getSize() <= 0) {
            return 0;
        }
        int nbytes = this.getType() == 2 ? 8 : 4;
        byte[] buf = new byte[nbytes];
        int size = 0;
        for (int order = 0; order < this.nOrder; ++order) {
            int n = this.getSize(order);
            if (n == 0) continue;
            Array a = this.getArray(order);
            for (int i = 0; i < n; ++i) {
                long val = SMoc.hpix2uniq(order, a.get(i));
                size += MocIO.writeVal(out, val, buf);
            }
        }
        return size;
    }

    @Override
    protected void readSpecificData(InputStream in, int naxis1, int naxis2, int nbyte, MocIO.HeaderFits header) throws Exception {
        byte[] buf = new byte[naxis1 * naxis2];
        MocIO.readFully(in, buf);
        this.createUniq(naxis1 * naxis2 / nbyte, nbyte, buf);
    }

    protected void createUniq(int nval, int nbyte, byte[] t) throws Exception {
        int i = 0;
        long[] hpix = null;
        for (int k = 0; k < nval; ++k) {
            long val;
            int a = t[i++] << 24 | (t[i++] & 0xFF) << 16 | (t[i++] & 0xFF) << 8 | t[i++] & 0xFF;
            if (nbyte == 4) {
                val = a;
            } else {
                int b = t[i++] << 24 | (t[i++] & 0xFF) << 16 | (t[i++] & 0xFF) << 8 | t[i++] & 0xFF;
                val = (long)a << 32 | (long)b & 0xFFFFFFFFL;
            }
            hpix = SMoc.uniq2hpix(val, hpix);
            this.add((int)hpix[0], hpix[1]);
        }
    }

    @Override
    protected int getType() {
        return SMoc.getType(this.getMaxUsedOrder());
    }

    protected void init(String sys, int minOrder, int mocOrder) {
        this.sys = sys;
        this.minOrder = minOrder;
        this.mocOrder = mocOrder;
        this.property = new HashMap();
        if (mocOrder != -1) {
            this.property.put("MOCORDER", mocOrder + "");
        }
        this.initPropSys(sys);
        this.property.put("MOCTOOL", "CDSjavaAPI-7.0");
        this.property.put("DATE", String.format("%tFT%<tR", new Date()));
        this.testConsistency = true;
        this.isConsistant = true;
        this.level = new Array[30];
        for (int order = 0; order < 30; ++order) {
            int type = SMoc.getType(order);
            int bloc = (1 + order) * 10;
            Array a = type == 0 ? new ShortArray(bloc) : (type == 1 ? new IntArray(bloc) : new LongArray(bloc));
            this.level[order] = a;
        }
    }

    protected void initPropSys(String sys) {
        this.property.put("COORDSYS", sys);
    }

    protected boolean add1(int order, long npix) throws Exception {
        if (order < this.minOrder) {
            return this.add2(order, npix, this.minOrder);
        }
        if (this.mocOrder != -1 && order > this.mocOrder) {
            return this.add(this.mocOrder, npix >>> (order - this.mocOrder << 1));
        }
        if (order > 29) {
            throw new Exception("Out of MOC order");
        }
        if (order >= this.nOrder) {
            this.nOrder = order + 1;
        }
        if (npix < 0L) {
            return false;
        }
        return this.level[order].add(npix, this.testConsistency);
    }

    private boolean add2(int orderSrc, long npix, int orderTrg) throws Exception {
        if (orderTrg > 29) {
            throw new Exception("Out of MOC order");
        }
        if (orderTrg >= this.nOrder) {
            this.nOrder = orderTrg + 1;
        }
        if (npix < 0L) {
            return false;
        }
        long fct = SMoc.pow2(orderTrg - orderSrc);
        fct *= fct;
        npix *= fct;
        boolean rep = false;
        int i = 0;
        while ((long)i < fct) {
            rep |= this.level[orderTrg].add(npix + (long)i, this.testConsistency);
            ++i;
        }
        return rep;
    }

    @Override
    protected void addHpix(String s) throws Exception {
        int j;
        if (s == null) {
            return;
        }
        int i = s.indexOf(47);
        if (i < 0) {
            i = s.indexOf(58);
        }
        if (i > 0) {
            String s1 = this.unQuote(s.substring(0, i));
            if (s1.charAt(0) == 's' || s1.charAt(0) == 't') {
                s1 = s1.substring(1);
            }
            this.currentOrder = Integer.parseInt(s1);
        }
        if ((j = s.indexOf(45, i + 1)) < 0) {
            String s1 = this.unBracket(s.substring(i + 1));
            long npix = s1.trim().length() == 0 ? -1L : Long.parseLong(s1);
            this.add(this.currentOrder, npix);
        } else {
            long startIndex = Long.parseLong(s.substring(i + 1, j));
            long endIndex = Long.parseLong(s.substring(j + 1));
            if (endIndex - startIndex > 10L) {
                this.addRange(this.currentOrder, startIndex, endIndex);
            } else {
                for (long k = startIndex; k <= endIndex; ++k) {
                    this.add(this.currentOrder, k);
                }
            }
        }
    }

    private void addRange(int order, long start, long end) throws Exception {
        int shift = (29 - order) * 2;
        end = end + 1L << shift;
        this.toRangeSet();
        this.range.add(start <<= shift, end);
        this.toMocSet();
    }

    private String unQuote(String s) {
        int n = s.length();
        if (n > 2 && s.charAt(0) == '\"' && s.charAt(n - 1) == '\"') {
            return s.substring(1, n - 1);
        }
        return s;
    }

    private String unBracket(String s) {
        int n = s.length();
        if (n < 1) {
            return s;
        }
        int o1 = s.charAt(0) == '[' ? 1 : 0;
        int o2 = s.charAt(n - 1) == ']' ? n - 1 : n;
        return s.substring(o1, o2);
    }

    private void deleteHpix(String s) {
        int j;
        int i = s.indexOf(47);
        if (i > 0) {
            this.currentOrder = Integer.parseInt(s.substring(0, i));
        }
        if ((j = s.indexOf(45, i + 1)) < 0) {
            this.delete(this.currentOrder, Integer.parseInt(s.substring(i + 1)));
        } else {
            int startIndex = Integer.parseInt(s.substring(i + 1, j));
            int endIndex = Integer.parseInt(s.substring(j + 1));
            for (int k = startIndex; k <= endIndex; ++k) {
                this.delete(this.currentOrder, k);
            }
        }
    }

    @Override
    public void check() throws Exception {
        if (!this.testConsistency) {
            this.checkAndFix();
        } else {
            this.sort();
        }
    }

    @Override
    public void accretion() throws Exception {
        this.accretion(this.getMocOrder());
    }

    public void accretion(int order) throws Exception {
        this.toRangeSet();
        SMoc m = new SMoc(this);
        m.setCheckConsistencyFlag(false);
        int n = 0;
        int o = -1;
        HealpixNested h = null;
        for (MocCell p : this) {
            if (o != p.order) {
                h = cds.healpix.Healpix.getNested(p.order);
                o = p.order;
            }
            long[] neibs = this.externalNeighbours(h, p.order, p.npix, order);
            long nside = SMoc.pow2(order - p.order);
            int shift = order - p.order << 1;
            for (int i = 0; i < neibs.length; ++i) {
                long neib = neibs[i];
                if (this.isIntersecting(order, neib)) {
                    if (nside <= 2L || (long)i % (nside + 1L) != 1L || !this.isIn(p.order, neib >>> shift)) continue;
                    i = (int)((long)i + (nside - 1L));
                    continue;
                }
                m.add1(order, neib);
                if (++n != 100000) continue;
                m.checkAndFix();
                n = 0;
            }
        }
        m.setCheckConsistencyFlag(true);
        m.clone1(this);
    }

    private long[] externalNeighbours(HealpixNested h, int order, long npix, int o) throws Exception {
        int deltaDepth = o - order;
        if (deltaDepth == 0) {
            NeighbourList nl = h.neighbours(npix);
            long[] n = new long[nl.size()];
            nl.arraycopy(0, n, 0, n.length);
            return n;
        }
        FlatHashList res = h.externalEdges(npix, deltaDepth);
        long[] neib = new long[res.size()];
        res.arraycopy(0, neib, 0, neib.length);
        return neib;
    }

    private static long[] getVoisins(int order, SMoc moc, int maxOrder, long npix) throws Exception {
        long[] voisins = new long[8];
        long[] neib = CDSHealpix.neighbours(order, npix);
        int i = 0;
        int j = 0;
        while (i < voisins.length) {
            voisins[i] = moc.isIntersecting(maxOrder, neib[j]) ? neib[j] : -1L;
            ++i;
            ++j;
        }
        return voisins;
    }

    private long[] getVoisinsSameOrder(int order, SMoc moc, int maxOrder, long npix) throws Exception {
        long[] voisins = new long[4];
        long[] neib = CDSHealpix.neighbours(order, npix);
        int i = 0;
        int j = 0;
        while (i < voisins.length) {
            voisins[i] = moc.isIn(maxOrder, neib[j]) ? neib[j] : -1L;
            ++i;
            j += 2;
        }
        return voisins;
    }

    protected void testCompatibility(SMoc moc) throws Exception {
        if (this.getSys().charAt(0) != moc.getSys().charAt(0)) {
            throw new Exception("Incompatible MOC coordsys");
        }
    }

    private int strategie(int size1, int size2) {
        if (size1 == 0 || size2 == 0) {
            return 0;
        }
        double m1 = (double)size1 * (1.0 + Math.log(size2) / Math.log(2.0));
        double m2 = (double)size2 * (1.0 + Math.log(size1) / Math.log(2.0));
        double m3 = size1 + size2;
        if (m1 < m2 && m1 < m3) {
            return 1;
        }
        if (m2 < m1 && m2 < m3) {
            return 2;
        }
        return 3;
    }

    private boolean isIn(int order, Array a) {
        Array a1 = this.level[order];
        Array a2 = a;
        int size2 = a2.getSize();
        int size1 = a1.getSize();
        if (!a1.intersectRange(a2.get(0), a2.get(size2 - 1))) {
            return false;
        }
        switch (this.strategie(size1, size2)) {
            case 0: {
                return false;
            }
            case 1: {
                for (long x : a1) {
                    if (a2.find(x) < 0) continue;
                    return true;
                }
                return false;
            }
            case 2: {
                for (long x : a2) {
                    if (a1.find(x) < 0) continue;
                    return true;
                }
                return false;
            }
        }
        boolean incr1 = true;
        long x1 = a1.get(0);
        long x2 = a2.get(0);
        int i1 = 0;
        int i2 = 0;
        while (i1 < size1 && i2 < size2) {
            if (incr1) {
                x1 = a1.get(i1);
            } else {
                x2 = a2.get(i2);
            }
            if (x1 == x2) {
                return true;
            }
            boolean bl = incr1 = x1 < x2;
            if (incr1) {
                ++i1;
                continue;
            }
            ++i2;
        }
        return false;
    }

    private boolean isAscendant(int order, Array a) {
        long range = 4L;
        int o = order + 1;
        while (o < this.nOrder) {
            Array a1 = this.level[o];
            Array a2 = a;
            int size2 = a2.getSize();
            int size1 = a1.getSize();
            if (a1.intersectRange(a2.get(0) * range, (a2.get(size2 - 1) + 1L) * range - 1L)) {
                switch (this.strategie(size1, size2)) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        long onpix = -1L;
                        for (long x : a1) {
                            long npix = x / range;
                            if (npix == onpix) continue;
                            if (a2.find(npix) >= 0) {
                                return true;
                            }
                            onpix = npix;
                        }
                        break;
                    }
                    case 2: {
                        for (long pix : a2) {
                            if (!a1.intersectRange(pix * range, (pix + 1L) * range - 1L)) continue;
                            return true;
                        }
                        break;
                    }
                    default: {
                        boolean incr1 = true;
                        long x1 = a1.get(0);
                        long x2 = a2.get(0) * range;
                        long x3 = (a2.get(0) + 1L) * range - 1L;
                        int i1 = 0;
                        int i2 = 0;
                        while (i1 < size1 && i2 < size2) {
                            if (incr1) {
                                x1 = a1.get(i1);
                            } else {
                                x2 = a2.get(i2) * range;
                                x3 = (a2.get(i2) + 1L) * range - 1L;
                            }
                            if (x2 <= x1 && x1 <= x3) {
                                return true;
                            }
                            boolean bl = incr1 = x1 < x3;
                            if (incr1) {
                                ++i1;
                                continue;
                            }
                            ++i2;
                        }
                        break block0;
                    }
                }
            }
            ++o;
            range *= 4L;
        }
        return false;
    }

    private boolean isDescendant(int order, Array a) {
        long range = 4L;
        int o = order - 1;
        while (o >= 0) {
            Array a1 = this.level[o];
            Array a2 = a;
            int size2 = a2.getSize();
            int size1 = a1.getSize();
            if (a1.intersectRange(a2.get(0) / range, a2.get(size2 - 1) / range)) {
                switch (this.strategie(size1, size2)) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        for (long x : a1) {
                            if (!a2.intersectRange(x * range, (x + 1L) * range - 1L)) continue;
                            return true;
                        }
                        break;
                    }
                    case 2: {
                        long onpix = -1L;
                        for (long x : a2) {
                            long npix = x / range;
                            if (npix == onpix) continue;
                            if (a1.find(npix) >= 0) {
                                return true;
                            }
                            onpix = npix;
                        }
                        break;
                    }
                    default: {
                        boolean incr1 = true;
                        long x1 = a1.get(0);
                        long x2 = a2.get(0) / range;
                        int i1 = 0;
                        int i2 = 0;
                        while (i1 < size1 && i2 < size2) {
                            if (incr1) {
                                x1 = a1.get(i1);
                            } else {
                                x2 = a2.get(i2) / range;
                            }
                            if (x1 == x2) {
                                return true;
                            }
                            boolean bl = incr1 = x1 < x2;
                            if (incr1) {
                                ++i1;
                                continue;
                            }
                            ++i2;
                        }
                        break block0;
                    }
                }
            }
            --o;
            range *= 4L;
        }
        return false;
    }

    private boolean isInTree(int order, Array a) {
        if (a == null || a.getSize() == 0) {
            return false;
        }
        if (a.getSize() == 1) {
            return this.isIntersecting(order, a.get(0));
        }
        return this.isIn(order, a) || this.isAscendant(order, a) || this.isDescendant(order, a);
    }

    public static double getPixelArea(int order) {
        if (order < 0) {
            return SKYAREA;
        }
        long nside = SMoc.pow2(order);
        long npixels = 12L * nside * nside;
        return SKYAREA / (double)npixels;
    }

    public static SMoc convertTo(SMoc moc, String coordSys) throws Exception {
        int frameSrc;
        if (coordSys.equals(moc.getSys())) {
            return moc;
        }
        char a = moc.getSys().charAt(0);
        char b = coordSys.charAt(0);
        int n = a == 'G' ? 3 : (frameSrc = a == 'E' ? 2 : 0);
        int frameDst = b == 'G' ? 3 : (b == 'E' ? 2 : 0);
        Healpix hpx = new Healpix();
        int order = moc.getMaxUsedOrder();
        SMoc moc1 = new SMoc(coordSys, moc.getMinOrder(), moc.getMocOrder());
        moc1.setCheckConsistencyFlag(false);
        long onpix1 = -1L;
        Iterator<Long> it = moc.pixelIterator();
        while (it.hasNext()) {
            long npix = it.next();
            for (int i = 0; i < 4; ++i) {
                double[] coo = hpx.pix2ang(order + 1, (npix << 2) + (long)i);
                Coord c = new Coord(coo[0], coo[1]);
                c = Localisation.frameToFrame(c, frameSrc, frameDst);
                long npix1 = hpx.ang2pix(order + 1, c.al, c.del);
                if (npix1 == onpix1) continue;
                onpix1 = npix1;
                moc1.add(order, npix1 >>> 2);
            }
        }
        moc1.setCheckConsistencyFlag(true);
        return moc1;
    }

    static class Bord
    implements Iterator<Long> {
        int nside;
        int bord;
        int i;

        public Bord(int nside) {
            this.nside = nside;
            this.i = 0;
            this.bord = 0;
        }

        @Override
        public boolean hasNext() {
            if (this.nside < 2 && this.i > 0) {
                return false;
            }
            return this.bord < 3 || this.bord == 3 && this.i < this.nside - 1;
        }

        @Override
        public Long next() {
            long res;
            long l = this.bord == 0 ? Util.getHpxNestedNumber(0, this.i) : (this.bord == 1 ? Util.getHpxNestedNumber(this.i, this.nside - 1) : (res = this.bord == 2 ? Util.getHpxNestedNumber(this.nside - 1, this.nside - this.i - 1) : Util.getHpxNestedNumber(this.nside - this.i - 1, 0)));
            if (++this.i >= this.nside) {
                ++this.bord;
                this.i = 1;
            }
            return res;
        }
    }

    private class PixelIterator
    implements Iterator<Long> {
        private boolean ready = false;
        private long current;
        private int order = -1;
        private long indice = 0L;
        private long nb = 0L;
        private long currentTete;
        private boolean hasNext = true;
        private int[] p = new int[SMoc.this.getMocOrder() + 1];

        private PixelIterator() {
        }

        @Override
        public boolean hasNext() {
            this.goNext();
            return this.hasNext;
        }

        @Override
        public Long next() {
            if (!this.hasNext()) {
                return null;
            }
            this.ready = false;
            return this.current;
        }

        @Override
        public void remove() {
        }

        private void goNext() {
            if (this.ready) {
                return;
            }
            if (this.indice == this.nb) {
                long min = Long.MAX_VALUE;
                long fct = 1L;
                long tete = -1L;
                int mocOrder = SMoc.this.getMocOrder();
                this.order = -1;
                int o = mocOrder;
                while (o >= SMoc.this.minOrder) {
                    Array a = SMoc.this.level[o];
                    if (a != null) {
                        long l = tete = this.p[o] < a.getSize() ? a.get(this.p[o]) * fct : -1L;
                        if (tete != -1L && tete < min) {
                            min = tete;
                            this.order = o;
                            this.nb = fct;
                        }
                    }
                    --o;
                    fct *= 4L;
                }
                if (this.order == -1) {
                    this.hasNext = false;
                    this.ready = true;
                    return;
                }
                this.currentTete = min;
                this.indice = 0L;
            }
            this.current = new Long(this.currentTete + this.indice);
            ++this.indice;
            if (this.indice == this.nb) {
                int n = this.order;
                this.p[n] = this.p[n] + 1;
            }
            this.ready = true;
        }
    }

    private class HpixListIterator
    implements Iterator<MocCell> {
        private int currentOrder = 0;
        private int indice = -1;
        private boolean ready = false;

        private HpixListIterator() {
        }

        @Override
        public boolean hasNext() {
            this.goNext();
            return this.currentOrder < SMoc.this.nOrder;
        }

        @Override
        public MocCell next() {
            if (!this.hasNext()) {
                return null;
            }
            this.ready = false;
            Array a = SMoc.this.level[this.currentOrder];
            return new MocCell(this.currentOrder, a.get(this.indice));
        }

        @Override
        public void remove() {
        }

        private void goNext() {
            if (this.ready) {
                return;
            }
            ++this.indice;
            while (this.currentOrder < SMoc.this.nOrder && this.indice >= SMoc.this.getSize(this.currentOrder)) {
                ++this.currentOrder;
                this.indice = 0;
            }
            this.ready = true;
        }
    }
}

