/*
 * Decompiled with CFR 0.152.
 */
package cds.moc;

import cds.moc.Range;

public class Range2
extends Range {
    public Range[] rr;
    private static final int REMOVE = 0;
    private static final int UNION = 1;
    private static final int INTER = 2;
    private static final int SUBTR = 3;

    public Range2() {
        this(4);
    }

    public Range2(int cap) {
        super(cap);
        this.rr = new Range[cap];
    }

    public Range2(Range2 other) {
        super(other);
        int n = other.sz >>> 1;
        this.rr = new Range[n];
        for (int i = 0; i < n; ++i) {
            this.rr[i] = new Range(other.rr[i]);
        }
    }

    @Override
    public void resize(int newsize) {
        super.resize(newsize);
        Range[] nSpaceRangeArray = new Range[newsize];
        System.arraycopy(this.rr, 0, nSpaceRangeArray, 0, this.sz / 2);
        this.rr = nSpaceRangeArray;
    }

    public Range2 degrade(int shift1, int shift2) {
        if (shift1 == 0 && shift2 == 0) {
            return new Range2(this);
        }
        Range2 r1 = new Range2(this.sz);
        long mask = -1L << shift1;
        for (int i = 0; i < this.sz; i += 2) {
            long a = this.r[i] & mask;
            long b = (this.r[i + 1] - 1L >>> shift1) + 1L << shift1;
            Range r = this.rr[i >>> 1].degrade(shift2);
            r1.append(a, b, r);
        }
        r1.trimIfTooLarge();
        return r1;
    }

    @Override
    public Range2 degrade(int shift) {
        return this.degrade(shift, 0);
    }

    public void append(long a, long b, Range m) {
        if (a >= b) {
            return;
        }
        if (this.sz > 0 && a <= this.r[this.sz - 1]) {
            if (a < this.r[this.sz - 2]) {
                throw new IllegalArgumentException("bad append operation");
            }
            if (b > this.r[this.sz - 1] && (this.sz < 2 || this.sz >= 2 && Range2.mocEquals(this.rr[(this.sz >>> 1) - 1], m))) {
                this.r[this.sz - 1] = b;
                return;
            }
        }
        this.ensureCapacity(this.sz + 2);
        this.rr[this.sz >>> 1] = m;
        this.r[this.sz] = a;
        this.r[this.sz + 1] = b;
        this.sz += 2;
    }

    public void append(Range2 other) {
        for (int i = 0; i < other.sz; i += 2) {
            this.append(other.r[i], other.r[i + 1], other.rr[i >>> 1]);
        }
    }

    public void push(long min, long max, Range m) {
        if (this.sz >= 2 && this.r[this.sz - 2] == min && this.r[this.sz - 1] == max) {
            this.rr[this.sz - 2 >>> 1].add(m);
        } else {
            this.ensureCapacity(this.sz + 2);
            this.r[this.sz] = min;
            this.r[this.sz + 1] = max;
            if (m != null) {
                this.rr[this.sz >>> 1] = m;
            }
            this.sz += 2;
        }
    }

    private void push(long v, Range m) {
        this.ensureCapacity(this.sz + 1);
        this.r[this.sz] = v;
        if (m != null) {
            this.rr[this.sz >>> 1] = m;
        }
        ++this.sz;
    }

    @Override
    public void sortAndFix() {
        System.err.println("No yet implemented");
    }

    private static Range2 operation(Range2 a, Range2 b, int op) {
        boolean inb;
        boolean ina;
        int ib;
        int ia;
        Range2 res = new Range2();
        Range oldm = null;
        if (op == 2 && a.sz > 0 && b.sz > 0) {
            for (ia = a.indexOf(b.r[0]); ia > 0 && a.r[ia] == a.r[ia - 1]; --ia) {
            }
            if (ia < 0) {
                ia = 0;
            }
            for (ib = b.indexOf(a.r[0]); ib > 0 && b.r[ib] == b.r[ib - 1]; --ib) {
            }
            if (ib < 0) {
                ib = 0;
            }
            ina = (ia & 1) != 0 || ia >= a.sz;
            inb = (ib & 1) != 0 || ib >= b.sz;
        } else {
            ib = 0;
            ia = 0;
            inb = false;
            ina = false;
        }
        boolean runa = ia != a.sz;
        boolean runb = ib != b.sz;
        boolean outRun = false;
        while (runa || runb) {
            boolean adv_b;
            long va = runa ? a.r[ia] : 0L;
            long vb = runb ? b.r[ib] : 0L;
            Range ma = runa ? a.rr[ia >>> 1] : null;
            Range mb = runb ? b.rr[ib >>> 1] : null;
            boolean adv_a = runa && (!runb || va <= vb);
            boolean bl = adv_b = runb && (!runa || vb <= va);
            if (adv_a) {
                if ((ia & 1) == 1 && ia < a.sz - 1 && a.r[ia] == a.r[ia + 1]) {
                    ina = !ina;
                    ma = a.rr[++ia >>> 1];
                }
                ina = !ina;
                boolean bl2 = runa = ++ia != a.sz;
            }
            if (adv_b) {
                if ((ib & 1) == 1 && ib < b.sz - 1 && b.r[ib] == b.r[ib + 1]) {
                    inb = !inb;
                    mb = b.rr[++ib >>> 1];
                }
                inb = !inb;
                runb = ++ib != b.sz;
            }
            boolean testEqual = ia != 0 && ib != 0 || (!runa || !runb) && outRun;
            outRun = !runa || !runa;
            Range m = null;
            switch (op) {
                case 1: {
                    m = ina && !inb ? ma : (ina && inb ? ma.union(mb) : (!ina && inb ? mb : null));
                    break;
                }
                case 2: {
                    m = ina && inb ? ma.intersection(mb) : null;
                    break;
                }
                case 3: {
                    Range range = ina && !inb ? ma : (m = ina && inb ? ma.difference(mb) : null);
                }
            }
            if (!testEqual || !Range2.mocEquals(m, oldm)) {
                if ((res.sz & 1) != 0) {
                    res.push(adv_a ? va : vb, null);
                }
                if (m != null && !m.isEmpty()) {
                    res.push(adv_a ? va : vb, m);
                }
                oldm = m;
            }
            if (op != 2 || !outRun) continue;
            break;
        }
        return res;
    }

    private static boolean mocEquals(Range m1, Range m2) {
        if (m1 == m2) {
            return true;
        }
        if (m1 == null && m2 != null) {
            return m2.equals(m1);
        }
        return m1.equals(m2);
    }

    public Range2 union(Range2 other) {
        if (this.isEmpty()) {
            return new Range2(other);
        }
        if (other.isEmpty()) {
            return new Range2(this);
        }
        return Range2.operation(this, other, 1);
    }

    public Range2 intersection(Range2 other) {
        if (this.isEmpty() || other.isEmpty()) {
            return new Range2();
        }
        return Range2.operation(this, other, 2);
    }

    public Range2 difference(Range2 other) {
        if (this.isEmpty()) {
            return new Range2();
        }
        if (other.isEmpty()) {
            return new Range2(this);
        }
        return Range2.operation(this, other, 3);
    }

    private void add1(long a, long b, Range m1) {
        int j;
        boolean runb;
        int pos;
        int op = 1;
        Range2 ajout = new Range2(10);
        Range oldm = null;
        boolean ina = false;
        boolean inb = false;
        long[] inter = new long[]{a, b};
        for (pos = this.indexOf(a); pos >= 0 && this.r[pos] == a; --pos) {
        }
        if (pos < 0) {
            pos = 0;
        }
        if (pos > 0 && (pos & 1) == 1) {
            ++pos;
        }
        int ia = pos;
        int ib = 0;
        boolean runa = ia != this.sz;
        boolean bl = runb = ib != inter.length;
        while (runa || runb) {
            long v;
            boolean adv_b;
            long va = runa ? this.r[ia] : 0L;
            long vb = runb ? inter[ib] : 0L;
            Range ma = runa ? this.rr[ia >>> 1] : null;
            Range mb = m1;
            boolean adv_a = runa && (!runb || va <= vb);
            boolean bl2 = adv_b = runb && (!runa || vb <= va);
            if (adv_a) {
                if ((ia & 1) == 1 && ia < this.sz - 1 && this.r[ia] == this.r[ia + 1]) {
                    ina = !ina;
                    ma = this.rr[++ia >>> 1];
                }
                ina = !ina;
                boolean bl3 = runa = ++ia < this.sz && (this.r[ia] <= b || this.r[ia] > b && (ia & 1) == 1);
            }
            if (adv_b) {
                inb = !inb;
                runb = ++ib != inter.length;
            }
            Range m = null;
            switch (op) {
                case 1: {
                    m = ina && !inb ? ma : (ina && inb ? ma.union(mb) : (!ina && inb ? mb : null));
                    break;
                }
                case 2: {
                    m = ina && inb ? ma.intersection(mb) : null;
                    break;
                }
                case 3: {
                    Range range = ina && !inb ? ma : (m = ina && inb ? ma.difference(mb) : null);
                }
            }
            if (Range2.mocEquals(m, oldm)) continue;
            long l = v = adv_a ? va : vb;
            if ((ajout.sz & 1) != 0) {
                ajout.push(v, null);
            }
            if (m != null && !m.isEmpty()) {
                ajout.push(v, m);
            }
            oldm = m;
        }
        int diff = ajout.sz - (ia - pos);
        if (diff > 0) {
            this.ensureCapacity(this.sz + diff);
            for (j = this.sz - 1; j >= pos; --j) {
                this.r[j + diff] = this.r[j];
                if ((j & 1) != 1) continue;
                this.rr[j + diff >>> 1] = this.rr[j >>> 1];
            }
        }
        for (j = 0; j < ajout.sz; ++j) {
            this.r[pos + j] = ajout.r[j];
            if ((j & 1) != 0) continue;
            this.rr[pos + j >>> 1] = ajout.rr[j >>> 1];
        }
        if (diff < 0) {
            for (j = pos + ajout.sz; j < this.sz + diff; ++j) {
                this.r[j] = this.r[j - diff];
                if ((j & 1) != 0) continue;
                this.rr[j >>> 1] = this.rr[j - diff >>> 1];
            }
            while (j < this.sz) {
                this.rr[j >>> 1] = null;
                j += 2;
            }
        }
        this.sz += diff;
    }

    public boolean check() {
        Range oldm = null;
        for (int i = 0; i < this.sz - 1; i += 2) {
            if (this.r[i] >= this.r[i + 1]) {
                System.out.println("J'ai un probl\u00e8me i=" + i + " tmin=" + this.r[i] + ">=tmax=" + this.r[i + 1]);
                return false;
            }
            if (i > 1 && this.r[i] < this.r[i - 1]) {
                System.out.println("J'ai un probl\u00e8me i=" + i + " r[i]=" + this.r[i] + " < r[i-1]=" + this.r[i - 1]);
                return false;
            }
            if (this.rr[i >>> 1] == null) {
                System.out.println("J'ai un probl\u00e8me i=" + i + " smoc=null");
                return false;
            }
            if (i > 0 && this.r[i] == this.r[i - 1] && Range2.mocEquals(this.rr[i >>> 1], oldm)) {
                System.out.println("J'ai un probl\u00e8me i=" + i + " smoc[" + (i >>> 1) + "]=oldm=" + this.rr[i >>> 1]);
                return false;
            }
            oldm = this.rr[i >>> 1];
        }
        return true;
    }

    @Override
    public long getMem() {
        if (this.r == null) {
            return 0L;
        }
        long mem = super.getMem();
        for (int i = 0; i < this.sz / 2; ++i) {
            mem += this.rr[i].getMem();
        }
        return mem;
    }

    @Override
    public void intersect(long a, long b) {
        throw new IllegalArgumentException("not implemented yet");
    }

    public void add(long a, long b, Range m) {
        if (this.sz == 0 || a > this.r[this.sz - 1]) {
            this.append(a, b, m);
        } else {
            this.add1(a, b, m);
        }
    }

    @Override
    public void add(long a) {
        this.add(a, a + 1L, null);
    }

    @Override
    public void remove(long a, long b) {
        throw new IllegalArgumentException("not implemented yet");
    }

    @Override
    public void remove(long a) {
        this.remove(a, a + 1L);
    }
}

