/*
 * Decompiled with CFR 0.152.
 */
package cds.moc;

import cds.moc.Array;
import cds.moc.Moc;
import cds.moc.SMoc;
import cds.moc.STMoc;
import cds.moc.TMoc;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.StringTokenizer;

public final class MocIO {
    public static final int FITS = 0;
    public static final int ASCII = 2;
    public static final int JSON = 1;
    private static String CR = System.getProperty("line.separator");
    private String[][] FITSKEY = new String[][]{{"COORDSYS", "Reference frame"}, {"MOCORDER", "MOC resolution (best order)"}, {"MOCTOOL", "Name of the MOC generator"}, {"MOCTYPE", "Source type (IMAGE or CATALOG)"}, {"MOCID", "Identifier of the collection"}, {"ORIGIN", "MOC origin"}, {"DATE", "MOC creation date"}, {"EXTNAME", "MOC name"}};
    public static final String OLDSIGNATURE = "HPXMOC";
    public static final String SIGNATURE = "MOCORDER";
    private Moc moc;
    private byte firstChar = 0;

    public MocIO(Moc m) {
        this.moc = m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(String filename) throws Exception {
        File f = new File(filename);
        FileInputStream fi = null;
        BufferedInputStream bf = null;
        try {
            fi = new FileInputStream(f);
            bf = new BufferedInputStream(fi);
            this.read(bf);
        }
        finally {
            if (bf != null) {
                bf.close();
            } else if (fi != null) {
                fi.close();
            }
        }
    }

    public void read(String filename, int mode) throws Exception {
        this.read(filename);
    }

    public void read(InputStream in) throws Exception {
        byte[] b = new byte[1];
        in.read(b);
        this.firstChar = b[0];
        int mode = this.firstChar == 83 ? 0 : 2;
        this.read(in, mode);
    }

    public void read(InputStream in, int mode) throws Exception {
        if (mode == 0) {
            this.readFits(in);
        } else {
            this.readASCII(in);
        }
        this.moc.trim();
    }

    /*
     * Unable to fully structure code
     */
    public void readASCII(InputStream in) throws Exception {
        dis = new BufferedReader(new InputStreamReader(in));
        this.moc.clear();
        this.moc.setCheckConsistencyFlag(false);
        mocOrder = 29;
        flagTMoc = false;
        flagMocOrder = false;
        line = 0;
        while ((s = dis.readLine()) != null) {
            block13: {
                block14: {
                    if (this.firstChar != 0) {
                        s = (char)this.firstChar + s;
                        this.firstChar = 0;
                    }
                    if (s.length() == 0) break block13;
                    if (line != 0) ** GOTO lbl-1000
                    if (!s.startsWith("#MOCORDER ")) break block14;
                    v = s.substring(10);
                    if (v.length() > 0) {
                        flagMocOrder = true;
                        this.moc.setProperty("MOCORDER", v);
                    }
                    ** GOTO lbl-1000
                }
                if (s.startsWith("#TMOC")) {
                    v = s.substring(5);
                    try {
                        mocOrder = Integer.parseInt(v.trim());
                        if (mocOrder < 29) {
                            flagMocOrder = true;
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    flagTMoc = true;
                } else if (flagTMoc) {
                    this.parseTMocASCIILine(s);
                } else {
                    this.parseASCIILine(s);
                }
            }
            ++line;
        }
        this.moc.addHpix(null);
        if (!flagMocOrder) {
            this.moc.setMocOrder(this.moc.getMaxUsedOrder());
        }
        if (flagTMoc) {
            this.moc.toMocSet();
            if (mocOrder != 29) {
                this.moc.setMocOrder(mocOrder);
            }
        }
    }

    private void parseTMocASCIILine(String s) throws Exception {
        StringTokenizer st = new StringTokenizer(s, " ;,\n\r\t");
        while (st.hasMoreTokens()) {
            String s1 = st.nextToken();
            String s2 = st.nextToken();
            ((TMoc)this.moc).add(Double.parseDouble(s1), Double.parseDouble(s2));
        }
    }

    public void readFits(InputStream in) throws Exception {
        this.moc.clear();
        this.moc.setCheckConsistencyFlag(false);
        HeaderFits header = new HeaderFits();
        header.readHeader(in);
        String v = header.getStringFromHeader(OLDSIGNATURE);
        if (v != null) {
            this.moc.setProperty(SIGNATURE, v);
        }
        try {
            int nbyte;
            header.readHeader(in);
            v = header.getStringFromHeader(OLDSIGNATURE);
            if (v != null) {
                this.moc.setProperty(SIGNATURE, v);
            }
            for (int i = 0; i < this.FITSKEY.length; ++i) {
                String key = this.FITSKEY[i][0];
                String value = header.getStringFromHeader(key);
                if (value == null) continue;
                this.moc.setProperty(key, value);
            }
            int naxis1 = header.getIntFromHeader("NAXIS1");
            int naxis2 = header.getIntFromHeader("NAXIS2");
            String tform = header.getStringFromHeader("TFORM1");
            int n = tform.indexOf(75) >= 0 ? 8 : (nbyte = tform.indexOf(74) >= 0 ? 4 : -1);
            if (nbyte <= 0) {
                throw new Exception("Multi Order Coverage Map only requieres integers (32bits or 64bits)");
            }
            this.moc.readSpecificData(in, naxis1, naxis2, nbyte, header);
        }
        catch (EOFException e) {
            // empty catch block
        }
    }

    public void write(String filename) throws Exception {
        this.write(filename, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String filename, int mode) throws Exception {
        if (mode != 0 && mode != 2 && mode != 1) {
            throw new Exception("Unknown MOC format !");
        }
        File f = new File(filename);
        if (f.exists()) {
            f.delete();
        }
        FileOutputStream fo = null;
        FilterOutputStream fb = null;
        try {
            fo = new FileOutputStream(f);
            fb = new BufferedOutputStream(fo);
            if (mode == 0) {
                this.writeFits(fb);
            } else if (mode == 1) {
                this.writeJSON(fb);
            } else if (mode == 2) {
                this.writeASCII(fb);
            }
        }
        finally {
            if (fb != null) {
                fb.close();
            } else if (fo != null) {
                fo.close();
            }
        }
    }

    public void write(OutputStream out) throws Exception {
        this.write(out, 0);
    }

    public void write(OutputStream out, int mode) throws Exception {
        if (mode != 0 && mode != 2 && mode != 1) {
            throw new Exception("Unknown MOC format !");
        }
        if (mode == 0) {
            this.writeFits(out);
        } else if (mode == 1) {
            this.writeJSON(out);
        } else if (mode == 2) {
            this.writeASCII(out);
        }
    }

    private void testMocNotNull() throws Exception {
        if (this.moc == null) {
            throw new Exception("No MOC assigned (use setMoc(SMoc))");
        }
    }

    public void writeASCII(OutputStream out) throws Exception {
        this.testMocNotNull();
        this.moc.writeASCII(out);
    }

    public void writeJSON(OutputStream out) throws Exception {
        this.testMocNotNull();
        if (this.moc instanceof STMoc) {
            throw new Exception("JSON format not supported for STMoc");
        }
        out.write(CR.getBytes());
        StringBuilder s = new StringBuilder(2048);
        int nOrder = this.moc.getMaxUsedOrder() + 1;
        s.append("{");
        boolean first = true;
        for (int order = 0; order < nOrder; ++order) {
            int n = ((SMoc)this.moc).getSize(order);
            if (n == 0 && order < nOrder - 1) continue;
            Array a = ((SMoc)this.moc).getArray(order);
            if (!first) {
                s.append("]," + CR);
            }
            first = false;
            s.append("\"" + order + "\":[");
            int j = 0;
            for (int i = 0; i < n; ++i) {
                s.append(a.get(i) + (i == n - 1 ? "" : ","));
                if (++j != 15) continue;
                Moc.writeASCIIFlush(out, s);
                j = 0;
            }
        }
        if (!first) {
            s.append("]");
        }
        s.append("}");
        Moc.writeASCIIFlush(out, s);
    }

    public void writeFits(OutputStream out) throws Exception {
        this.testMocNotNull();
        this.writeHeader0(out);
        this.writeHeader1(out);
        this.writeData(out);
    }

    private void setCurrentParseOrder(String s) throws Exception {
        int i = s.indexOf(61);
        try {
            this.moc.setCurrentOrder((int)SMoc.log2(Long.parseLong(s.substring(i + 1))));
        }
        catch (Exception e) {
            throw new Exception("HpixList.setNside: syntax error [" + s + "]");
        }
    }

    private void setOrder(String s) throws Exception {
        int i = s.indexOf(61);
        if (s.charAt(i - 1) == 'R') {
            try {
                this.moc.setCurrentOrder(Integer.parseInt(s.substring(i + 1)));
            }
            catch (Exception e) {
                throw new Exception("HpixList.setOrder: syntax error [" + s + "]");
            }
            return;
        }
    }

    private void setCoord(String s) throws Exception {
        int i = s.indexOf(61);
        ((SMoc)this.moc).setSys(s.substring(i + 1));
    }

    private void parseASCIILine(String s) throws Exception {
        char a = s.charAt(0);
        if (a == '#') {
            return;
        }
        if (a == 'N') {
            this.setCurrentParseOrder(s);
        } else if (a == 'C') {
            this.setCoord(s);
        } else if (a == 'O') {
            this.setOrder(s);
        } else {
            StringTokenizer st = new StringTokenizer(s, " ;,\n\r\t{}");
            while (st.hasMoreTokens()) {
                String s1 = st.nextToken();
                if (s1.length() == 0) continue;
                this.moc.addHpix(s1);
            }
        }
    }

    private void writeHeader0(OutputStream out) throws Exception {
        int n = 0;
        out.write(MocIO.getFitsLine("SIMPLE", "T", "Written by MOC java API 7.0"));
        n += 80;
        out.write(this.getFitsLine("BITPIX", "8"));
        n += 80;
        out.write(this.getFitsLine("NAXIS", "0"));
        n += 80;
        out.write(this.getFitsLine("EXTEND", "T"));
        out.write(this.getEndBourrage(n += 80));
    }

    private void writeHeader1(OutputStream out) throws Exception {
        int n = 0;
        int nbytes = this.moc.getType() == 2 ? 8 : 4;
        int naxis2 = this.moc.getSize();
        out.write(MocIO.getFitsLine("XTENSION", "BINTABLE", "Multi Order Coverage map"));
        n += 80;
        out.write(this.getFitsLine("BITPIX", "8"));
        n += 80;
        out.write(this.getFitsLine("NAXIS", "2"));
        n += 80;
        out.write(this.getFitsLine("NAXIS1", nbytes + ""));
        n += 80;
        out.write(this.getFitsLine("NAXIS2", "" + naxis2));
        n += 80;
        out.write(this.getFitsLine("PCOUNT", "0"));
        n += 80;
        out.write(this.getFitsLine("GCOUNT", "1"));
        n += 80;
        out.write(this.getFitsLine("TFIELDS", "1"));
        n += 80;
        out.write(this.getFitsLine("TFORM1", nbytes == 4 ? "1J" : "1K"));
        n += 80;
        n += this.moc.writeSpecificFitsProp(out);
        out.write(MocIO.getFitsLine("MOCTOOL", "CDSjavaAPI-7.0", "Name of the MOC generator"));
        n += 80;
        for (int i = 0; i < this.FITSKEY.length; ++i) {
            String value;
            String key = this.FITSKEY[i][0];
            if (key.equals("COORDSYS") || key.equals(SIGNATURE) || key.equals("MOCTOOL") || (value = this.moc.getProperty(key)) == null) continue;
            out.write(MocIO.getFitsLine(key, value, this.FITSKEY[i][1]));
            n += 80;
        }
        out.write(this.getEndBourrage(n));
    }

    protected void writeData(OutputStream out) throws Exception {
        int size = this.moc.writeSpecificData(out);
        out.write(MocIO.getBourrage(size));
    }

    protected static int writeVal(OutputStream out, long val, byte[] buf) throws Exception {
        int j = 0;
        int shift = (buf.length - 1) * 8;
        while (j < buf.length) {
            buf[j] = (byte)(0xFFL & val >> shift);
            ++j;
            shift -= 8;
        }
        out.write(buf);
        return buf.length;
    }

    private byte[] getFitsLine(String key, String value) {
        return MocIO.getFitsLine(key, value, null);
    }

    protected static byte[] getFitsLine(String key, String value, String comment) {
        int i;
        byte[] b = new byte[80];
        char[] a = key.toCharArray();
        int j = 0;
        for (i = 0; i < 8; ++i) {
            b[i] = (byte)(j < a.length ? a[j] : 32);
            ++j;
        }
        if (value != null) {
            b[i++] = 61;
            b[i++] = 32;
            a = value.toCharArray();
            if (!MocIO.isFitsString(value)) {
                for (j = 0; j < 20 - a.length; ++j) {
                    b[i++] = 32;
                }
                for (j = 0; i < 80 && j < a.length; ++j, ++i) {
                    b[i] = (byte)a[j];
                }
            } else {
                a = MocIO.formatFitsString(a);
                for (j = 0; i < 80 && j < a.length; ++j, ++i) {
                    b[i] = (byte)a[j];
                }
                while (i < 30) {
                    b[i++] = 32;
                }
            }
        }
        if (comment != null && comment.length() > 0) {
            if (value != null) {
                b[i++] = 32;
                b[i++] = 47;
                b[i++] = 32;
            }
            a = comment.toCharArray();
            for (j = 0; i < 80 && j < a.length; ++j, ++i) {
                b[i] = (byte)a[j];
            }
        }
        while (i < 80) {
            b[i++] = 32;
        }
        return b;
    }

    private byte[] getEndBourrage(int headSize) {
        int size = 2880 - headSize % 2880;
        if (size < 3) {
            size += 2880;
        }
        byte[] b = new byte[size];
        b[0] = 69;
        b[1] = 78;
        b[2] = 68;
        for (int i = 3; i < b.length; ++i) {
            b[i] = 32;
        }
        return b;
    }

    protected static byte[] getBourrage(int currentPos) {
        int size = 2880 - currentPos % 2880;
        byte[] b = new byte[size];
        return b;
    }

    public static void readFully(InputStream in, byte[] buf) throws IOException {
        MocIO.readFully(in, buf, 0, buf.length);
    }

    public static void readFully(InputStream in, byte[] buf, int offset, int len) throws IOException {
        int m;
        for (int n = 0; n < len; n += m) {
            m = in.read(buf, offset + n, len - n < 512 ? len - n : 512);
            if (m != -1) continue;
            throw new EOFException();
        }
    }

    private static boolean isFitsString(String s) {
        if (s.length() == 0) {
            return true;
        }
        char c = s.charAt(0);
        if (s.length() == 1 && (c == 'T' || c == 'F')) {
            return false;
        }
        if (!Character.isDigit(c) && c != '.' && c != '-' && c != '+') {
            return true;
        }
        try {
            Double.valueOf(s);
            return false;
        }
        catch (Exception e) {
            return true;
        }
    }

    private static char[] formatFitsString(char[] a) {
        int i;
        if (a.length == 0) {
            return a;
        }
        StringBuffer s = new StringBuffer();
        boolean flagQuote = a[0] == '\'';
        s.append('\'');
        for (i = flagQuote ? 1 : 0; i < a.length - (flagQuote ? 1 : 0); ++i) {
            if (!flagQuote && a[i] == '\'') {
                s.append('\'');
            }
            s.append(a[i]);
        }
        while (i < (flagQuote ? 9 : 8)) {
            s.append(' ');
            ++i;
        }
        s.append('\'');
        return s.toString().toCharArray();
    }

    class HeaderFits {
        private Hashtable<String, String> header;
        private int sizeHeader = 0;

        HeaderFits() {
        }

        private String getValue(byte[] buffer) {
            int offset;
            int i;
            boolean quote = false;
            boolean blanc = true;
            for (i = offset = 9; i < 80 && !(quote ? buffer[i] == 39 : buffer[i] == 47); ++i) {
                if (!blanc) continue;
                if (buffer[i] != 32) {
                    blanc = false;
                }
                if (buffer[i] != 39) continue;
                quote = true;
                offset = i + 1;
            }
            return new String(buffer, 0, offset, i - offset).trim();
        }

        private String getKey(byte[] buffer) {
            return new String(buffer, 0, 0, 8).trim();
        }

        private void readHeader(InputStream dis) throws Exception {
            int blocksize = 2880;
            int fieldsize = 80;
            int linesRead = 0;
            this.sizeHeader = 0;
            this.header = new Hashtable(200);
            byte[] buffer = new byte[fieldsize];
            while (true) {
                if (MocIO.this.firstChar == 0) {
                    MocIO.readFully(dis, buffer);
                } else {
                    buffer[0] = MocIO.this.firstChar;
                    MocIO.this.firstChar = (byte)0;
                    MocIO.readFully(dis, buffer, 1, buffer.length - 1);
                }
                String key = this.getKey(buffer);
                if (linesRead == 0 && !key.equals("SIMPLE") && !key.equals("XTENSION")) {
                    throw new Exception("Not a MOC FITS format");
                }
                this.sizeHeader += fieldsize;
                ++linesRead;
                if (key.equals("END")) break;
                if (buffer[8] != 61) continue;
                String value = this.getValue(buffer);
                this.header.put(key, value);
            }
            int bourrage = blocksize - this.sizeHeader % blocksize;
            if (bourrage != blocksize) {
                byte[] tmp = new byte[bourrage];
                MocIO.readFully(dis, tmp);
                this.sizeHeader += bourrage;
            }
        }

        public int getIntFromHeader(String key) throws NumberFormatException, NullPointerException {
            String s = this.header.get(key.trim());
            return (int)Double.parseDouble(s.trim());
        }

        public String getStringFromHeader(String key) throws NullPointerException {
            String s = this.header.get(key.trim());
            if (s == null || s.length() == 0) {
                return s;
            }
            if (s.charAt(0) == '\'') {
                return s.substring(1, s.length() - 1).trim();
            }
            return s;
        }
    }
}

