/*
 * Decompiled with CFR 0.152.
 */
package cds.moc;

import cds.moc.MocCell;
import cds.moc.MocIO;
import cds.moc.Range;
import cds.moc.SMoc;
import cds.moc.STMoc;
import cds.moc.TMoc;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;

public abstract class Moc
implements Iterable<MocCell>,
Cloneable,
Comparable<Moc> {
    public static final String VERSION = "7.0";
    public static final int FITS = 0;
    public static final int JSON = 1;
    public static final int ASCII = 2;
    public static final int MAXORDER = 29;
    protected HashMap<String, String> property;
    protected static final int MAXWORD = 20;
    protected static final int MAXSIZE = 80;
    protected static String CR = System.getProperty("line.separator");

    public static Moc createMoc(String s) throws Exception {
        if (s == null) {
            throw new Exception("null string");
        }
        if (s.charAt(0) == 't') {
            if (s.indexOf(115) < 0) {
                return new TMoc(s.substring(1));
            }
            return new STMoc(s);
        }
        if (s.charAt(0) == 's') {
            s = s.substring(1);
        }
        return new SMoc(s);
    }

    protected abstract int getType();

    public abstract Moc clone();

    public abstract void clear();

    public abstract void setMocOrder(int var1) throws Exception;

    public abstract int getMocOrder();

    public abstract int getTimeOrder();

    public abstract int getSpaceOrder();

    public abstract void setTimeOrder(int var1) throws Exception;

    public abstract void setSpaceOrder(int var1) throws Exception;

    public abstract boolean isSpace();

    public abstract boolean isTime();

    public abstract SMoc getSpaceMoc() throws Exception;

    public abstract TMoc getTimeMoc() throws Exception;

    public abstract long getMem();

    public abstract int getSize();

    public abstract void add(String var1) throws Exception;

    public abstract void add(Moc var1) throws Exception;

    public abstract void check() throws Exception;

    public abstract void setProperty(String var1, String var2) throws Exception;

    public String getProperty(String key) {
        return this.property.get(key);
    }

    public abstract void accretion() throws Exception;

    public abstract boolean isIntersecting(Moc var1);

    public abstract Moc union(Moc var1) throws Exception;

    public abstract Moc intersection(Moc var1) throws Exception;

    public abstract Moc subtraction(Moc var1) throws Exception;

    public abstract boolean isEmpty();

    public abstract boolean isFull();

    @Override
    public abstract Iterator<MocCell> iterator();

    public abstract Range getRange();

    public abstract String getSys();

    public abstract int getMaxUsedOrder();

    public abstract void setCheckConsistencyFlag(boolean var1) throws Exception;

    public abstract void toMocSet() throws Exception;

    public abstract void trim();

    public String toString() {
        try {
            return this.toASCII();
        }
        catch (Exception e) {
            return null;
        }
    }

    protected abstract void addHpix(String var1) throws Exception;

    protected abstract void setCurrentOrder(int var1);

    public void read(String filename) throws Exception {
        new MocIO(this).read(filename);
    }

    public void read(String filename, int mode) throws Exception {
        new MocIO(this).read(filename, mode);
    }

    public void read(InputStream in) throws Exception {
        new MocIO(this).read(in);
    }

    public void read(InputStream in, int mode) throws Exception {
        new MocIO(this).read(in, mode);
    }

    public void readASCII(InputStream in) throws Exception {
        new MocIO(this).read(in, 2);
    }

    public void readJSON(InputStream in) throws Exception {
        new MocIO(this).read(in, 1);
    }

    public void readFits(InputStream in) throws Exception {
        new MocIO(this).read(in, 0);
    }

    public void write(String filename) throws Exception {
        this.check();
        new MocIO(this).write(filename);
    }

    public void write(String filename, int mode) throws Exception {
        this.check();
        new MocIO(this).write(filename, mode);
    }

    public void write(OutputStream out, int mode) throws Exception {
        this.check();
        new MocIO(this).write(out, mode);
    }

    public void writeJSON(OutputStream out) throws Exception {
        this.check();
        new MocIO(this).writeJSON(out);
    }

    public void writeFits(OutputStream out) throws Exception {
        this.writeFITS(out);
    }

    public void writeFITS(OutputStream out) throws Exception {
        this.check();
        new MocIO(this).writeFits(out);
    }

    protected abstract int writeSpecificFitsProp(OutputStream var1) throws Exception;

    protected abstract int writeSpecificData(OutputStream var1) throws Exception;

    protected abstract void readSpecificData(InputStream var1, int var2, int var3, int var4, MocIO.HeaderFits var5) throws Exception;

    public String toASCII() throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.writeASCII(out);
        return out.toString();
    }

    public void writeASCII(OutputStream out) throws Exception {
        boolean flagNL = this.getRange().sz > 20;
        int order = Moc.writeASCII(out, this.getRange(), flagNL);
        StringBuilder res = new StringBuilder(10);
        int mocOrder = this.getMocOrder();
        if (order < mocOrder) {
            if (flagNL) {
                res.append(CR);
            } else {
                res.append(' ');
            }
            res.append(mocOrder + "/");
        }
        if (flagNL) {
            res.append('\n');
        }
        Moc.writeASCIIFlush(out, res, false);
    }

    protected static int writeASCII(OutputStream out, Range range, boolean flagNL) throws Exception {
        if (range.isEmpty()) {
            return -1;
        }
        StringBuilder res = new StringBuilder(50000);
        int order = -1;
        int sizeLine = 0;
        int j = 0;
        Range r2 = new Range(range);
        Range r3 = new Range();
        for (int o = 0; o <= 29 && !r2.isEmpty(); ++o) {
            int shift = 2 * (29 - o);
            long ofs = (1L << shift) - 1L;
            r3.clear();
            int nranges = r2.sz;
            for (int i = 0; i < nranges; i += 2) {
                long a = r2.r[i] + ofs >>> shift;
                long b = r2.r[i + 1] >>> shift;
                if (a >= b) continue;
                r3.append(a << shift, b << shift);
                StringBuilder s = new StringBuilder(100);
                if (o != order) {
                    s.append(o + "/");
                    order = o;
                }
                s.append(a + "");
                if (b > a + 1L) {
                    s.append("-" + (b - 1L));
                }
                if (res.length() > 0) {
                    if (o != order) {
                        if (flagNL) {
                            res.append(CR);
                            sizeLine = 0;
                            ++j;
                        } else {
                            res.append(" ");
                        }
                    } else if (flagNL && s.length() + sizeLine > 80) {
                        res.append(CR + " ");
                        sizeLine = 1;
                        ++j;
                    } else {
                        res.append(' ');
                        ++sizeLine;
                    }
                    if (j > 15) {
                        Moc.writeASCIIFlush(out, res, false);
                        j = 0;
                    }
                }
                res.append((CharSequence)s);
                sizeLine += s.length();
            }
            if (r3.isEmpty()) continue;
            r2 = r2.difference(r3);
        }
        Moc.writeASCIIFlush(out, res, false);
        return order;
    }

    protected static void writeASCIIFlush(OutputStream out, StringBuilder s) throws Exception {
        Moc.writeASCIIFlush(out, s, true);
    }

    protected static void writeASCIIFlush(OutputStream out, StringBuilder s, boolean nl) throws Exception {
        if (nl) {
            s.append(CR);
        }
        out.write(s.toString().getBytes());
        s.delete(0, s.length());
    }

    public static long hpix2uniq(int order, long npix) {
        long nside = Moc.pow2(order);
        return 4L * nside * nside + npix;
    }

    public static long[] uniq2hpix(long uniq) {
        return Moc.uniq2hpix(uniq, null);
    }

    public static long[] uniq2hpix(long uniq, long[] hpix) {
        if (hpix == null) {
            hpix = new long[2];
        }
        hpix[0] = Moc.log2(uniq / 4L) / 2L;
        long nside = Moc.pow2(hpix[0]);
        hpix[1] = uniq - 4L * nside * nside;
        return hpix;
    }

    public static final long pow2(long order) {
        return 1 << (int)order;
    }

    public static final long log2(long nside) {
        int i = 0;
        while (nside >>> ++i > 0L) {
        }
        return --i;
    }

    @Override
    public int compareTo(Moc o) {
        if (o == null) {
            return 1;
        }
        return this.getSize() - o.getSize();
    }
}

