/*
 * Decompiled with CFR 0.152.
 */
package cds.moc;

import cds.moc.HealpixImpl;
import cds.moc.Moc;
import cds.moc.SMoc;
import java.io.InputStream;

public class HealpixMoc
extends SMoc {
    public HealpixMoc(Moc smoc) throws Exception {
        super(smoc);
    }

    public HealpixMoc() {
    }

    public HealpixMoc(int maxLimitOrder) throws Exception {
        super(maxLimitOrder);
    }

    public HealpixMoc(int minLimitOrder, int maxLimitOrder) throws Exception {
        super("C", minLimitOrder, maxLimitOrder);
    }

    public HealpixMoc(String coordSys, int minLimitOrder, int maxLimitOrder) throws Exception {
        super(coordSys, minLimitOrder, maxLimitOrder);
    }

    public HealpixMoc(String s) throws Exception {
        super(s);
    }

    public HealpixMoc(InputStream in) throws Exception {
        super(in);
    }

    public HealpixMoc(InputStream in, int mode) throws Exception {
        super(in, mode);
    }

    public boolean contains(HealpixImpl healpix, double alpha, double delta) throws Exception {
        int order = this.getMaxUsedOrder();
        if (order == -1) {
            return false;
        }
        long npix = healpix.ang2pix(order, alpha, delta);
        if (this.level[order].find(npix) >= 0) {
            return true;
        }
        return this.isDescendant(order, npix);
    }

    public SMoc queryDisc(HealpixImpl healpix, double alpha, double delta, double radius) throws Exception {
        int order = this.getMaxUsedOrder();
        long[] list = healpix.queryDisc(order, alpha, delta, radius);
        SMoc mocA = new SMoc(this.sys, this.minOrder, this.mocOrder);
        mocA.add(order, list);
        return (SMoc)this.intersection(mocA);
    }
}

